/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.concern.ConcernDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.AbstractMenuContributionItem;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.ResetToDefaultFiltersAction;
import org.eclipse.sirius.diagram.ui.tools.internal.handler.ChangeFilterActivation;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.swt.graphics.Image;

public class FiltersContributionItem
extends AbstractMenuContributionItem {
    private static final ImageDescriptor DESC_FILTER = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/filters.gif");

    @Override
    protected Image getMenuImage() {
        return this.getImage();
    }

    private Image getImage() {
        EObject diagram;
        Diagram gmfDiagram = this.part.getDiagram();
        if (gmfDiagram != null && (diagram = gmfDiagram.getElement()) instanceof DDiagram) {
            super.setDiagram((DDiagram)diagram);
            if (!((DDiagram)diagram).getActivatedFilters().isEmpty()) {
                return DiagramUIPlugin.Implementation.getDecoratedCheckedImage(DESC_FILTER);
            }
        }
        return DiagramUIPlugin.getPlugin().getImage(DESC_FILTER);
    }

    @Override
    protected String getLabel() {
        return Messages.FiltersContributionItem_label;
    }

    @Override
    protected void menuShow(IMenuManager manager) {
        for (FilterDescription filter : this.getFilters()) {
            this.addFilterMenuItem(manager, filter);
        }
        ConcernDescription defaultConcern = this.diagram.getDescription().getDefaultConcern();
        if (defaultConcern != null) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new ResetToDefaultFiltersAction(this.session.getTransactionalEditingDomain(), this.diagram));
        }
    }

    private Collection<FilterDescription> getFilters() {
        DiagramDescription diagramDesc = this.diagram.getDescription();
        return diagramDesc.getFilters();
    }

    private void addFilterMenuItem(IMenuManager manager, FilterDescription filter) {
        boolean isActive = this.isActive(filter);
        String nameEntry = MessageTranslator.INSTANCE.getMessage((EObject)filter, new IdentifiedElementQuery((IdentifiedElement)filter).getLabel());
        RunnableAction action = new RunnableAction(nameEntry, 2, new ChangeFilterActivation(this.part, this.diagram, filter, !isActive));
        action.setChecked(isActive);
        manager.add((IAction)action);
    }

    private boolean isActive(FilterDescription filter) {
        EList activatedFilters = this.diagram.getActivatedFilters();
        return activatedFilters.contains(filter);
    }

    private static class RunnableAction
    extends Action {
        private final Runnable runnable;

        RunnableAction(String text, int style, Runnable runnable) {
            super(text, style);
            this.runnable = runnable;
        }

        public void run() {
            this.runnable.run();
        }
    }
}

