/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.core.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.operations.AbstractModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.util.ModelsUtil;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundModelOperation<T>
extends AbstractModelOperation<List<T>> {
    private final List<IModelOperation<? extends T>> _subOperations;

    public CompoundModelOperation(String name_p, List<? extends IModelOperation<? extends T>> subOperations_p, ResourceSet rset_p, Object targetContext_p, Object sourceContext_p) {
        super(name_p, rset_p, CompoundModelOperation.isDirtying(subOperations_p), CompoundModelOperation.isReadOnly(subOperations_p), CompoundModelOperation.isExpensive(subOperations_p), targetContext_p, sourceContext_p);
        this._subOperations = new ArrayList<IModelOperation<T>>(subOperations_p);
    }

    @Override
    protected int getWorkAmount() {
        int result = -1;
        for (IModelOperation<? extends T> iModelOperation : this._subOperations) {
            int current;
            if (!(iModelOperation instanceof AbstractModelOperation) || (current = ((AbstractModelOperation)iModelOperation).getWorkAmount()) == -1) continue;
            if (result == -1) {
                result = current;
                continue;
            }
            result += current;
        }
        return result;
    }

    @Override
    protected List<T> run() {
        ModelsUtil.RList result = new ModelsUtil.RList();
        for (IModelOperation<? extends T> iModelOperation : this._subOperations) {
            Object localResult = this.call((AbstractModelOperation)iModelOperation);
            if (localResult == null) continue;
            result.add(localResult);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public <U> U call(AbstractModelOperation<? extends U> operation_p) {
        operation_p.setModelEnvironment(this.getModelEnvironment());
        return operation_p.run((IProgressMonitor)this.getMonitor());
    }

    private static boolean isDirtying(List<? extends IModelOperation<?>> subOperations_p) {
        for (IModelOperation<?> subOperation : subOperations_p) {
            if (!subOperation.isDirtying()) continue;
            return true;
        }
        return false;
    }

    private static boolean isExpensive(List<? extends IModelOperation<?>> subOperations_p) {
        for (IModelOperation<?> subOperation : subOperations_p) {
            if (!subOperation.isExpensive()) continue;
            return true;
        }
        return false;
    }

    private static boolean isReadOnly(List<? extends IModelOperation<?>> subOperations_p) {
        for (IModelOperation<?> subOperation : subOperations_p) {
            if (subOperation.isReadOnly()) continue;
            return false;
        }
        return true;
    }
}

