/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.eval;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.query.legacy.ecore.tools.ETools;
import org.eclipse.sirius.query.legacy.gen.template.eval.StringComparator;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;

public class TextModelMapping {
    protected Map pos2EObject = new TreeMap(new InversePosComparator());
    protected Map eObject2Positions = new HashMap();
    protected Map eObject2CommentPositions = new HashMap();
    protected Map pos2LinkEObject = new TreeMap(new InversePosComparator());
    protected List[] highlightedPos = new List[2];
    public static final int HIGHLIGHTED_DEFAULT = -1;
    public static final int HIGHLIGHTED_STATIC_TEXT = 0;
    public static final int HIGHLIGHTED_COMMENT = 1;
    protected EObject object;
    protected int shift;
    protected boolean commit = false;
    protected EObject linkEObject = null;
    private Map index2EObjects = new HashMap();
    private Map index2LinkEObject = new HashMap();

    public TextModelMapping(EObject object, boolean freeze) {
        this.object = object;
        int i = 0;
        while (i < this.highlightedPos.length) {
            if (this.highlightedPos[i] == null) {
                this.highlightedPos[i] = new ArrayList();
            }
            ++i;
        }
        if (freeze) {
            this.commit = true;
        } else {
            this.reset();
        }
    }

    protected void reset() {
        if (!this.commit) {
            this.shift = 0;
            this.pos2EObject.clear();
            this.index2EObjects.clear();
            this.eObject2Positions.clear();
            this.eObject2CommentPositions.clear();
            this.pos2LinkEObject.clear();
            this.index2LinkEObject.clear();
            int i = 0;
            while (i < this.highlightedPos.length) {
                if (this.highlightedPos[i] != null) {
                    this.highlightedPos[i].clear();
                } else {
                    this.highlightedPos[i] = new ArrayList();
                }
                ++i;
            }
        }
    }

    public void from(TextModelMapping other) {
        if (!this.commit && other != null) {
            EObject object;
            int e;
            int b;
            for (Map.Entry entry : other.pos2EObject.entrySet()) {
                b = this.shift + ((Int2)entry.getKey()).b();
                e = this.shift + ((Int2)entry.getKey()).e();
                object = (EObject)entry.getValue();
                this.addMapping(object, b, e);
            }
            for (Map.Entry entry : other.eObject2CommentPositions.entrySet()) {
                List value = (List)entry.getValue();
                for (Int2 pos : value) {
                    int b2 = this.shift + pos.b();
                    int e2 = this.shift + pos.e();
                    EObject object2 = (EObject)entry.getKey();
                    this.addCommentMapping(object2, b2, e2);
                }
            }
            for (Map.Entry entry : other.pos2LinkEObject.entrySet()) {
                b = this.shift + ((Int2)entry.getKey()).b();
                e = this.shift + ((Int2)entry.getKey()).e();
                object = (EObject)entry.getValue();
                this.pos2LinkEObject.put(new Int2(b, e), object);
            }
            int i = 0;
            while (i < other.highlightedPos.length) {
                for (Int2 pos : other.highlightedPos[i]) {
                    this.highlightedPos[i].add(new Int2(this.shift + pos.b(), this.shift + pos.e()));
                }
                ++i;
            }
            this.shift += other.shift;
        }
    }

    public Set getEObjects() {
        return this.eObject2Positions.keySet();
    }

    public void shift(int size) {
        this.shift(size, -1);
    }

    public void shift(int size, int highlightedType) {
        if (!this.commit) {
            Int2 pos;
            if (this.linkEObject != null) {
                pos = new Int2(this.shift, this.shift + size);
                this.pos2LinkEObject.put(pos, this.linkEObject);
            }
            if (highlightedType == 0) {
                pos = new Int2(this.shift, this.shift + size);
                this.highlightedPos[0].add(pos);
            } else if (highlightedType == 1) {
                pos = new Int2(this.shift, this.shift + size);
                this.highlightedPos[1].add(pos);
                this.addCommentMapping(this.object, pos.b(), pos.e());
            }
            this.shift += size;
        }
    }

    protected void addMapping(EObject object, int begin, int end) {
        if (begin > -1 && end > -1) {
            ArrayList objectPositions;
            Int2 newPos = new Int2(begin, end);
            if (!this.pos2EObject.containsKey(newPos)) {
                this.pos2EObject.put(newPos, object);
            }
            if ((objectPositions = (ArrayList)this.eObject2Positions.get(object)) == null) {
                objectPositions = new ArrayList();
                this.eObject2Positions.put(object, objectPositions);
            }
            this.add(objectPositions, begin, end);
        }
    }

    protected void addCommentMapping(EObject object, int begin, int end) {
        if (begin > -1 && end > -1) {
            ArrayList commentPositions = (ArrayList)this.eObject2CommentPositions.get(object);
            if (commentPositions == null) {
                commentPositions = new ArrayList();
                this.eObject2CommentPositions.put(object, commentPositions);
            }
            this.add(commentPositions, begin, end);
        }
    }

    private void add(List positions, int begin, int end) {
        boolean insert = false;
        Iterator it = positions.iterator();
        while (!insert && it.hasNext()) {
            Int2 pos = (Int2)it.next();
            if (begin <= pos.e() && begin >= pos.b()) {
                if (end > pos.e()) {
                    positions.remove(pos);
                    this.add(positions, pos.b(), end);
                }
                insert = true;
                continue;
            }
            if (end >= pos.b() && end <= pos.e()) {
                if (begin < pos.b()) {
                    positions.remove(pos);
                    this.add(positions, begin, pos.e());
                }
                insert = true;
                continue;
            }
            if (begin >= pos.b() || end <= pos.e()) continue;
            positions.remove(pos);
            this.add(positions, begin, end);
            insert = true;
        }
        if (!insert) {
            positions.add(new Int2(begin, end));
        }
    }

    public void linkBegin(EObject linkEObject) {
        this.linkEObject = linkEObject;
    }

    public void linkEnd() {
        this.linkEObject = null;
    }

    protected void commit() {
        if (!this.commit) {
            this.commit = true;
            this.addMapping(this.object, 0, this.shift);
        }
    }

    public EObject index2EObject(int index) {
        List eObjects = this.index2EObjects(index);
        EObject res = null;
        if (eObjects != null && eObjects.size() > 0) {
            res = (EObject)eObjects.get(0);
        }
        return res;
    }

    public List index2EObjects(int index) {
        ArrayList eObjects = (ArrayList)this.index2EObjects.get(new Integer(index));
        if (eObjects == null) {
            eObjects = new ArrayList();
            if (!this.commit) {
                this.commit();
            }
            for (Map.Entry entry : this.pos2EObject.entrySet()) {
                int e;
                int b = ((Int2)entry.getKey()).b();
                if (index < b || index >= (e = ((Int2)entry.getKey()).e())) continue;
                eObjects.add(entry.getValue());
            }
            this.index2EObjects.put(new Integer(index), eObjects);
        }
        return eObjects;
    }

    @Deprecated
    public Map position2uriSerializableMap() {
        TreeMap<Int2, String> result = new TreeMap<Int2, String>(new InversePosComparator());
        if (!this.commit) {
            this.commit();
        }
        for (Map.Entry entry : this.pos2EObject.entrySet()) {
            Int2 pos = (Int2)entry.getKey();
            EObject object = (EObject)entry.getValue();
            String uriFragment = ETools.getURI(object);
            result.put(pos, uriFragment);
        }
        return result;
    }

    public Int2[] eObject2Positions(EObject object) {
        List positions;
        if (object == null) {
            return new Int2[0];
        }
        if (!this.commit) {
            this.commit();
        }
        if ((positions = (List)this.eObject2Positions.get(object)) != null) {
            return positions.toArray(new Int2[positions.size()]);
        }
        return new Int2[0];
    }

    @Deprecated
    public Map uri2positionsSerializableMap() {
        TreeMap<String, Int2[]> result = new TreeMap<String, Int2[]>(new StringComparator());
        if (!this.commit) {
            this.commit();
        }
        for (Map.Entry entry : this.eObject2Positions.entrySet()) {
            EObject object = (EObject)entry.getKey();
            String uriFragment = ETools.getURI(object);
            TreeSet positions = new TreeSet(new PosComparator());
            positions.addAll((List)entry.getValue());
            result.put(uriFragment, positions.toArray(new Int2[positions.size()]));
        }
        return result;
    }

    public Int2 eObject2CommentPositionIn(EObject object, Int2 limits) {
        List positions;
        if (object == null) {
            return Int2.NOT_FOUND;
        }
        if (!this.commit) {
            this.commit();
        }
        if ((positions = (List)this.eObject2CommentPositions.get(object)) != null) {
            for (Int2 pos : positions) {
                if (pos.b() < limits.b() || pos.e() > limits.e()) continue;
                return pos;
            }
        }
        return Int2.NOT_FOUND;
    }

    public EObject index2LinkEObject(int index) {
        EObject object = (EObject)this.index2LinkEObject.get(new Integer(index));
        if (object == null) {
            if (!this.commit) {
                this.commit();
            }
            Iterator it = this.pos2LinkEObject.entrySet().iterator();
            while (object == null && it.hasNext()) {
                int e;
                Map.Entry entry = it.next();
                int b = ((Int2)entry.getKey()).b();
                if (index < b || index >= (e = ((Int2)entry.getKey()).e())) continue;
                object = (EObject)entry.getValue();
            }
            this.index2LinkEObject.put(new Integer(index), object);
        }
        return object;
    }

    public Int2[] getHighlightedPos(int highlightedType) {
        if (highlightedType == 0) {
            return this.highlightedPos[0].toArray(new Int2[0]);
        }
        if (highlightedType == 1) {
            return this.highlightedPos[1].toArray(new Int2[0]);
        }
        return new Int2[0];
    }

    public void range(Int2 range) {
        if (!this.commit) {
            Int2 pos;
            Iterator positions;
            List value;
            Int2 copy;
            Int2 pos2;
            Map.Entry entry2;
            this.shift = range.e() - range.b();
            Iterator it = this.pos2EObject.entrySet().iterator();
            while (it.hasNext()) {
                entry2 = it.next();
                pos2 = (Int2)entry2.getKey();
                copy = new Int2(pos2.b(), pos2.e());
                copy.range(range);
                if (copy.b() == -1 || !copy.equals(pos2) && this.pos2EObject.containsKey(copy)) {
                    it.remove();
                    continue;
                }
                pos2.range(range);
            }
            for (Map.Entry entry2 : this.eObject2Positions.entrySet()) {
                value = (List)entry2.getValue();
                positions = value.iterator();
                while (positions.hasNext()) {
                    pos = (Int2)positions.next();
                    pos.range(range);
                    if (pos.b() != -1) continue;
                    positions.remove();
                }
            }
            for (Map.Entry entry2 : this.eObject2CommentPositions.entrySet()) {
                value = (List)entry2.getValue();
                positions = value.iterator();
                while (positions.hasNext()) {
                    pos = (Int2)positions.next();
                    pos.range(range);
                    if (pos.b() != -1) continue;
                    positions.remove();
                }
            }
            it = this.pos2LinkEObject.entrySet().iterator();
            while (it.hasNext()) {
                entry2 = it.next();
                pos2 = (Int2)entry2.getKey();
                copy = new Int2(pos2.b(), pos2.e());
                copy.range(range);
                if (copy.b() == -1 || !copy.equals(pos2) && this.pos2LinkEObject.containsKey(copy)) {
                    it.remove();
                    continue;
                }
                pos2.range(range);
            }
            List[] listArray = this.highlightedPos;
            int n = this.highlightedPos.length;
            int n2 = 0;
            while (n2 < n) {
                List highlightedPo = listArray[n2];
                it = highlightedPo.iterator();
                while (it.hasNext()) {
                    Int2 pos3 = (Int2)((Object)it.next());
                    pos3.range(range);
                    if (pos3.b() != -1) continue;
                    it.remove();
                }
                ++n2;
            }
        }
    }

    public void indent(Int2[] lines) {
        if (!this.commit) {
            List value;
            this.shift += lines.length;
            for (Map.Entry entry : this.pos2EObject.entrySet()) {
                ((Int2)entry.getKey()).indent(lines);
            }
            for (Map.Entry entry : this.eObject2Positions.entrySet()) {
                value = (List)entry.getValue();
                for (Int2 pos : value) {
                    pos.indent(lines);
                }
            }
            for (Map.Entry entry : this.eObject2CommentPositions.entrySet()) {
                value = (List)entry.getValue();
                for (Int2 pos : value) {
                    pos.indent(lines);
                }
            }
            for (Map.Entry entry : this.pos2LinkEObject.entrySet()) {
                ((Int2)entry.getKey()).indent(lines);
            }
            List[] listArray = this.highlightedPos;
            int n = this.highlightedPos.length;
            int n2 = 0;
            while (n2 < n) {
                List highlightedPo = listArray[n2];
                for (Int2 pos : highlightedPo) {
                    pos.indent(lines);
                }
                ++n2;
            }
        }
    }

    private static class InversePosComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        private InversePosComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Int2 pos0 = (Int2)arg0;
            Int2 pos1 = (Int2)arg1;
            if (pos0.b() < pos1.b()) {
                return 1;
            }
            if (pos0.b() > pos1.b()) {
                return -1;
            }
            if (pos0.e() < pos1.e()) {
                return -1;
            }
            if (pos0.e() > pos1.e()) {
                return 1;
            }
            return 0;
        }
    }

    private static class PosComparator
    implements Comparator {
        private PosComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Int2 pos0 = (Int2)arg0;
            Int2 pos1 = (Int2)arg1;
            int res = pos0.b() < pos1.b() ? -1 : (pos0.b() > pos1.b() ? 1 : (pos0.e() < pos1.e() ? 1 : (pos0.e() > pos1.e() ? -1 : 0)));
            return res;
        }
    }
}

