/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.tools.log;

import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.sirius.query.legacy.tools.log.IFailure;

public abstract class TreeLog {
    protected Object value = null;
    protected static Comparator failureComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            IFailure failure0 = (IFailure)arg0;
            IFailure failure1 = (IFailure)arg1;
            if (failure0.position() < failure1.position()) {
                return -1;
            }
            return 1;
        }
    };
    protected TreeSet errors = new TreeSet(failureComparator);
    protected TreeSet severeWarnings = new TreeSet(failureComparator);

    protected TreeLog() {
    }

    protected TreeLog(Object value) {
        this.value = value;
    }

    protected TreeLog(IFailure failure) {
        this.addError(failure);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void getAll(TreeLog otherLog, boolean errorsToSevereWarnings) {
        if (errorsToSevereWarnings) {
            this.severeWarnings.addAll(otherLog.errors);
        } else {
            this.errors.addAll(otherLog.errors);
        }
        this.severeWarnings.addAll(otherLog.severeWarnings);
    }

    public boolean isOk() {
        return !this.hasError();
    }

    public boolean hasError() {
        return this.errors.size() > 0;
    }

    public boolean hasSevereWarning() {
        return this.severeWarnings.size() > 0;
    }

    protected void addError(IFailure failure) {
        this.errors.add(failure);
    }

    public Iterator allErrors() {
        return this.errors.iterator();
    }

    public IFailure lastError() {
        if (this.errors.size() > 0) {
            return (IFailure)this.errors.last();
        }
        return null;
    }

    protected void addSevereWarning(IFailure failure) {
        this.severeWarnings.add(failure);
    }

    public Iterator allSevereWarnings() {
        return this.severeWarnings.iterator();
    }

    public Iterator allOrderedErrorsAndSevereWarnings() {
        TreeSet all = new TreeSet(failureComparator);
        all.addAll(this.errors);
        all.addAll(this.severeWarnings);
        return all.iterator();
    }

    public String toString() {
        String message = "";
        Iterator errors = this.allOrderedErrorsAndSevereWarnings();
        while (errors.hasNext()) {
            Object failure = errors.next();
            message = String.valueOf(message) + failure.toString() + '\n';
        }
        return message;
    }
}

