#*******************************************************************************
# * Copyright (c) 2010 -2014 Profactor GmbH, ACIN, fortiss GmbH
# * All rights reserved. This program and the accompanying materials
# * are made available under the terms of the Eclipse Public License v1.0
# * which accompanies this distribution, and is available at
# * http://www.eclipse.org/legal/epl-v10.html
# *
# * Contributors:
# *    Michael Hofmann, Alois Zoitl, Gerhard Ebenhofer, Matthias Plash, Patrick Smejkal - initial API and implementation and/or initial documentation
# *******************************************************************************/

MACRO(forte_add_subdirectory DIRECTORY)
  SET(SOURCE_GROUP_BACKUP ${SOURCE_GROUP})
  SET(SOURCE_GROUP ${SOURCE_GROUP}\\${DIRECTORY})
  add_subdirectory(${DIRECTORY})
  SET(SOURCE_GROUP ${SOURCE_GROUP_BACKUP})
ENDMACRO(forte_add_subdirectory)

FUNCTION(forte_add_sourcefile_with_path_h)
  FOREACH(ARG ${ARGV})
    SET_SOURCE_FILES_PROPERTIES(${ARG} PROPERTIES HEADER_FILE_ONLY TRUE)
    SET_PROPERTY(GLOBAL APPEND PROPERTY FORTE_SOURCE_H ${ARG})
    SET_PROPERTY(GLOBAL APPEND PROPERTY FORTE_SOURCE_H_GROUP ${SOURCE_GROUP})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_sourcefile_with_path_h)

FUNCTION(forte_add_sourcefile_with_path_cpp)
  FOREACH(ARG ${ARGV})
  SET_PROPERTY(GLOBAL APPEND PROPERTY FORTE_SOURCE_CPP ${ARG})
    SET_PROPERTY(GLOBAL APPEND PROPERTY FORTE_SOURCE_CPP_GROUP ${SOURCE_GROUP})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_sourcefile_with_path_cpp)

FUNCTION(forte_add_sourcefile_with_path_hcpp)
  FOREACH(ARG ${ARGV})
    forte_add_sourcefile_with_path_h(${ARG}.h)
    forte_add_sourcefile_with_path_cpp(${ARG}.cpp)
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_sourcefile_with_path_hcpp)

FUNCTION(forte_add_sourcefile_h)
  FOREACH(ARG ${ARGV})
    forte_add_sourcefile_with_path_h(${CMAKE_CURRENT_SOURCE_DIR}/${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_sourcefile_h)

FUNCTION(forte_add_sourcefile_with_path_hc)
  FOREACH(ARG ${ARGV})
    forte_add_sourcefile_with_path_h(${ARG}.h)
    forte_add_sourcefile_with_path_cpp(${ARG}.c)
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_sourcefile_with_path_hc)

FUNCTION(forte_add_sourcefile_hc)
  FOREACH(ARG ${ARGV})
    forte_add_sourcefile_with_path_hc(${CMAKE_CURRENT_SOURCE_DIR}/${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_sourcefile_hc)

FUNCTION(forte_add_sourcefile_c)
  FOREACH(ARG ${ARGV})
  forte_add_sourcefile_with_path_c(${CMAKE_CURRENT_SOURCE_DIR}/${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_sourcefile_c)

FUNCTION(forte_add_sourcefile_with_path_c)
  FOREACH(ARG ${ARGV})
  SET_PROPERTY(GLOBAL APPEND PROPERTY FORTE_SOURCE_C ${ARG})
    SET_PROPERTY(GLOBAL APPEND PROPERTY FORTE_SOURCE_C_GROUP ${SOURCE_GROUP})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_sourcefile_with_path_c)

FUNCTION(forte_add_sourcefile_cpp)
  FOREACH(ARG ${ARGV})
  forte_add_sourcefile_with_path_cpp(${CMAKE_CURRENT_SOURCE_DIR}/${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_sourcefile_cpp)

FUNCTION(forte_add_sourcefile_hcpp)
  FOREACH(ARG ${ARGV})
    forte_add_sourcefile_with_path_hcpp(${CMAKE_CURRENT_SOURCE_DIR}/${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_sourcefile_hcpp)

FUNCTION(forte_add_include_directories)
  FOREACH(ARG ${ARGV})
    SET_PROPERTY(GLOBAL APPEND PROPERTY FORTE_INCLUDE_DIRECTORIES ${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_include_directories)

FUNCTION(forte_add_include_system_directories) #avoid warnings on included folders
  FOREACH(ARG ${ARGV})
    SET_PROPERTY(GLOBAL APPEND PROPERTY FORTE_INCLUDE_SYSTEM_DIRECTORIES ${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_include_system_directories)

FUNCTION(forte_remove_sourcefile_h)
  GET_PROPERTY(SOURCE_H       GLOBAL PROPERTY FORTE_SOURCE_H)
  GET_PROPERTY(SOURCE_H_GROUP GLOBAL PROPERTY FORTE_SOURCE_H_GROUP)
  FOREACH(ARG ${ARGV})  
  LIST(LENGTH SOURCE_H       LIST_LEN)
  MATH(EXPR LIST_LEN ${LIST_LEN}-1)
  FOREACH(POS RANGE ${LIST_LEN}-1)
    LIST(GET SOURCE_H ${POS} FILENAME) 
    STRING(REGEX MATCH ".*/${ARG}$" FOUND ${FILENAME})
    IF(FOUND)
      LIST(REMOVE_AT SOURCE_H  ${POS})
    LIST(REMOVE_AT SOURCE_H_GROUP  ${POS})
      BREAK()
    ENDIF(FOUND)
  ENDFOREACH(POS)
  ENDFOREACH(ARG)
  SET_PROPERTY(GLOBAL PROPERTY FORTE_SOURCE_H ${SOURCE_H})
  SET_PROPERTY(GLOBAL PROPERTY FORTE_SOURCE_H_GROUP ${SOURCE_H_GROUP})
ENDFUNCTION(forte_remove_sourcefile_h)

FUNCTION(forte_remove_sourcefile_cpp)
  GET_PROPERTY(SOURCE_CPP       GLOBAL PROPERTY FORTE_SOURCE_CPP)
  GET_PROPERTY(SOURCE_CPP_GROUP GLOBAL PROPERTY FORTE_SOURCE_CPP_GROUP)
  FOREACH(ARG ${ARGV})
  LIST(LENGTH SOURCE_CPP       LIST_LEN)
  MATH(EXPR LIST_LEN ${LIST_LEN}-1)
  FOREACH(POS RANGE ${LIST_LEN}-1)
    LIST(GET SOURCE_CPP ${POS} FILENAME) 
    STRING(REGEX MATCH ".*/${ARG}$" FOUND ${FILENAME})
    IF(FOUND)
      LIST(REMOVE_AT SOURCE_CPP  ${POS})
    LIST(REMOVE_AT SOURCE_CPP_GROUP  ${POS})
      BREAK()
    ENDIF(FOUND)
  ENDFOREACH(POS)
  ENDFOREACH(ARG)
  SET_PROPERTY(GLOBAL PROPERTY FORTE_SOURCE_CPP ${SOURCE_CPP})
  SET_PROPERTY(GLOBAL PROPERTY FORTE_SOURCE_CPP_GROUP ${SOURCE_CPP_GROUP})
ENDFUNCTION(forte_remove_sourcefile_cpp)

FUNCTION(forte_replace_sourcefile_h)
  FOREACH(ARG ${ARGV})
    forte_remove_sourcefile_h(${ARG})
  forte_add_sourcefile_h(${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_replace_sourcefile_h)

FUNCTION(forte_replace_sourcefile_cpp)
  FOREACH(ARG ${ARGV})
    forte_remove_sourcefile_cpp(${ARG})
  forte_add_sourcefile_cpp(${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_replace_sourcefile_cpp)

FUNCTION(forte_set_timer) #don't append as only one timer can be present
  SET_PROPERTY(GLOBAL PROPERTY FORTE_TIMER_CPP ${CMAKE_CURRENT_SOURCE_DIR}/${ARGV}.cpp) 
  SET_PROPERTY(GLOBAL PROPERTY FORTE_TIMER_H ${CMAKE_CURRENT_SOURCE_DIR}/${ARGV}.h)
ENDFUNCTION(forte_set_timer)

FUNCTION(forte_add_to_executable_h)
  FOREACH(ARG ${ARGV})
    SET_PROPERTY(GLOBAL APPEND PROPERTY FORTE_EXECUTABLE_H ${CMAKE_CURRENT_SOURCE_DIR}/${ARG}.h)
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_to_executable_h)

FUNCTION(forte_add_to_executable_cpp)
  FOREACH(ARG ${ARGV})
    SET_PROPERTY(GLOBAL APPEND PROPERTY FORTE_EXECUTABLE_CPP ${CMAKE_CURRENT_SOURCE_DIR}/${ARG}.cpp)
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_to_executable_cpp)

FUNCTION(forte_add_link_directories)
  FOREACH(ARG ${ARGV})
    SET_PROPERTY(GLOBAL APPEND PROPERTY FORTE_LINK_DIRECTORIES ${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_link_directories)

FUNCTION(forte_add_link_library)
  FOREACH(ARG ${ARGV})
    set_property(GLOBAL APPEND PROPERTY FORTE_LINK_LIBRARY ${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_link_library)

FUNCTION(forte_add_link_library_beginning)
  get_property(LINK_LIBRARY_1 GLOBAL PROPERTY FORTE_LINK_LIBRARY)
  set_property(GLOBAL PROPERTY FORTE_LINK_LIBRARY "")
  FOREACH(ARG ${ARGV})
    set_property(GLOBAL APPEND PROPERTY FORTE_LINK_LIBRARY ${ARG})
  ENDFOREACH(ARG)
  forte_add_link_library(${LINK_LIBRARY_1}) 
ENDFUNCTION(forte_add_link_library_beginning)

FUNCTION(forte_add_definition)
  FOREACH(ARG ${ARGV})
    set_property(GLOBAL APPEND PROPERTY FORTE_DEFINITION ${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_definition)

FUNCTION(forte_add_link_flags)
FOREACH(ARG ${ARGV})
  set_property(GLOBAL APPEND PROPERTY FORTE_LINK_FLAGS ${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_link_flags)

FUNCTION(forte_add_architecture)
  FOREACH(ARG ${ARGV})
    set_property(GLOBAL APPEND PROPERTY FORTE_ARCHITECTURES ${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_architecture)

MACRO(forte_add_network_layer NAME ONOFF CONFIGNAME CLASSNAME FILENAME DISCRIPTION)
# TODO: parse filename from filename
  set(FORTE_COM_${NAME} ${ONOFF} CACHE BOOL "${DISCRIPTION}")
  IF(FORTE_COM_${NAME})
    FORTE_ADD_SOURCEFILE_HCPP(${FILENAME})
    set_property(GLOBAL APPEND PROPERTY FORTE_LAYER_CLASS ${CLASSNAME})
    set_property(GLOBAL APPEND PROPERTY FORTE_LAYER_CONFIGNAME ${CONFIGNAME})
    set_property(GLOBAL APPEND PROPERTY FORTE_LAYER_FILENAME "${FILENAME}.h")
  ENDIF(FORTE_COM_${NAME})
ENDMACRO(forte_add_network_layer)

MACRO(forte_add_handler CLASSNAME FILENAME)
    FORTE_ADD_SOURCEFILE_H(${FILENAME}.h)
    set_property(GLOBAL APPEND PROPERTY FORTE_HANDLER_CLASS ${CLASSNAME})
    set_property(GLOBAL APPEND PROPERTY FORTE_HANDLER_FILENAME "${FILENAME}.h")
ENDMACRO(forte_add_handler)

#MACRO(forte_add_module NAME DIRECTORY DISCRIPTION)
# Additional parameters are interpreted as dependencies
MACRO(forte_add_module NAME DISCRIPTION)
  set(FORTE_MODULE_${NAME} OFF CACHE BOOL "${DISCRIPTION}")
  FOREACH(dependencies ${ARGN})
  if(NOT ${dependencies})
  return()
  endif(NOT ${dependencies})
  ENDFOREACH(dependencies)
  if(NOT FORTE_MODULE_${NAME})
    return()
  endif(NOT FORTE_MODULE_${NAME})
ENDMACRO(forte_add_module)

#MACRO(forte_add_io NAME DIRECTORY DESCRIPTION)
MACRO(forte_add_io NAME DESCRIPTION)
  set(FORTE_IO_${NAME} OFF CACHE BOOL "${DESCRIPTION}")
  if(NOT FORTE_IO_${NAME})
    return()
  endif(NOT FORTE_IO_${NAME})
ENDMACRO(forte_add_io)

FUNCTION(forte_create_modules_file FORTE_MODULE_DIR FORTE_EXTERNAL_MODULE_DIR)
  INCLUDE(${FORTE_BUILDSUPPORT_DIRECTORY}/generate_modules_cmake_file.cmake)
ENDFUNCTION(forte_create_modules_file)

FUNCTION(forte_replacefile_if_changed SOURCE DESTINATION)
  execute_process( COMMAND ${CMAKE_COMMAND} -E compare_files ${SOURCE} ${DESTINATION} RESULT_VARIABLE test_not_successful OUTPUT_QUIET ERROR_QUIET )

  IF( test_not_successful)
    file(REMOVE ${DESTINATION})
    file(RENAME ${SOURCE} ${DESTINATION})
  ENDIF( test_not_successful)
ENDFUNCTION(forte_replacefile_if_changed SOURCE DESTINATION)

FUNCTION(forte_add_extension_file)
  FOREACH(ARG ${ARGV})
    SET_PROPERTY(GLOBAL APPEND PROPERTY FORTE_EXTENSION_FILES ${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_extension_file)

FUNCTION(forte_add_post_build_command)
  FOREACH(ARG ${ARGV})
    set_property(GLOBAL APPEND PROPERTY FORTE_POST_BUILD_COMMAND ${ARG})
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_post_build_command)

## forte_add_test (test_name file_name will_fail)
FUNCTION(forte_add_test arg1 arg2 arg3)
  ADD_TEST(NAME ${arg1} COMMAND $<TARGET_FILE:forte>)
  set_tests_properties ( ${arg1} PROPERTIES TIMEOUT ${arg3})
  FILE(TO_NATIVE_PATH "${CMAKE_CURRENT_SOURCE_DIR}/${arg2}" file_str)
  STRING(REPLACE "\\" "\\\\" file_str ${file_str})
  set_tests_properties (${arg1} PROPERTIES ENVIRONMENT "FORTE_BOOT_FILE=${file_str};FORTE_VCD_FILE=${arg1}.vcd")
  SET_TESTS_PROPERTIES(${arg1} PROPERTIES FAIL_REGULAR_EXPRESSION "ERROR: T")
ENDFUNCTION(forte_add_test)

FUNCTION(forte_add_custom_configuration)
  FOREACH(ARG ${ARGV})
    SET_PROPERTY(GLOBAL APPEND_STRING PROPERTY FORTE_CUSTOM_CONFIGURATIONS_GLOBAL "${ARG}" \n\n)
  ENDFOREACH(ARG)
ENDFUNCTION(forte_add_custom_configuration)