/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.data.BaseType1;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Annotation;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.I4DIACElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public final class Annotations {
    public static InterfaceList getInterfaceList(AdapterType at) {
        return at.getAdapterFBType().getInterfaceList();
    }

    public static AdapterFBType getPlugType(AdapterType adapterType) {
        AdapterFBType temp = (AdapterFBType)EcoreUtil.copy((EObject)adapterType.getAdapterFBType());
        ArrayList<Event> inputEvents = new ArrayList<Event>((Collection<Event>)temp.getInterfaceList().getEventOutputs());
        for (Event event : inputEvents) {
            event.setIsInput(true);
        }
        ArrayList<Event> outputEvents = new ArrayList<Event>((Collection<Event>)temp.getInterfaceList().getEventInputs());
        for (Event event : outputEvents) {
            event.setIsInput(false);
        }
        ArrayList<VarDeclaration> inputVars = new ArrayList<VarDeclaration>((Collection<VarDeclaration>)temp.getInterfaceList().getOutputVars());
        for (VarDeclaration varDecl : inputVars) {
            varDecl.setIsInput(true);
        }
        ArrayList<VarDeclaration> outputVars = new ArrayList<VarDeclaration>((Collection<VarDeclaration>)temp.getInterfaceList().getInputVars());
        for (VarDeclaration varDecl : outputVars) {
            varDecl.setIsInput(false);
        }
        temp.getInterfaceList().getEventInputs().clear();
        temp.getInterfaceList().getEventOutputs().clear();
        temp.getInterfaceList().getInputVars().clear();
        temp.getInterfaceList().getOutputVars().clear();
        temp.getInterfaceList().getEventInputs().addAll(inputEvents);
        temp.getInterfaceList().getEventOutputs().addAll(outputEvents);
        temp.getInterfaceList().getInputVars().addAll(inputVars);
        temp.getInterfaceList().getOutputVars().addAll(outputVars);
        return temp;
    }

    public static AdapterFBType getSocketType(AdapterType at) {
        return (AdapterFBType)EcoreUtil.copy((EObject)at.getAdapterFBType());
    }

    public static AutomationSystem getAutomationSystem(Application a) {
        return (AutomationSystem)a.eContainer();
    }

    public static Algorithm getAlgorithmNamed(BasicFBType basicFBType, String name) {
        return basicFBType.getAlgorithm().stream().filter(alg -> alg.getName().equals(name)).findFirst().orElse(null);
    }

    public static FBNetworkElement getSourceElement(Connection c) {
        return c.getSource() != null ? c.getSource().getFBNetworkElement() : null;
    }

    public static FBNetworkElement getDestinationElement(Connection c) {
        return c.getDestination() != null ? c.getDestination().getFBNetworkElement() : null;
    }

    public static boolean isResourceConnection(Connection c) {
        return c.getSourceElement() != null && c.getSourceElement().getFbNetwork() != null ? c.getSourceElement().getFbNetwork().eContainer() instanceof Resource : false;
    }

    public static FBNetwork getFBNetwork(Connection c) {
        return (FBNetwork)c.eContainer();
    }

    public static void checkifConnectionBroken(Connection c) {
        if (!c.isResourceConnection()) {
            Resource sourceRes = c.getSourceElement() != null ? c.getSourceElement().getResource() : null;
            Resource destinationRes = c.getDestinationElement() != null ? c.getDestinationElement().getResource() : null;
            c.setBrokenConnection(sourceRes != null && !sourceRes.equals(destinationRes) || destinationRes != null && !destinationRes.equals(sourceRes));
        }
    }

    public static AutomationSystem getAutomationSystem(Device d) {
        return d.getSystemConfiguration().getAutomationSystem();
    }

    public static SystemConfiguration getSystemConfiguration(Device d) {
        return (SystemConfiguration)d.eContainer();
    }

    public static Resource getResourceNamed(Device d, String name) {
        for (Resource res : d.getResource()) {
            if (!res.getName().equals(name)) continue;
            return res;
        }
        return null;
    }

    public static boolean isStartState(ECState ecs) {
        if (ecs.eContainer() != null) {
            return ecs.equals(ecs.getECC().getStart());
        }
        return false;
    }

    public static String getConditionText(ECTransition ect) {
        String retVal = "";
        Event event = ect.getConditionEvent();
        String expression = ect.getConditionExpression();
        if (event != null) {
            retVal = event.getName();
        }
        if (expression != null) {
            if (expression.equals("1")) {
                retVal = expression;
            } else if (!expression.equals("")) {
                retVal = String.valueOf(retVal) + "[" + expression + "]";
            }
        }
        return retVal;
    }

    public static boolean isResourceFB(FB fb) {
        if (fb.getFbNetwork().eContainer() instanceof Resource) {
            return fb.getMapping() == null || fb.equals(fb.getMapping().getFrom());
        }
        return false;
    }

    public static boolean isResourceTypeFB(FB fb) {
        return false;
    }

    public static Resource getResource(FBNetworkElement fbne) {
        if (fbne.getFbNetwork() != null) {
            EObject container = fbne.getFbNetwork().eContainer();
            if (container instanceof Resource) {
                return (Resource)container;
            }
            if (container instanceof SubApp) {
                return Annotations.getResource((SubApp)container);
            }
        }
        if (fbne.isMapped()) {
            return fbne.getMapping().getTo().getResource();
        }
        return null;
    }

    public static IInterfaceElement getInterfaceElement(FBNetworkElement fbne, String name) {
        if (fbne.getInterface() != null) {
            return fbne.getInterface().getInterfaceElement(name);
        }
        return null;
    }

    public static FBNetworkElement getOpposite(FBNetworkElement fbne) {
        if (fbne.isMapped()) {
            return fbne == fbne.getMapping().getFrom() ? fbne.getMapping().getTo() : fbne.getMapping().getFrom();
        }
        return null;
    }

    public static FBNetwork getFbNetwork(FBNetworkElement fbne) {
        return fbne.eContainer() instanceof FBNetwork ? (FBNetwork)fbne.eContainer() : null;
    }

    public static void checkConnections(FBNetworkElement fbne) {
        fbne.getInterface().getAllInterfaceElements().forEach(element -> {
            element.getInputConnections().forEach(conn -> conn.checkIfConnectionBroken());
            element.getOutputConnections().forEach(conn -> conn.checkIfConnectionBroken());
        });
    }

    public static boolean isMapped(FBNetworkElement fbne) {
        return fbne.getMapping() != null;
    }

    public static EList<IInterfaceElement> getAllInterfaceElements(InterfaceList il) {
        BasicEList retVal = new BasicEList();
        retVal.addAll(il.getEventInputs());
        retVal.addAll(il.getEventOutputs());
        retVal.addAll(il.getInputVars());
        retVal.addAll(il.getOutputVars());
        retVal.addAll(il.getPlugs());
        retVal.addAll(il.getSockets());
        return retVal;
    }

    public static Event getEvent(InterfaceList il, String name) {
        for (Event event : il.getEventInputs()) {
            if (!event.getName().equals(name)) continue;
            return event;
        }
        for (Event event : il.getEventOutputs()) {
            if (!event.getName().equals(name)) continue;
            return event;
        }
        return null;
    }

    public static VarDeclaration getVariable(InterfaceList il, String name) {
        for (VarDeclaration var : il.getInputVars()) {
            if (!var.getName().equals(name)) continue;
            return var;
        }
        for (VarDeclaration var : il.getOutputVars()) {
            if (!var.getName().equals(name)) continue;
            return var;
        }
        return null;
    }

    public static IInterfaceElement getInterfaceElement(InterfaceList il, String name) {
        IInterfaceElement element = il.getEvent(name);
        if (element == null) {
            element = il.getVariable(name);
        }
        if (element == null) {
            element = il.getAdapter(name);
        }
        return element;
    }

    public static FBNetworkElement getFBNetworkElement(InterfaceList il) {
        return il.eContainer() instanceof FBNetworkElement ? (FBNetworkElement)il.eContainer() : null;
    }

    public static AdapterDeclaration getAdapter(InterfaceList il, String name) {
        for (AdapterDeclaration adapt : il.getPlugs()) {
            if (!adapt.getName().equals(name)) continue;
            return adapt;
        }
        for (AdapterDeclaration adapt : il.getSockets()) {
            if (!adapt.getName().equals(name)) continue;
            return adapt;
        }
        return null;
    }

    public static AutomationSystem getAutomationSystem(Mapping m) {
        return m.eContainer() != null ? (AutomationSystem)m.eContainer() : null;
    }

    public static AutomationSystem getAutomationSystem(Resource r) {
        AutomationSystem system = null;
        if (r.getDevice() != null) {
            system = r.getDevice().getAutomationSystem();
        }
        return system;
    }

    public static void addConnection(FBNetwork fbn, Connection connection) {
        if (connection instanceof EventConnection) {
            fbn.getEventConnections().add((Object)((EventConnection)connection));
        }
        if (connection instanceof DataConnection) {
            fbn.getDataConnections().add((Object)((DataConnection)connection));
        }
        if (connection instanceof AdapterConnection) {
            fbn.getAdapterConnections().add((Object)((AdapterConnection)connection));
        }
    }

    public static void removeConnection(FBNetwork fbn, Connection connection) {
        if (connection instanceof EventConnection) {
            fbn.getEventConnections().remove((Object)connection);
        }
        if (connection instanceof DataConnection) {
            fbn.getDataConnections().remove((Object)connection);
        }
        if (connection instanceof AdapterConnection) {
            fbn.getAdapterConnections().remove((Object)connection);
        }
    }

    public static boolean isApplicationNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof Application;
    }

    public static boolean isSubApplicationNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof SubApp;
    }

    public static boolean isResourceNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof Resource;
    }

    public static boolean isCFBTypeNetwork(FBNetwork fbn) {
        return fbn.eContainer() instanceof CompositeFBType;
    }

    public static AutomationSystem getAutomationSystem(FBNetwork fbn) {
        if (fbn.isApplicationNetwork() || fbn.isSubApplicationNetwork()) {
            return fbn.getApplication().getAutomationSystem();
        }
        if (fbn.isResourceNetwork()) {
            return ((Resource)fbn.eContainer()).getAutomationSystem();
        }
        if (fbn.isCFBTypeNetwork()) {
            return ((CompositeFBType)fbn.eContainer()).getPaletteEntry().getGroup().getPallete().getAutomationSystem();
        }
        return null;
    }

    public static Application getApplication(FBNetwork fbn) {
        if (fbn.isApplicationNetwork()) {
            return (Application)fbn.eContainer();
        }
        if (fbn.isSubApplicationNetwork() && ((SubApp)fbn.eContainer()).getFbNetwork() != null) {
            return ((SubApp)fbn.eContainer()).getFbNetwork().getApplication();
        }
        return null;
    }

    public static FB getFBNamed(FBNetwork fbn, String name) {
        for (FBNetworkElement element : fbn.getNetworkElements()) {
            if (!(element instanceof FB) || !element.getName().equals(name)) continue;
            return (FB)element;
        }
        return null;
    }

    public static SubApp getSubAppNamed(FBNetwork fbn, String name) {
        for (FBNetworkElement element : fbn.getNetworkElements()) {
            if (!(element instanceof SubApp) || !element.getName().equals(name)) continue;
            return (SubApp)element;
        }
        return null;
    }

    public static FBNetworkElement getElementNamed(FBNetwork fbn, String name) {
        for (FBNetworkElement element : fbn.getNetworkElements()) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public static Device getDeviceNamed(AutomationSystem as, String name) {
        if (as.getSystemConfiguration() != null) {
            return as.getSystemConfiguration().getDeviceNamed(name);
        }
        return null;
    }

    public static Application getApplicationNamed(AutomationSystem as, String name) {
        for (Application app : as.getApplication()) {
            if (!app.getName().equals(name)) continue;
            return app;
        }
        return null;
    }

    public static boolean isArray(VarDeclaration vd) {
        return vd.getArraySize() > 0;
    }

    public static void setAttribute(ConfigurableObject object, String attributeName, String type, String value, String comment) {
        Attribute attribute = Annotations.getAttribute(object, attributeName);
        if (attribute == null) {
            attribute = LibraryElementFactory.eINSTANCE.createAttribute();
            attribute.setName(attributeName);
            attribute.setValue(value);
            attribute.setType(BaseType1.getByName(type));
            attribute.setComment(comment);
            object.getAttributes().add((Object)attribute);
        } else {
            attribute.setValue(value);
        }
    }

    public static String getAttributeValue(ConfigurableObject object, String attributeName) {
        Attribute a = Annotations.getAttribute(object, attributeName);
        if (a != null) {
            return a.getValue();
        }
        return null;
    }

    public static Attribute getAttribute(ConfigurableObject object, String attributeName) {
        if (attributeName == null) {
            return null;
        }
        for (Attribute attribute : object.getAttributes()) {
            if (!attribute.getName().equalsIgnoreCase(attributeName)) continue;
            return attribute;
        }
        return null;
    }

    public static VarDeclaration getDataSource(DataConnection dc) {
        return (VarDeclaration)dc.getSource();
    }

    public static VarDeclaration getDataDestination(DataConnection dc) {
        return (VarDeclaration)dc.getDestination();
    }

    public static Event getEventSource(EventConnection ec) {
        return (Event)ec.getSource();
    }

    public static Event getEventDestination(EventConnection ec) {
        return (Event)ec.getDestination();
    }

    public static AdapterDeclaration getAdapterSource(AdapterConnection ac) {
        return (AdapterDeclaration)ac.getSource();
    }

    public static AdapterDeclaration getAdapterDestination(AdapterConnection ac) {
        return (AdapterDeclaration)ac.getDestination();
    }

    public static FBNetworkElement getFBNetworkElement(IInterfaceElement iie) {
        return iie.eContainer() instanceof InterfaceList ? ((InterfaceList)iie.eContainer()).getFBNetworkElement() : null;
    }

    public static VarDeclaration getVarDeclaration(Value v) {
        return (VarDeclaration)v.eContainer();
    }

    public static AutomationSystem getAutomationSystem(SystemConfiguration sc) {
        return (AutomationSystem)sc.eContainer();
    }

    public static Segment getSegmentNamed(SystemConfiguration sc, String name) {
        for (Segment segment : sc.getSegments()) {
            if (!segment.getName().equals(name)) continue;
            return segment;
        }
        return null;
    }

    public static Device getDeviceNamed(SystemConfiguration sc, String name) {
        for (Device device : sc.getDevices()) {
            if (!device.getName().equals(name)) continue;
            return device;
        }
        return null;
    }

    public static boolean isResourceTypeFB() {
        return true;
    }

    public static Annotation createAnnotation(I4DIACElement i4e, String name) {
        Annotation annotation = LibraryElementFactory.eINSTANCE.createAnnotation();
        annotation.setName(name);
        i4e.getAnnotations().add((Object)annotation);
        return annotation;
    }

    public static void removeAnnotation(I4DIACElement i4e, Annotation a) {
        i4e.getAnnotations().remove((Object)a);
    }

    public static String getTypeName(TypedConfigureableObject tco) {
        return tco.getPaletteEntry().getLabel();
    }

    public static LibraryElement getType(TypedConfigureableObject tco) {
        if (tco.getPaletteEntry() != null) {
            return tco.getPaletteEntry().getType();
        }
        return null;
    }

    public static boolean isSocket(AdapterFB afb) {
        return !afb.isPlug();
    }

    public static FBType getType(AdapterFB afb) {
        AdapterFBType retVal = null;
        if (afb.getPaletteEntry() instanceof AdapterTypePaletteEntry && afb.getAdapterDecl() != null) {
            retVal = afb.isPlug() ? ((AdapterTypePaletteEntry)afb.getPaletteEntry()).getType().getPlugType() : ((AdapterTypePaletteEntry)afb.getPaletteEntry()).getType().getSocketType();
        }
        return retVal;
    }

    public static boolean isPlug(AdapterFB afb) {
        return !afb.getAdapterDecl().isIsInput();
    }

    private Annotations() {
        throw new UnsupportedOperationException("The utility class Annotations should not be instatiated");
    }
}

