/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.fordiac.ide.model.IdentifierVerifyer;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Annotation;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.ui.Abstract4DIACUIPlugin;

public final class NameRepository {
    private static final Set<String> RESERVED_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("VAR", "END_VAR", "CONSTANT", "SUPER", "RETURN", "IF", "THEN", "END_IF", "ELSIF", "ELSE", "CASE", "OF", "END_CASE", "EXIT", "CONTINUE", "FOR", "TO", "BY", "DO", "END_FOR", "WHILE", "END_WHILE", "REPEAT", "UNTIL", "END_REPEAT", "OR", "XOR", "AND", "MOD", "NOT", "E", "D", "H", "M", "S", "MS", "US", "NS", "DINT", "INT", "SINT", "LINT", "UINT", "USINT", "UDINT", "ULINT", "REAL", "LREAL", "STRING", "WSTRING", "CHAR", "WCHAR", "TIME", "LTIME", "TIME_OF_DAY", "LTIME_OF_DAY", "TOD", "LTOD", "DATE", "LDATE", "DATE_AND_TIME", "LDATE_AND_TIME", "BOOL")));

    private NameRepository() {
    }

    public static void checkNameIdentifier(INamedElement element) {
        element.getAnnotations().clear();
        if (!IdentifierVerifyer.isValidIdentifier(element.getName())) {
            Annotation ano = element.createAnnotation(MessageFormat.format(Messages.NameRepository_NameNotAValidIdentifier, element.getName()));
            ano.setServity(2);
        }
    }

    public static String createUniqueName(INamedElement element, String nameProposal) {
        Assert.isTrue((boolean)IdentifierVerifyer.isValidIdentifier(nameProposal), (String)"The given name proposal is not a valid identifier!");
        Assert.isNotNull((Object)element.eContainer(), (String)"For a correct operation createuniqueName expects that the model element is already added in its containing model!");
        String retVal = nameProposal;
        if (element instanceof IInterfaceElement) {
            retVal = NameRepository.checkReservedKeyWords(nameProposal);
        }
        return NameRepository.getUniqueName(NameRepository.getRefNames(element), retVal);
    }

    public static boolean isValidName(INamedElement element, String nameProposal) {
        Assert.isNotNull((Object)element.eContainer(), (String)"For a correct operation createuniqueName expects that the model element is already added in its containing model!");
        Abstract4DIACUIPlugin.statusLineErrorMessage(null);
        if (!IdentifierVerifyer.isValidIdentifier(nameProposal)) {
            Abstract4DIACUIPlugin.statusLineErrorMessage((String)MessageFormat.format(Messages.NameRepository_NameNotAValidIdentifier, nameProposal));
            return false;
        }
        if (element instanceof IInterfaceElement && RESERVED_KEYWORDS.contains(nameProposal)) {
            Abstract4DIACUIPlugin.statusLineErrorMessage((String)MessageFormat.format(Messages.NameRepository_NameReservedKeyWord, nameProposal));
            return false;
        }
        if (NameRepository.getRefNames(element).contains(nameProposal)) {
            Abstract4DIACUIPlugin.statusLineErrorMessage((String)MessageFormat.format(Messages.NameRepository_NameAlreadyExists, nameProposal));
            return false;
        }
        return true;
    }

    private static Set<String> getRefNames(INamedElement refElement) {
        BasicEList elementsList = null;
        if (refElement instanceof Algorithm) {
            elementsList = ((BasicFBType)((Algorithm)refElement).eContainer()).getAlgorithm();
        } else if (refElement instanceof Application) {
            elementsList = ((Application)refElement).getAutomationSystem().getApplication();
        } else if (refElement instanceof Device) {
            elementsList = ((Device)refElement).getSystemConfiguration().getDevices();
        } else if (refElement instanceof FBNetworkElement) {
            elementsList = ((FBNetworkElement)refElement).getFbNetwork().getNetworkElements();
        } else if (refElement instanceof Resource) {
            elementsList = ((Resource)refElement).getDevice().getResource();
        } else if (refElement instanceof Segment) {
            elementsList = ((SystemConfiguration)((Segment)refElement).eContainer()).getSegments();
        } else if (refElement instanceof ECState) {
            elementsList = ((ECC)((ECState)refElement).eContainer()).getECState();
        } else if (refElement instanceof IInterfaceElement) {
            BasicEList elements = new BasicEList();
            InterfaceList interfaceList = null;
            interfaceList = ((IInterfaceElement)refElement).eContainer() instanceof InterfaceList ? (InterfaceList)((IInterfaceElement)refElement).eContainer() : ((BasicFBType)((IInterfaceElement)refElement).eContainer()).getInterfaceList();
            elements.addAll(interfaceList.getAllInterfaceElements());
            if (interfaceList.eContainer() instanceof BasicFBType) {
                elements.addAll(((BasicFBType)interfaceList.eContainer()).getInternalVars());
            }
            elementsList = elements;
        } else {
            throw new IllegalArgumentException("Refenrence list for given class not available: " + refElement.getClass().toString());
        }
        return elementsList.stream().filter(element -> element != refElement).map(element -> element.getName()).collect(Collectors.toSet());
    }

    private static String getUniqueName(Set<String> existingNameList, String nameProposal) {
        String temp = nameProposal;
        int i = 1;
        while (existingNameList.contains(temp)) {
            temp = String.valueOf(nameProposal) + "_" + i;
            ++i;
        }
        return temp;
    }

    private static String checkReservedKeyWords(String name) {
        if (RESERVED_KEYWORDS.contains(name.toUpperCase())) {
            return String.valueOf(name) + "1";
        }
        for (DataType dataType : DataTypeLibrary.getInstance().getDataTypesSorted()) {
            if (!dataType.getName().equalsIgnoreCase(name)) continue;
            return String.valueOf(name) + "1";
        }
        return name;
    }
}

