/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FBNetworkImporter {
    private final Palette palette;
    private final FBNetwork fbNetwork;
    private final InterfaceList interfaceList;
    protected final Map<String, FBNetworkElement> fbNetworkElementMap = new HashMap<String, FBNetworkElement>();

    public FBNetworkImporter(Palette palette) {
        this(palette, LibraryElementFactory.eINSTANCE.createFBNetwork(), LibraryElementFactory.eINSTANCE.createInterfaceList());
    }

    public FBNetworkImporter(Palette palette, FBNetwork fbNetwork, InterfaceList interfaceList) {
        this.palette = palette;
        this.fbNetwork = fbNetwork;
        this.interfaceList = interfaceList;
        fbNetwork.getNetworkElements().forEach(element -> {
            FBNetworkElement fBNetworkElement = this.fbNetworkElementMap.put(element.getName(), (FBNetworkElement)element);
        });
    }

    protected FBNetworkImporter(Palette palette, FBNetwork fbNetwork) {
        this(palette, fbNetwork, LibraryElementFactory.eINSTANCE.createInterfaceList());
    }

    public Palette getPalette() {
        return this.palette;
    }

    public FBNetwork getFbNetwork() {
        return this.fbNetwork;
    }

    FBNetwork parseFBNetwork(Node fbNetworkNode) throws TypeImportException {
        if (fbNetworkNode != null) {
            NodeList childNodes = fbNetworkNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                this.parseFBNetworkEntryNode(n);
                ++i;
            }
        }
        return this.fbNetwork;
    }

    protected void parseFBNetworkEntryNode(Node n) throws TypeImportException {
        if (n.getNodeName().equals("FB")) {
            this.parseFB(n);
        }
        if (n.getNodeName().equals("EventConnections")) {
            this.parseConnectionList(n, LibraryElementFactory.eINSTANCE.createEventConnection(), this.fbNetwork.getEventConnections());
        }
        if (n.getNodeName().equals("DataConnections")) {
            this.parseConnectionList(n, LibraryElementFactory.eINSTANCE.createDataConnection(), this.fbNetwork.getDataConnections());
        }
        if (n.getNodeName().equals("AdapterConnections")) {
            this.parseConnectionList(n, LibraryElementFactory.eINSTANCE.createAdapterConnection(), this.fbNetwork.getAdapterConnections());
        }
        this.checkDataConnections();
    }

    private void parseFB(Node fbNode) throws TypeImportException {
        FB fb = LibraryElementFactory.eINSTANCE.createFB();
        NamedNodeMap mapFbElement = fbNode.getAttributes();
        CommonElementImporter.readNameCommentAttributes(fb, mapFbElement);
        PaletteEntry entry = this.getTypeEntry(mapFbElement);
        if (entry instanceof FBTypePaletteEntry) {
            fb.setPaletteEntry(entry);
            fb.setInterface((InterfaceList)EcoreUtil.copy((EObject)fb.getType().getInterfaceList()));
        } else {
            InterfaceList interfaceList = LibraryElementFactory.eINSTANCE.createInterfaceList();
            fb.setInterface(interfaceList);
        }
        FBNetworkImporter.configureParameters(fb.getInterface(), fbNode.getChildNodes());
        for (VarDeclaration var : fb.getInterface().getInputVars()) {
            if (var.getValue() != null) continue;
            var.setValue(LibraryElementFactory.eINSTANCE.createValue());
        }
        CommonElementImporter.getXandY(mapFbElement, fb);
        this.fbNetwork.getNetworkElements().add((Object)fb);
        this.fbNetworkElementMap.put(fb.getName(), fb);
    }

    private PaletteEntry getTypeEntry(NamedNodeMap mapFbElement) {
        Node typeFbElement = mapFbElement.getNamedItem("Type");
        if (typeFbElement != null) {
            return this.palette.getTypeEntry(typeFbElement.getNodeValue());
        }
        return null;
    }

    protected static void configureParameters(InterfaceList interfaceList, NodeList childNodes) throws TypeImportException {
        int i = 0;
        while (i < childNodes.getLength()) {
            VarDeclaration paramter;
            VarDeclaration vInput;
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("Parameter") && (vInput = FBNetworkImporter.getVarNamed(interfaceList, (paramter = ImportUtils.parseParameter(n)).getName(), true)) != null) {
                vInput.setValue(paramter.getValue());
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private <T extends Connection> void parseConnectionList(Node n, T conTemplate, EList<T> connectionlist) {
        childNodes = n.getChildNodes();
        i = 0;
        while (i < childNodes.getLength()) {
            block4: {
                block5: {
                    block6: {
                        connectionNode = childNodes.item(i);
                        if (!"Connection".equals(connectionNode.getNodeName())) break block4;
                        connection = (Connection)EcoreUtil.copy(conTemplate);
                        connection.setResTypeConnection(false);
                        connectionAttributeMap = connectionNode.getAttributes();
                        destinationElement = connectionAttributeMap.getNamedItem("Destination");
                        if (destinationElement == null) break block5;
                        destination = this.getConnectionEndPoint(destinationElement.getNodeValue());
                        if (destination != null) break block6;
                        Activator.getDefault().logError("Connection destination not found: " + destinationElement.getNodeValue());
                        break block4;
                    }
                    connection.setDestination(destination);
                }
                if ((sourceElement = connectionAttributeMap.getNamedItem("Source")) == null) ** GOTO lbl24
                source = this.getConnectionEndPoint(sourceElement.getNodeValue());
                if (source == null) {
                    Activator.getDefault().logError("Connection source not found: " + sourceElement.getNodeValue());
                } else {
                    connection.setSource(source);
lbl24:
                    // 2 sources

                    if ((commentElement = connectionAttributeMap.getNamedItem("Comment")) != null) {
                        connection.setComment(commentElement.getNodeValue());
                    }
                    FBNetworkImporter.parseConnectionRouting(connectionAttributeMap, connection);
                    connectionlist.add((Object)connection);
                }
            }
            ++i;
        }
    }

    private static void parseConnectionRouting(NamedNodeMap connectionAttributeMap, Connection connection) {
        Node dyElement;
        Node dx2Element;
        Node dx1Element = connectionAttributeMap.getNamedItem("dx1");
        if (dx1Element != null) {
            connection.setDx1(FBNetworkImporter.parseConnectionValue(dx1Element.getNodeValue()));
        }
        if ((dx2Element = connectionAttributeMap.getNamedItem("dx2")) != null) {
            connection.setDx2(FBNetworkImporter.parseConnectionValue(dx2Element.getNodeValue()));
        }
        if ((dyElement = connectionAttributeMap.getNamedItem("dy")) != null) {
            connection.setDy(FBNetworkImporter.parseConnectionValue(dyElement.getNodeValue()));
        }
    }

    private void checkDataConnections() {
        ArrayList<DataConnection> toDelete = new ArrayList<DataConnection>();
        for (DataConnection con : this.fbNetwork.getDataConnections()) {
            if (!(con.getSource() instanceof AdapterDeclaration)) continue;
            toDelete.add(con);
            AdapterConnection adpCon = LibraryElementFactory.eINSTANCE.createAdapterConnection();
            adpCon.setSource(con.getSource());
            adpCon.setDestination(con.getDestination());
            adpCon.setComment(con.getComment());
            adpCon.setDx1(con.getDx1());
            adpCon.setDx2(con.getDx2());
            adpCon.setDy(con.getDy());
            this.fbNetwork.getAdapterConnections().add((Object)adpCon);
            con.setSource(null);
            con.setDestination(null);
        }
        this.fbNetwork.getDataConnections().removeAll(toDelete);
    }

    private IInterfaceElement getConnectionEndPoint(String path) {
        String[] split = path.split("\\.");
        String fbName = "";
        String interfaceElement = "";
        if (split.length == 1) {
            interfaceElement = path;
        }
        if (split.length == 2) {
            fbName = split[0];
            interfaceElement = split[1];
        }
        if (!fbName.equals("") && !interfaceElement.equals("")) {
            FBNetworkElement element = this.findFBNetworkElement(fbName);
            if (element != null) {
                return element.getInterfaceElement(interfaceElement);
            }
        } else if (fbName.equals("")) {
            return this.getContainingInterfaceElement(interfaceElement);
        }
        return null;
    }

    protected IInterfaceElement getContainingInterfaceElement(String interfaceElement) {
        return this.interfaceList.getInterfaceElement(interfaceElement);
    }

    protected FBNetworkElement findFBNetworkElement(String fbName) {
        return this.fbNetworkElementMap.get(fbName);
    }

    private static VarDeclaration getVarNamed(InterfaceList interfaceList, String varName, boolean input) {
        VarDeclaration retVal;
        boolean hasType = true;
        if (interfaceList.eContainer() instanceof FB) {
            boolean bl = hasType = ((FB)interfaceList.eContainer()).getPaletteEntry() != null;
        }
        if (hasType) {
            retVal = interfaceList.getVariable(varName);
            if (retVal != null && retVal.isIsInput() != input) {
                retVal = null;
            }
        } else {
            retVal = FBNetworkImporter.createVarDecl(interfaceList, varName, input);
        }
        return retVal;
    }

    private static VarDeclaration createVarDecl(InterfaceList interfaceList, String varName, boolean input) {
        VarDeclaration var = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        var.setName(varName);
        var.setIsInput(input);
        if (input) {
            interfaceList.getInputVars().add((Object)var);
        } else {
            interfaceList.getOutputVars().add((Object)var);
        }
        return var;
    }

    private static int parseConnectionValue(String value) {
        try {
            return CoordinateConverter.INSTANCE.convertFrom1499XML(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

