/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.comgeneration.implementation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationChannel;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationChannelDestination;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationMediaInfo;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationModel;
import org.eclipse.fordiac.ide.comgeneration.plugin.Activator;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;

public final class ProtocolSelector {
    public static void doAutomatedProtocolSelection(CommunicationModel model) {
        for (CommunicationChannel channel : model.getChannels().values()) {
            ArrayList<Segment> commonSegments = new ArrayList<Segment>();
            Iterator<CommunicationChannelDestination> destinationIterator = channel.getDestinations().iterator();
            CommunicationChannelDestination destination2 = destinationIterator.next();
            for (CommunicationMediaInfo mediaInfo : destination2.getAvailableMedia()) {
                commonSegments.add(mediaInfo.getSegment());
            }
            while (destinationIterator.hasNext()) {
                destination2 = destinationIterator.next();
                Iterator segmentIterator = commonSegments.iterator();
                while (segmentIterator.hasNext()) {
                    Segment segment = (Segment)segmentIterator.next();
                    boolean containsSegment = false;
                    for (CommunicationMediaInfo mediaInfo : destination2.getAvailableMedia()) {
                        if (mediaInfo.getSegment() != segment) continue;
                        containsSegment = true;
                    }
                    if (containsSegment) continue;
                    segmentIterator.remove();
                }
            }
            Segment selectedCommonSegment = null;
            if (!commonSegments.isEmpty()) {
                ProtocolSelector.sortSegments(commonSegments);
                selectedCommonSegment = (Segment)commonSegments.get(0);
            }
            block5: for (CommunicationChannelDestination destination2 : channel.getDestinations()) {
                Segment selectedSegment = selectedCommonSegment;
                if (selectedSegment == null) {
                    ArrayList<Segment> availableSegments = new ArrayList<Segment>();
                    for (CommunicationMediaInfo mediaInfo : destination2.getAvailableMedia()) {
                        availableSegments.add(mediaInfo.getSegment());
                    }
                    ProtocolSelector.sortSegments(availableSegments);
                    if (availableSegments.size() > 0) {
                        selectedSegment = availableSegments.get(0);
                    }
                }
                if (selectedSegment != null) {
                    for (CommunicationMediaInfo mediaInfo : destination2.getAvailableMedia()) {
                        if (mediaInfo.getSegment() != selectedSegment) continue;
                        destination2.setSelectedMedia(mediaInfo);
                        destination2.setSelectedProtocolId(ProtocolSelector.getProtocolIdForMetiaType(mediaInfo.getSegment()));
                        continue block5;
                    }
                    continue;
                }
                Activator.getDefault().logError("No connection available for ");
            }
        }
    }

    private static String getProtocolIdForMetiaType(Segment segment) {
        if (segment.getType().getName().equalsIgnoreCase("Ethernet")) {
            return "EthernetPubSub";
        }
        if (segment.getType().getName().equalsIgnoreCase("Can")) {
            return "CanPubSub";
        }
        return null;
    }

    private static void sortSegments(List<Segment> segmentList) {
        Collections.sort(segmentList, (o1, o2) -> {
            String name1 = o1.getType().getName();
            String name2 = o2.getType().getName();
            if (name1.equalsIgnoreCase("Can")) {
                if (name2.equalsIgnoreCase("Can")) {
                    return 0;
                }
                return -1;
            }
            if (name1.equalsIgnoreCase("Ethernet")) {
                if (name2.equalsIgnoreCase("Can")) {
                    return 1;
                }
                if (name2.equalsIgnoreCase("Ethernet")) {
                    return 0;
                }
                return -1;
            }
            return 0;
        });
    }

    private ProtocolSelector() {
        throw new UnsupportedOperationException("ProtocolSelector utility class should not be instantiated!");
    }
}

