/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.gef.preferences.PaletteFlyoutPreferences;
import org.eclipse.fordiac.ide.gef.utilities.TemplateCreationFactory;
import org.eclipse.fordiac.ide.model.Palette.DeviceTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.Palette.SegmentTypePaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;

public final class SystemConfPaletteFactory {
    public static final PaletteFlyoutPreferences PALETTE_PREFERENCES = new PaletteFlyoutPreferences("SystemConfPaletteFactory.Location", "SystemConfPaletteFactory.Size", "SystemConfPaletteFactory.State");

    public static PaletteRoot createPalette(final AutomationSystem system) {
        final PaletteRoot palette = new PaletteRoot();
        SystemConfPaletteFactory.fillPalette(palette, system);
        system.getPalette().eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                Display.getDefault().syncExec(() -> {
                    palette.setVisible(false);
                    palette.getChildren().clear();
                    SystemConfPaletteFactory.fillPalette(palette, system);
                    palette.setVisible(true);
                });
            }
        });
        return palette;
    }

    private static void fillPalette(PaletteRoot palette, AutomationSystem system) {
        Palette pal = system.getPalette();
        for (PaletteGroup group : pal.getRootGroup().getSubGroups()) {
            if (!group.getEntries().isEmpty()) {
                SystemConfPaletteFactory.createDevGroup(palette, group);
            }
            if (!group.getEntries().isEmpty()) {
                SystemConfPaletteFactory.createRESGroup(palette, group);
            }
            if (group.getEntries().isEmpty()) continue;
            SystemConfPaletteFactory.createSEGGroup(palette, group);
        }
    }

    private static PaletteDrawer createRESGroup(PaletteRoot palette, PaletteGroup group) {
        PaletteDrawer paletteContainer = new PaletteDrawer(group.getLabel());
        paletteContainer.addAll(SystemConfPaletteFactory.createRESEntries(group));
        if (!paletteContainer.getChildren().isEmpty()) {
            palette.add((org.eclipse.gef.palette.PaletteEntry)paletteContainer);
        }
        return paletteContainer;
    }

    private static PaletteDrawer createDevGroup(PaletteRoot palette, PaletteGroup group) {
        PaletteDrawer paletteContainer = new PaletteDrawer(group.getLabel());
        paletteContainer.addAll(SystemConfPaletteFactory.createDEVEntries(group));
        if (!paletteContainer.getChildren().isEmpty()) {
            palette.add((org.eclipse.gef.palette.PaletteEntry)paletteContainer);
        }
        return paletteContainer;
    }

    private static PaletteDrawer createSEGGroup(PaletteRoot palette, PaletteGroup group) {
        PaletteDrawer paletteContainer = new PaletteDrawer(group.getLabel());
        paletteContainer.addAll(SystemConfPaletteFactory.createSEGEntries(group));
        if (!paletteContainer.getChildren().isEmpty()) {
            palette.add((org.eclipse.gef.palette.PaletteEntry)paletteContainer);
        }
        return paletteContainer;
    }

    private static List<org.eclipse.gef.palette.PaletteEntry> createRESEntries(PaletteGroup group) {
        ArrayList<org.eclipse.gef.palette.PaletteEntry> entries = new ArrayList<org.eclipse.gef.palette.PaletteEntry>();
        for (PaletteEntry entry : group.getEntries()) {
            org.eclipse.gef.palette.PaletteEntry paletteEntry;
            if (!(entry instanceof ResourceTypeEntry) || (paletteEntry = SystemConfPaletteFactory.createCreationEntry(entry, FordiacImage.ICON_RESOURCE.getImageDescriptor())) == null) continue;
            entries.add(paletteEntry);
        }
        return entries;
    }

    private static List<org.eclipse.gef.palette.PaletteEntry> createDEVEntries(PaletteGroup group) {
        ArrayList<org.eclipse.gef.palette.PaletteEntry> entries = new ArrayList<org.eclipse.gef.palette.PaletteEntry>();
        for (PaletteEntry entry : group.getEntries()) {
            org.eclipse.gef.palette.PaletteEntry paletteEntry;
            if (!(entry instanceof DeviceTypePaletteEntry) || (paletteEntry = SystemConfPaletteFactory.createCreationEntry(entry, FordiacImage.ICON_DEVICE.getImageDescriptor())) == null) continue;
            entries.add(paletteEntry);
        }
        return entries;
    }

    private static List<org.eclipse.gef.palette.PaletteEntry> createSEGEntries(PaletteGroup group) {
        ArrayList<org.eclipse.gef.palette.PaletteEntry> entries = new ArrayList<org.eclipse.gef.palette.PaletteEntry>();
        for (PaletteEntry entry : group.getEntries()) {
            org.eclipse.gef.palette.PaletteEntry paletteEntry;
            if (!(entry instanceof SegmentTypePaletteEntry) || (paletteEntry = SystemConfPaletteFactory.createCreationEntry(entry, FordiacImage.ICON_SEGMENT.getImageDescriptor())) == null) continue;
            entries.add(paletteEntry);
        }
        return entries;
    }

    private static org.eclipse.gef.palette.PaletteEntry createCreationEntry(PaletteEntry entry, ImageDescriptor desc) {
        LibraryElement type = entry.getType();
        if (type == null) {
            return null;
        }
        return new CombinedTemplateCreationEntry(type.getName(), type.getComment(), (CreationFactory)new TemplateCreationFactory((Object)entry), desc, desc);
    }

    private SystemConfPaletteFactory() {
        throw new UnsupportedOperationException("Class SystemconfPaletteFactory should not be insantiated!");
    }
}

