/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editparts;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.gef.listeners.DiagramFontChangeListener;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.gef.policies.AbstractViewRenameEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceDiagramEditor;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceEditorInput;
import org.eclipse.fordiac.ide.systemconfiguration.policies.DeleteResourceEditPolicy;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IEditorInput;

public class ResourceEditPart
extends AbstractViewEditPart {
    private DiagramFontChangeListener fontChangeListener;

    public void activate() {
        super.activate();
        JFaceResources.getFontRegistry().addListener(this.getFontChangeListener());
    }

    public void deactivate() {
        super.deactivate();
        JFaceResources.getFontRegistry().removeListener(this.getFontChangeListener());
    }

    private IPropertyChangeListener getFontChangeListener() {
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new DiagramFontChangeListener((IFontUpdateListener)this.getFigure());
        }
        return this.fontChangeListener;
    }

    protected void refreshVisuals() {
    }

    public void refreshName() {
        this.getNameLabel().setText(this.getINamedElement().getName());
    }

    protected IFigure createFigureForModel() {
        return new ResourceFigure();
    }

    public ResourceFigure getFigure() {
        return (ResourceFigure)super.getFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteResourceEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new AbstractViewRenameEditPolicy());
    }

    public boolean understandsRequest(Request req) {
        if (this.getModel().isDeviceTypeResource()) {
            return false;
        }
        return super.understandsRequest(req);
    }

    public Resource getModel() {
        return (Resource)super.getModel();
    }

    protected EContentAdapter createContentAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                ResourceEditPart.this.refresh();
                super.notifyChanged(notification);
            }
        };
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    public Label getNameLabel() {
        return this.getFigure().getInstanceName();
    }

    public IPropertyChangeListener getPreferenceChangeListener() {
        return null;
    }

    protected void backgroundColorChanged(IFigure figure) {
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            ResourceEditorInput input = new ResourceEditorInput(this.getModel());
            EditorUtils.openEditor((IEditorInput)input, (String)ResourceDiagramEditor.class.getName());
        } else {
            super.performRequest(request);
        }
    }

    public class ResourceFigure
    extends Figure
    implements IFontUpdateListener {
        private final Label instanceName;
        private final Label typeInfo;

        public ResourceFigure() {
            GridLayout mainLayout = new GridLayout(3, false);
            mainLayout.marginHeight = 2;
            this.setLayoutManager((LayoutManager)mainLayout);
            this.instanceName = ResourceEditPart.this.getINamedElement() == null ? new Label("N/D") : new Label(ResourceEditPart.this.getINamedElement().getName());
            if (ResourceEditPart.this.getModel().isDeviceTypeResource()) {
                this.instanceName.setIcon(FordiacImage.ICON_FIRMWARE_RESOURCE.getImage());
            }
            this.add((IFigure)this.instanceName);
            String type = "N/D";
            if (ResourceEditPart.this.getModel() != null) {
                type = ResourceEditPart.this.getModel().getTypeName();
            }
            this.add((IFigure)new Label(":"));
            this.typeInfo = new Label(type);
            this.setTypeLabelFonts();
            this.add((IFigure)this.typeInfo);
            this.setOpaque(false);
        }

        public Label getInstanceName() {
            return this.instanceName;
        }

        public void updateFonts() {
            this.setTypeLabelFonts();
            this.invalidateTree();
            this.revalidate();
        }

        public void setTypeLabelFonts() {
            this.typeInfo.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
        }
    }
}

