/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.print;

import java.util.regex.Pattern;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.print.PrintMargin;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PrintPreview
extends Dialog {
    private static final String ONLY_DIGIT_REGEX = "^[0-9]*$";
    private static final Pattern ONLY_DIGIT_PATTERN = Pattern.compile("^[0-9]*$", 8);
    private int currentPage = 1;
    private int numberOfPages = 1;
    private Label numberOfPagesLabel;
    private Text currentPageText;
    private Button printBorder;
    private Combo scaleSelection;
    private Combo combo;
    private PrintMargin margin;
    private Printer printer;
    private Canvas canvas;
    private Boolean blockCurrentPageUpdate = false;
    private final String printName;
    private final IFigure figure;

    public PrintPreview(Shell shell, GraphicalViewer viewer, String printName) {
        super(shell);
        this.printName = printName;
        LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
        this.figure = lm.getLayer((Object)"Printable Layers");
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.PrintPreview_LABEL_PrintPreview);
        super.configureShell(newShell);
    }

    protected int getShellStyle() {
        return 66640;
    }

    private void createOptionsGUI(Composite parent) {
        GridLayout layout = new GridLayout(6, false);
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        new Label(parent, 0).setText(Messages.PrintPreview_LABEL_Scale);
        this.scaleSelection = new Combo(parent, 8);
        this.scaleSelection.add(Messages.PrintPreview_LABEL_Tile);
        this.scaleSelection.add(Messages.PrintPreview_LABEL_FitPage);
        this.scaleSelection.add(Messages.PrintPreview_LABEL_FitWidth);
        this.scaleSelection.add(Messages.PrintPreview_LABEL_FitHeight);
        this.scaleSelection.select(0);
        this.scaleSelection.addListener(13, ev -> {
            this.updatePageNumbers();
            this.canvas.redraw();
        });
        this.printBorder = new Button(parent, 32);
        this.printBorder.setText(Messages.PrintPreview_LABEL_PrintBorder);
        this.printBorder.setSelection(true);
        this.printBorder.addListener(13, ev -> this.canvas.redraw());
        new Label(parent, 0).setText(Messages.PrintPreview_LABEL_Margin);
        this.combo = new Combo(parent, 8);
        this.combo.add("0.5");
        this.combo.add("1.0");
        this.combo.add("1.5");
        this.combo.add("2.0");
        this.combo.add("2.5");
        this.combo.add("3.0");
        this.combo.select(1);
        this.combo.addListener(13, ev -> {
            double value = Double.parseDouble(this.combo.getItem(this.combo.getSelectionIndex()));
            this.setPrinter(this.printer, value / 2.54);
        });
        new Label(parent, 0).setText(Messages.PrintPreview_LABEL_CM);
    }

    private int getOptionsSelection() {
        return this.scaleSelection.getSelectionIndex() + 1;
    }

    protected Control createContents(Composite parent) {
        parent.setSize(800, 600);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createButtonArea(composite);
        Label seperator = new Label(composite, 258);
        seperator.setLayoutData((Object)new GridData(768));
        this.canvas = new Canvas(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        this.canvas.setLayoutData((Object)gridData);
        this.canvas.addPaintListener(e -> {
            if (this.printer == null || this.printer.isDisposed()) {
                return;
            }
            org.eclipse.swt.graphics.Rectangle printerBounds = this.printer.getBounds();
            org.eclipse.swt.graphics.Point canvasSize = this.canvas.getSize();
            double viewScaleFactor = (double)canvasSize.x * 1.0 / (double)printerBounds.width;
            viewScaleFactor = Math.min(viewScaleFactor, (double)canvasSize.y * 1.0 / (double)printerBounds.height);
            int offsetX = (canvasSize.x - (int)(viewScaleFactor * (double)printerBounds.width)) / 2;
            int offsetY = (canvasSize.y - (int)(viewScaleFactor * (double)printerBounds.height)) / 2;
            e.gc.setBackground(composite.getDisplay().getSystemColor(1));
            e.gc.fillRectangle(offsetX, offsetY, (int)(viewScaleFactor * (double)printerBounds.width), (int)(viewScaleFactor * (double)printerBounds.height));
            int marginOffsetX = offsetX + (int)(viewScaleFactor * (double)this.margin.getLeft());
            int marginOffsetY = offsetY + (int)(viewScaleFactor * (double)this.margin.getTop());
            double scale = this.getScale();
            double previewScaleFactor = viewScaleFactor * scale;
            SWTGraphics g = new SWTGraphics(e.gc);
            g.scale(previewScaleFactor);
            g.translate((int)((double)marginOffsetX / previewScaleFactor), (int)((double)marginOffsetY / previewScaleFactor));
            this.drawOnePage(scale, (Graphics)g, this.currentPage);
            g.dispose();
        });
        double value = Double.parseDouble(this.combo.getItem(this.combo.getSelectionIndex()));
        this.setPrinter(null, value / 2.54);
        return composite;
    }

    private Point getClipRectLocationForPage(int page, double scale) {
        Rectangle bounds = this.figure.getBounds();
        double scaledPageWidth = (double)this.margin.getWidth() / scale;
        int cols = (int)Math.ceil((double)bounds.width() / scaledPageWidth);
        return new Point((int)((double)bounds.x + (double)(--page % cols) * scaledPageWidth), (int)((double)bounds.y + (double)(page / cols * this.margin.getHeight()) / scale));
    }

    private void updatePageNumbers() {
        Rectangle rectangle = this.figure.getBounds();
        double scale = this.getScale();
        this.numberOfPages = (int)(Math.ceil(rectangle.preciseWidth() * scale / (double)this.margin.getWidth()) * Math.ceil(rectangle.preciseHeight() * scale / (double)this.margin.getHeight()));
        this.numberOfPagesLabel.setText(String.valueOf(this.numberOfPages));
        if (this.currentPage > this.numberOfPages) {
            this.setCurrentPage(this.numberOfPages);
        }
    }

    private double getScale() {
        double scale = (double)this.printer.getDPI().x * 1.0 / (double)Display.getCurrent().getDPI().x * 1.0;
        switch (this.getOptionsSelection()) {
            case 2: {
                scale *= Math.min((double)this.margin.getWidth() / (scale * (double)this.figure.getBounds().width), (double)this.margin.getHeight() / (scale * (double)this.figure.getBounds().height));
                break;
            }
            case 3: {
                scale *= (double)this.margin.getWidth() / (scale * (double)this.figure.getBounds().width);
                break;
            }
            case 4: {
                scale *= (double)this.margin.getHeight() / (scale * (double)this.figure.getBounds().height);
                break;
            }
        }
        return scale;
    }

    private void createButtonArea(Composite parent) {
        Composite buttonArea = new Composite(parent, 0);
        GridLayout buttonAreaLayout = new GridLayout(7, false);
        buttonAreaLayout.marginHeight = 0;
        buttonArea.setLayout((Layout)buttonAreaLayout);
        GridData buttonLayoutData = new GridData();
        buttonLayoutData.horizontalAlignment = 4;
        buttonArea.setLayoutData((Object)buttonLayoutData);
        Button buttonPrint = new Button(buttonArea, 8);
        buttonPrint.setText(Messages.PrintPreview_LABEL_Print);
        buttonPrint.addListener(13, ev -> this.performPrinting());
        new Label(buttonArea, 514).setLayoutData((Object)new GridData(1040));
        this.createPageNavigation(new Composite(buttonArea, 0));
        new Label(buttonArea, 514).setLayoutData((Object)new GridData(1040));
        this.createOptionsGUI(new Composite(buttonArea, 0));
        new Label(buttonArea, 514).setLayoutData((Object)new GridData(1808));
        Composite closeArea = new Composite(buttonArea, 0);
        GridLayout closeAreaLayout = new GridLayout(2, false);
        closeAreaLayout.marginHeight = 0;
        closeAreaLayout.marginWidth = 0;
        closeArea.setLayout((Layout)closeAreaLayout);
        closeArea.setLayoutData((Object)new GridData(768));
        new Label(closeArea, 0).setLayoutData((Object)new GridData(768));
        Button closeButton = new Button(closeArea, 8);
        closeButton.setText(Messages.PrintPreview_LABEL_Close);
        closeButton.addListener(13, ev -> {
            boolean bl = this.close();
        });
        closeButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
    }

    private void createPageNavigation(Composite parent) {
        GridLayout layout = new GridLayout(6, false);
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Label pageLabel = new Label(parent, 0);
        pageLabel.setText(Messages.PrintPreview_LABEL_Page);
        Button left = new Button(parent, 16388);
        left.addListener(13, ev -> {
            if (this.currentPage > 1) {
                this.setCurrentPage(this.currentPage - 1);
            }
        });
        this.currentPageText = new Text(parent, 2052);
        GC gc = new GC((Drawable)this.currentPageText);
        FontMetrics fm = gc.getFontMetrics();
        int width = (int)(3.0 * fm.getAverageCharacterWidth());
        int height = fm.getHeight();
        gc.dispose();
        this.currentPageText.setSize(this.currentPageText.computeSize(width, height));
        this.currentPageText.setText(String.valueOf(this.currentPage));
        this.currentPageText.addListener(24, ev -> {
            try {
                int newCurrentPage = Integer.parseInt(this.currentPageText.getText());
                if (newCurrentPage > 0 && newCurrentPage <= this.numberOfPages) {
                    this.setCurrentPage(newCurrentPage);
                }
            }
            catch (Exception exception) {}
        });
        this.currentPageText.addListener(25, this::pageNumberVerifier);
        Label of = new Label(parent, 0);
        of.setText(Messages.PrintPreview_LABEL_Of);
        this.numberOfPagesLabel = new Label(parent, 0);
        this.numberOfPagesLabel.setText(String.valueOf(this.numberOfPages));
        Button right = new Button(parent, 131076);
        right.addListener(13, ev -> {
            if (this.currentPage < this.numberOfPages) {
                this.setCurrentPage(this.currentPage + 1);
            }
        });
    }

    private void pageNumberVerifier(Event ev) {
        if (!ev.doit) {
            return;
        }
        if (ev.keyCode == 127 || ev.keyCode == 8) {
            return;
        }
        if (ev.character == '\u0000') {
            ev.doit = true;
        } else {
            String currentValue = ((Text)ev.widget).getText();
            String resultingValue = String.valueOf(currentValue.substring(0, ev.start)) + ev.text + currentValue.substring(ev.end);
            if (resultingValue.isEmpty()) {
                resultingValue = String.valueOf(ev.character);
            }
            ev.doit = ONLY_DIGIT_PATTERN.matcher(resultingValue).matches();
        }
    }

    private void setCurrentPage(int newCurrentPage) {
        if (!this.blockCurrentPageUpdate.booleanValue()) {
            this.blockCurrentPageUpdate = true;
            this.currentPage = newCurrentPage;
            this.currentPageText.setText(String.valueOf(this.currentPage));
            this.canvas.redraw();
            this.blockCurrentPageUpdate = false;
        }
    }

    private void performPrinting() {
        PrintDialog dialog = new PrintDialog(this.getShell());
        PrinterData printerData = dialog.open();
        if (printerData == null) {
            return;
        }
        Printer newPrinter = new Printer(printerData);
        double value = Double.parseDouble(this.combo.getItem(this.combo.getSelectionIndex()));
        this.setPrinter(newPrinter, value / 2.54);
        this.print(newPrinter);
        this.printer.dispose();
        this.close();
    }

    void print(Printer printer) {
        if (!printer.startJob(this.printName)) {
            Activator.getDefault().logError(Messages.PrintPreview_ERROR_StartingPrintJob);
            return;
        }
        GC gc = new GC((Drawable)printer);
        SWTGraphics g = new SWTGraphics(gc);
        PrinterGraphics graphics = new PrinterGraphics((Graphics)g, printer);
        graphics.setForegroundColor(this.figure.getForegroundColor());
        graphics.setBackgroundColor(this.figure.getBackgroundColor());
        graphics.setFont(this.figure.getFont());
        double scale = this.getScale();
        graphics.scale(scale);
        graphics.translate((int)((double)this.margin.getLeft() / scale), (int)((double)this.margin.getTop() / scale));
        int i = 1;
        while (i <= this.numberOfPages) {
            if (!printer.startPage()) {
                Activator.getDefault().logError(Messages.PrintPreview_ERROR_StartingNewPage);
                return;
            }
            graphics.pushState();
            this.drawOnePage(scale, (Graphics)graphics, i);
            printer.endPage();
            graphics.popState();
            ++i;
        }
        printer.endJob();
        gc.dispose();
    }

    void setPrinter(Printer newPrinter, double marginSize) {
        if (newPrinter == null) {
            newPrinter = new Printer(Printer.getDefaultPrinterData());
        }
        if (this.printer != null) {
            this.printer.dispose();
        }
        this.printer = newPrinter;
        this.margin = PrintMargin.getPrintMargin(newPrinter, marginSize);
        this.updatePageNumbers();
        this.canvas.redraw();
    }

    private void drawOnePage(double scale, Graphics g, int pageNumber) {
        Point p = this.getClipRectLocationForPage(pageNumber, scale);
        Rectangle clipRect = new Rectangle(p.x, p.y, (int)((double)this.margin.getWidth() / scale), (int)((double)this.margin.getHeight() / scale));
        g.translate(-p.x, -p.y);
        g.setLineStyle(2);
        g.setForegroundColor(ColorConstants.black);
        if (this.printBorder.getSelection()) {
            g.drawRectangle(clipRect);
        }
        g.setLineStyle(1);
        g.clipRect(clipRect);
        this.figure.paint(g);
    }
}

