/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.gef.commands.Command;

public class CreateInputPrimitiveCommand
extends Command {
    private final String type;
    private final ServiceTransaction element;
    private InputPrimitive newPrimitive;

    public CreateInputPrimitiveCommand(String type, ServiceTransaction element) {
        this.type = type;
        this.element = element;
    }

    public boolean canExecute() {
        if (this.type == null || this.element == null) {
            return false;
        }
        return this.element.getInputPrimitive() == null;
    }

    public void execute() {
        Service service = (Service)this.element.eContainer().eContainer();
        this.newPrimitive = LibraryElementFactory.eINSTANCE.createInputPrimitive();
        this.newPrimitive.setEvent("INIT");
        if (this.type.equals("LeftInputPrimitive")) {
            this.newPrimitive.setInterface(service.getLeftInterface());
        } else {
            this.newPrimitive.setInterface(service.getRightInterface());
        }
        this.element.setInputPrimitive(this.newPrimitive);
        super.execute();
    }

    public void undo() {
        this.element.setInputPrimitive(null);
    }

    public void redo() {
        this.element.setInputPrimitive(this.newPrimitive);
    }
}

