/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppInterfaceElementCommand;
import org.eclipse.fordiac.ide.application.commands.DeleteSubAppInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class AddElementsToSubAppCommand
extends Command {
    private final SubApp targetSubApp;
    private final List<FBNetworkElement> elementsToAdd = new ArrayList<FBNetworkElement>();
    private final CompoundCommand unmappingCmds = new CompoundCommand();
    private final List<Connection> movedConns = new ArrayList<Connection>();
    private final CompoundCommand modifiedConns = new CompoundCommand();
    private final CompoundCommand changedSubAppIEs = new CompoundCommand();

    public AddElementsToSubAppCommand(SubApp targetSubApp, List<?> selection) {
        this.targetSubApp = targetSubApp;
        this.fillElementList(selection);
    }

    public boolean canExecute() {
        return !this.elementsToAdd.isEmpty();
    }

    public void execute() {
        this.unmappingCmds.execute();
        for (FBNetworkElement fbNetworkElement : this.elementsToAdd) {
            this.targetSubApp.getSubAppNetwork().getNetworkElements().add((Object)fbNetworkElement);
            this.checkElementConnections(fbNetworkElement);
        }
        this.modifiedConns.execute();
    }

    public void redo() {
        this.unmappingCmds.redo();
        this.elementsToAdd.forEach(element -> {
            boolean bl = this.targetSubApp.getSubAppNetwork().getNetworkElements().add(element);
        });
        this.movedConns.forEach(con -> this.targetSubApp.getSubAppNetwork().addConnection(con));
        this.changedSubAppIEs.redo();
        this.modifiedConns.redo();
    }

    public void undo() {
        this.modifiedConns.undo();
        this.changedSubAppIEs.undo();
        this.movedConns.forEach(con -> this.targetSubApp.getFbNetwork().addConnection(con));
        this.elementsToAdd.forEach(element -> {
            boolean bl = this.targetSubApp.getFbNetwork().getNetworkElements().add(element);
        });
        this.unmappingCmds.undo();
    }

    private void fillElementList(List<?> selection) {
        for (Object ne : selection) {
            if (!(ne instanceof EditPart) || !(((EditPart)ne).getModel() instanceof FBNetworkElement)) continue;
            FBNetworkElement element = (FBNetworkElement)((EditPart)ne).getModel();
            this.elementsToAdd.add(element);
            if (!element.isMapped()) continue;
            this.unmappingCmds.add((Command)new UnmapCommand(element));
        }
    }

    private void checkElementConnections(FBNetworkElement fbNetworkElement) {
        for (IInterfaceElement ie : fbNetworkElement.getInterface().getAllInterfaceElements()) {
            if (ie.isIsInput()) {
                for (Connection con : ie.getInputConnections()) {
                    this.checkConnection(con, con.getSource(), ie);
                }
                continue;
            }
            for (Connection con : ie.getOutputConnections()) {
                this.checkConnection(con, con.getDestination(), ie);
            }
        }
    }

    private void checkConnection(Connection con, IInterfaceElement opposite, IInterfaceElement ownIE) {
        if (this.elementsToAdd.contains(opposite.getFBNetworkElement())) {
            this.moveConIntoSubApp(con);
        } else if (this.targetSubApp.equals(opposite.getFBNetworkElement())) {
            this.moveInterfaceCrossingConIntoSubApp(con, opposite, ownIE);
        } else {
            this.handleModifyConnection(con, ownIE);
        }
    }

    private void moveConIntoSubApp(Connection con) {
        this.targetSubApp.getSubAppNetwork().addConnection(con);
        this.movedConns.add(con);
    }

    private void moveInterfaceCrossingConIntoSubApp(Connection con, IInterfaceElement opposite, IInterfaceElement ownIE) {
        EList outCons;
        EList internalCons = opposite.isIsInput() ? opposite.getOutputConnections() : opposite.getInputConnections();
        EList eList = outCons = opposite.isIsInput() ? opposite.getInputConnections() : opposite.getOutputConnections();
        if (1 == outCons.size()) {
            this.modifiedConns.add((Command)new DeleteSubAppInterfaceElementCommand(opposite));
        } else {
            this.modifiedConns.add((Command)new DeleteConnectionCommand(con));
        }
        internalCons.forEach(intConn -> {
            AbstractConnectionCreateCommand cmd = AddElementsToSubAppCommand.getCreateConnectionCommand(this.targetSubApp.getSubAppNetwork(), opposite);
            cmd.setSource(opposite.isIsInput() ? ownIE : intConn.getSource());
            cmd.setDestination(opposite.isIsInput() ? intConn.getDestination() : ownIE);
            this.modifiedConns.add((Command)cmd);
        });
    }

    private void handleModifyConnection(Connection con, IInterfaceElement ie) {
        String subAppIEName = AddElementsToSubAppCommand.generateSubAppIEName(ie);
        IInterfaceElement subAppIE = this.targetSubApp.getInterfaceElement(subAppIEName);
        boolean addInternalCon = false;
        if (subAppIE == null) {
            subAppIE = this.createInterfaceElement(ie, subAppIEName);
            addInternalCon = true;
        }
        this.createConnModificationCommands(con, subAppIE, addInternalCon);
    }

    private IInterfaceElement createInterfaceElement(IInterfaceElement ie, String subAppIEName) {
        CreateSubAppInterfaceElementCommand cmd = new CreateSubAppInterfaceElementCommand(ie.getType(), this.targetSubApp.getInterface(), ie.isIsInput(), -1);
        cmd.execute();
        cmd.getInterfaceElement().setName(subAppIEName);
        if (cmd.getMirroredElement() != null) {
            cmd.getMirroredElement().getInterfaceElement().setName(subAppIEName);
        }
        this.changedSubAppIEs.add((Command)cmd);
        return cmd.getInterfaceElement();
    }

    private static String generateSubAppIEName(IInterfaceElement ie) {
        return String.valueOf(ie.getFBNetworkElement().getName()) + "_" + ie.getName();
    }

    void createConnModificationCommands(Connection con, IInterfaceElement subAppIE, boolean addInternalCon) {
        this.modifiedConns.add((Command)new DeleteConnectionCommand(con));
        AbstractConnectionCreateCommand connectionCreateCmd = AddElementsToSubAppCommand.getCreateConnectionCommand(this.targetSubApp.getFbNetwork(), subAppIE);
        if (subAppIE.isIsInput()) {
            connectionCreateCmd.setSource(con.getSource());
            connectionCreateCmd.setDestination(subAppIE);
        } else {
            connectionCreateCmd.setSource(subAppIE);
            connectionCreateCmd.setDestination(con.getDestination());
        }
        this.modifiedConns.add((Command)connectionCreateCmd);
        if (addInternalCon) {
            AbstractConnectionCreateCommand internalConCreateCmd = AddElementsToSubAppCommand.getCreateConnectionCommand(this.targetSubApp.getSubAppNetwork(), subAppIE);
            if (subAppIE.isIsInput()) {
                internalConCreateCmd.setSource(subAppIE);
                internalConCreateCmd.setDestination(con.getDestination());
            } else {
                internalConCreateCmd.setSource(con.getSource());
                internalConCreateCmd.setDestination(subAppIE);
            }
            this.modifiedConns.add((Command)internalConCreateCmd);
        }
    }

    private static AbstractConnectionCreateCommand getCreateConnectionCommand(FBNetwork fbNetwork, IInterfaceElement subAppIE) {
        Object cmd = null;
        cmd = subAppIE instanceof Event ? new EventConnectionCreateCommand(fbNetwork) : (subAppIE instanceof AdapterDeclaration ? new AdapterConnectionCreateCommand(fbNetwork) : new DataConnectionCreateCommand(fbNetwork));
        return cmd;
    }
}

