/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.figures.ConnectionTooltipFigure;
import org.eclipse.fordiac.ide.application.policies.ConnectionGraphicalNodeEditPolicy;
import org.eclipse.fordiac.ide.application.policies.DeleteConnectionEditPolicy;
import org.eclipse.fordiac.ide.application.policies.DisableConnectionHandleRoleEditPolicy;
import org.eclipse.fordiac.ide.application.policies.FeedbackConnectionEndpointEditPolicy;
import org.eclipse.fordiac.ide.gef.figures.HideableConnection;
import org.eclipse.fordiac.ide.gef.router.BendpointPolicyRouter;
import org.eclipse.fordiac.ide.gef.router.RouterUtil;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceGetter;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ConnectionEditPart
extends AbstractConnectionEditPart {
    private static final String HIDDEN = "HIDDEN";
    private static final String HIDEN_CON = "HIDEN_CON";
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("EventConnectionConnectorColor") && ConnectionEditPart.this.getModel() instanceof EventConnection) {
                ConnectionEditPart.this.getFigure().setForegroundColor(PreferenceGetter.getColor((String)"EventConnectionConnectorColor"));
            }
            if (event.getProperty().equals("AdapterConnectionConnectorColor") && ConnectionEditPart.this.getModel() instanceof AdapterConnection) {
                ConnectionEditPart.this.getFigure().setForegroundColor(PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor"));
            }
            if (event.getProperty().equals("DataConnectionConnectorColor") && ConnectionEditPart.this.getModel() instanceof DataConnection) {
                ConnectionEditPart.this.getFigure().setForegroundColor(PreferenceGetter.getColor((String)"DataConnectionConnectorColor"));
            }
            if (event.getProperty().equals("hideDataConnections") && ConnectionEditPart.this.getModel() instanceof DataConnection) {
                ConnectionEditPart.this.getFigure().setVisible((Boolean)event.getNewValue() == false);
            }
            if (event.getProperty().equals("hideEventConnections") && ConnectionEditPart.this.getModel() instanceof EventConnection) {
                ConnectionEditPart.this.getFigure().setVisible((Boolean)event.getNewValue() == false);
            }
        }
    };
    private EContentAdapter contentAdapter;

    public Connection getModel() {
        return (Connection)super.getModel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new FeedbackConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new DisableConnectionHandleRoleEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new DeleteConnectionEditPolicy());
        if (this.getConnectionFigure().getConnectionRouter() instanceof BendpointPolicyRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", ((BendpointPolicyRouter)this.getConnectionFigure().getConnectionRouter()).getBendpointPolicy((Object)this.getModel()));
        }
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ConnectionGraphicalNodeEditPolicy());
    }

    protected IFigure createFigure() {
        PolylineConnection connection = RouterUtil.getConnectionRouterFactory(null).createConnectionFigure();
        String status = this.getModel().getAttributeValue(HIDEN_CON);
        if (connection instanceof HideableConnection) {
            ((HideableConnection)connection).setHidden(status != null && status.equalsIgnoreCase(HIDDEN));
            if (this.getModel() != null && this.getModel().getSourceElement() != null) {
                ((HideableConnection)connection).setLabel(String.valueOf(this.getModel().getSourceElement().getName()) + "." + this.getModel().getSource().getName());
            }
            ((HideableConnection)connection).setModel(this.getModel());
        }
        PolygonDecoration arrow = new PolygonDecoration();
        arrow.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        arrow.setScale(7.0, 4.0);
        connection.setTargetDecoration((RotatableDecoration)arrow);
        PolygonDecoration arrow1 = new PolygonDecoration();
        arrow1.setTemplate(PolygonDecoration.INVERTED_TRIANGLE_TIP);
        arrow1.setScale(7.0, 4.0);
        arrow1.setLocation(new Point(10, 10));
        connection.setSourceDecoration((RotatableDecoration)arrow1);
        if (this.getModel() instanceof EventConnection) {
            connection.setForegroundColor(PreferenceGetter.getColor((String)"EventConnectionConnectorColor"));
        }
        if (this.getModel() instanceof AdapterConnection) {
            connection.setForegroundColor(PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor"));
            connection.setTargetDecoration(null);
            connection.setSourceDecoration(null);
        }
        if (this.getModel() instanceof DataConnection) {
            connection.setForegroundColor(PreferenceGetter.getColor((String)"DataConnectionConnectorColor"));
        }
        connection.setToolTip((IFigure)new ConnectionTooltipFigure(this.getModel()));
        return connection;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getConnectionFigure() instanceof PolylineConnection && this.getModel() != null) {
            if (this.getModel().isBrokenConnection()) {
                ((PolylineConnection)this.getConnectionFigure()).setLineStyle(2);
            } else {
                ((PolylineConnection)this.getConnectionFigure()).setLineStyle(1);
            }
        }
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
            this.getModel().eAdapters().add((Object)this.getContentAdapter());
        }
    }

    private Adapter getContentAdapter() {
        if (this.contentAdapter == null) {
            this.contentAdapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    Object feature = notification.getFeature();
                    ConnectionEditPart.this.refreshVisuals();
                    if (LibraryElementPackage.eINSTANCE.getINamedElement_Comment().equals(feature)) {
                        ConnectionEditPart.this.refreshComment();
                    }
                }
            };
        }
        return this.contentAdapter;
    }

    private void refreshComment() {
        this.getFigure().setToolTip((IFigure)new ConnectionTooltipFigure(this.getModel()));
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.getModel().eAdapters().remove((Object)this.getContentAdapter());
        }
    }

    public void setTransparency(int value) {
        if (this.getFigure() instanceof PolylineConnection) {
            PolylineConnection connection = (PolylineConnection)this.getFigure();
            connection.setAlpha(value);
            for (Object fig : connection.getChildren()) {
                if (!(fig instanceof Shape)) continue;
                ((Shape)fig).setAlpha(value);
            }
        }
    }
}

