/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.systemconfiguration.commands.DeviceDeleteCommand;
import org.eclipse.fordiac.ide.systemconfiguration.commands.ResourceDeleteCommand;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.commands.DeleteApplicationCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteHandler
extends AbstractHandler {
    private Map<AutomationSystem, CompoundCommand> commandMap = new HashMap<AutomationSystem, CompoundCommand>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            for (Object element : ((StructuredSelection)selection).toList()) {
                this.createDeleteCommand(element);
            }
            this.executeDeleteCommands();
        }
        return null;
    }

    private void executeDeleteCommands() {
        this.commandMap.entrySet().forEach(entry -> SystemManager.INSTANCE.getCommandStack((AutomationSystem)entry.getKey()).execute((Command)entry.getValue()));
        this.commandMap.clear();
    }

    private void createDeleteCommand(Object element) {
        if (element instanceof Application) {
            this.enlistCommand(((Application)element).getAutomationSystem(), new DeleteApplicationCommand((Application)element));
        } else if (element instanceof Device) {
            this.enlistCommand(((Device)element).getAutomationSystem(), (Command)new DeviceDeleteCommand((Device)element));
        } else if (element instanceof Resource) {
            this.enlistCommand(((Resource)element).getAutomationSystem(), (Command)new ResourceDeleteCommand((Resource)element));
        }
    }

    private void enlistCommand(AutomationSystem automationSystem, Command cmd) {
        if (cmd.canExecute()) {
            this.getCommandList(automationSystem).add(cmd);
        }
    }

    private CompoundCommand getCommandList(AutomationSystem automationSystem) {
        CompoundCommand commandList = this.commandMap.get(automationSystem);
        if (commandList == null) {
            commandList = new CompoundCommand();
            this.commandMap.put(automationSystem, commandList);
        }
        return commandList;
    }
}

