/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteECStateCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithm;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionOutputEvent;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECTransitionEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.policies.ECStateLayoutEditPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.policies.ECStateSelectionPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.policies.TransitionNodeEditPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.preferences.PreferenceGetter;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.gef.editparts.NameCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.figures.GradientLabel;
import org.eclipse.fordiac.ide.gef.figures.HorizontalLineFigure;
import org.eclipse.fordiac.ide.gef.figures.InteractionStyleFigure;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyListener;

public class ECStateEditPart
extends AbstractDirectEditableEditPart
implements NodeEditPart {
    private List<Object> stateChildren;
    private final EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (8 != notification.getEventType()) {
                Object feature = notification.getFeature();
                if (!(LibraryElementPackage.eINSTANCE.getECAction_Algorithm().equals(feature) || LibraryElementPackage.eINSTANCE.getECAction_Output().equals(feature) || LibraryElementPackage.eINSTANCE.getECState().equals(feature))) {
                    ECStateEditPart.this.refresh();
                }
            }
        }
    };
    private final EContentAdapter eccAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            ECStateEditPart.this.updateBorder();
        }
    };
    private final IPropertyChangeListener propertyChangeListener = event -> {
        if (event.getProperty().equals("ECCEditorStateColor")) {
            this.getNameLabel().setBackgroundColor(PreferenceGetter.getColor("ECCEditorStateColor"));
        }
        if (event.getProperty().equals("ECCEditorStateBorderColor")) {
            this.getNameLabel().setForegroundColor(PreferenceGetter.getColor("ECCEditorStateBorderColor"));
            ((ECStateFigure)this.getFigure()).getLine().setForegroundColor(PreferenceGetter.getColor("ECCEditorStateBorderColor"));
        }
    };

    public ECStateEditPart() {
        this.setConnectable(true);
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().eAdapters().add((Object)this.adapter);
            this.getCastedModel().getECC().eAdapters().add((Object)this.eccAdapter);
            Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getCastedModel().eAdapters().remove((Object)this.adapter);
            if (this.getCastedModel().getECC() != null) {
                this.getCastedModel().getECC().eAdapters().remove((Object)this.eccAdapter);
            }
            Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void updateBorder() {
        this.getNameLabel().setBorder((Border)new StateBorder(this.isInitialState()));
    }

    private boolean isInitialState() {
        return this.getCastedModel().isStartState();
    }

    public IFigure getContentPane() {
        return ((ECStateFigure)this.getFigure()).getContentPane();
    }

    public List<Object> getCurrentChildren() {
        return this.stateChildren;
    }

    protected List getModelChildren() {
        if (this.stateChildren == null) {
            this.stateChildren = new ArrayList<Object>();
        } else {
            this.stateChildren.clear();
        }
        for (ECAction ecAction : this.getCastedModel().getECAction()) {
            this.stateChildren.add(new ECActionAlgorithm(ecAction));
            this.stateChildren.add(new ECActionOutputEvent(ecAction));
        }
        return this.stateChildren;
    }

    protected IFigure createFigure() {
        return new ECStateFigure();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ECStateLayoutEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TransitionNodeEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return new DeleteECStateCommand(ECStateEditPart.this.getCastedModel());
            }
        });
        this.installEditPolicy("Highlight_IN_OUTS", (EditPolicy)new ECStateSelectionPolicy());
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            request.setType((Object)"direct edit");
        }
        super.performRequest(request);
    }

    public ECState getCastedModel() {
        return (ECState)this.getModel();
    }

    protected void refreshVisuals() {
        Rectangle rect = new Rectangle(this.getCastedModel().getX(), this.getCastedModel().getY(), -1, -1);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)rect);
        ((ECStateFigure)this.getFigure()).setHasAction(!this.getCastedModel().getECAction().isEmpty());
        super.refreshVisuals();
    }

    protected List<ECTransition> getModelSourceConnections() {
        return this.getCastedModel().getOutTransitions();
    }

    protected List<ECTransition> getModelTargetConnections() {
        return this.getCastedModel().getInTransitions();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (connection.getTarget() != null && connection.getTarget().equals(connection.getSource())) {
            return new FixedAnchor((IFigure)((ECStateFigure)this.getFigure()).getNameLabel(), false);
        }
        return new ChopboxAnchor((IFigure)((ECStateFigure)this.getFigure()).getNameLabel());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)((ECStateFigure)this.getFigure()).getNameLabel());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (connection.getSource() != null && connection.getSource().equals(connection.getTarget())) {
            return new FixedAnchor((IFigure)((ECStateFigure)this.getFigure()).getNameLabel(), true);
        }
        return new ChopboxAnchor((IFigure)((ECStateFigure)this.getFigure()).getNameLabel());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)((ECStateFigure)this.getFigure()).getNameLabel());
    }

    public Label getNameLabel() {
        return ((ECStateFigure)this.getFigure()).getNameLabel();
    }

    public INamedElement getINamedElement() {
        return this.getCastedModel();
    }

    public void highlightTransitions(boolean highlight) {
        for (Object obj : this.getSourceConnections()) {
            if (!(obj instanceof ECTransitionEditPart)) continue;
            ((ECTransitionEditPart)((Object)obj)).highlight(highlight);
        }
        for (Object obj : this.getTargetConnections()) {
            if (!(obj instanceof ECTransitionEditPart)) continue;
            ((ECTransitionEditPart)((Object)obj)).highlight(highlight);
        }
    }

    protected DirectEditManager createDirectEditManager() {
        Label l = this.getNameLabel();
        return new LabelDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, (CellEditorLocator)new NameCellEditorLocator(l), l, (VerifyListener)new IdentifierVerifyListener());
    }

    public class ECStateFigure
    extends Figure
    implements InteractionStyleFigure {
        private StateBorder stateBorder = new StateBorder();
        private Label nameLabel;
        private final Figure line = new HorizontalLineFigure(15);
        private final Figure actionContainer = new Figure(){

            public void add(IFigure figure, Object constraint, int index) {
                super.add(figure, constraint, index);
                this.setConstraint(figure, new GridData(4, 1, true, false));
            }
        };

        public ECStateFigure() {
            ToolbarLayout tbLayout = new ToolbarLayout();
            tbLayout.setStretchMinorAxis(false);
            tbLayout.setHorizontal(true);
            this.setLayoutManager((LayoutManager)tbLayout);
            Figure stateLabel = new Figure();
            this.add((IFigure)stateLabel);
            FlowLayout layout = new FlowLayout();
            layout.setStretchMinorAxis(true);
            layout.setMajorSpacing(0);
            layout.setMinorSpacing(0);
            layout.setHorizontal(true);
            layout.setMinorAlignment(0);
            stateLabel.setLayoutManager((LayoutManager)layout);
            this.nameLabel = new GradientLabel(((ZoomScalableFreeformRootEditPart)ECStateEditPart.this.getRoot()).getZoomManager());
            stateLabel.add((IFigure)this.nameLabel);
            this.nameLabel.setText(ECStateEditPart.this.getCastedModel().getName());
            this.nameLabel.setBackgroundColor(PreferenceGetter.getColor("ECCEditorStateColor"));
            this.nameLabel.setForegroundColor(PreferenceGetter.getColor("ECCEditorStateBorderColor"));
            this.nameLabel.setOpaque(true);
            this.nameLabel.setBorder((Border)new StateBorder(ECStateEditPart.this.isInitialState()));
            stateLabel.add((IFigure)this.line);
            this.line.setForegroundColor(PreferenceGetter.getColor("ECCEditorStateBorderColor"));
            this.add((IFigure)this.actionContainer);
            GridLayout gl = new GridLayout(2, false);
            gl.horizontalSpacing = -1;
            gl.verticalSpacing = 0;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            this.actionContainer.setLayoutManager((LayoutManager)gl);
        }

        public void setHasAction(boolean hasAction) {
            this.line.setVisible(hasAction);
        }

        public Figure getContentPane() {
            return this.actionContainer;
        }

        public Label getNameLabel() {
            return this.nameLabel;
        }

        public Figure getLine() {
            return this.line;
        }

        public StateBorder getStateBorder() {
            return this.stateBorder;
        }

        public int getIntersectionStyle(Point location) {
            Rectangle bounds = this.nameLabel.getBounds().getCopy();
            bounds.x += 3;
            bounds.y += 3;
            bounds.width -= 6;
            bounds.height -= 6;
            if (bounds.intersects(new Rectangle(location, new Dimension(1, 1)))) {
                return 0;
            }
            return 1;
        }
    }

    public static class StateBorder
    extends LineBorder {
        private boolean initialState = false;

        public boolean isInitialState() {
            return this.initialState;
        }

        public void setInitialState(boolean initialState) {
            this.initialState = initialState;
        }

        public StateBorder() {
        }

        public StateBorder(boolean isInitialState) {
            this();
            this.initialState = isInitialState;
        }

        public Insets getInsets(IFigure figure) {
            if (this.initialState) {
                return new Insets(6, 9, 6, 9);
            }
            return new Insets(3, 6, 3, 6);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            super.paint(figure, graphics, insets);
            graphics.setBackgroundColor(PreferenceGetter.getColor("ECCEditorStateColor"));
            graphics.setForegroundColor(PreferenceGetter.getColor("ECCEditorStateBorderColor"));
            figure.setForegroundColor(PreferenceGetter.getColor("ECCEditorStateBorderColor"));
            graphics.drawRectangle(tempRect);
            if (this.initialState) {
                Rectangle tempRect2 = new Rectangle(tempRect);
                tempRect2.shrink(3, 3);
                graphics.drawRectangle(tempRect2);
            }
        }
    }
}

