/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.MoveBendpointCommand;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.handles.BendpointMoveHandle;
import org.eclipse.gef.requests.BendpointRequest;

public class TransitionBendPointEditPolicy
extends BendpointEditPolicy {
    private ECTransition transition;

    public TransitionBendPointEditPolicy(ECTransition transition) {
        this.transition = transition;
    }

    protected Command getCreateBendpointCommand(BendpointRequest request) {
        return this.getMoveBendpointCommand(request);
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        return this.getMoveBendpointCommand(request);
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        Point p = request.getLocation().getCopy();
        this.getConnection().translateToRelative((Translatable)p);
        return new MoveBendpointCommand(this.transition, p);
    }

    protected List createSelectionHandles() {
        return this.createHandlesForUserBendpoints();
    }

    private List createHandlesForUserBendpoints() {
        ArrayList<BendpointMoveHandle> list = new ArrayList<BendpointMoveHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        ArrayList bendPoints = (ArrayList)this.getConnection().getRoutingConstraint();
        int bendPointIndex = 0;
        Point currBendPoint = null;
        if (bendPoints == null) {
            bendPoints = new ArrayList();
        } else if (!bendPoints.isEmpty()) {
            currBendPoint = ((Bendpoint)bendPoints.get(0)).getLocation();
        }
        int i = 0;
        while (i < points.size() - 1) {
            if (i < points.size() - 1 && bendPointIndex < bendPoints.size() && currBendPoint.equals((Object)points.getPoint(i + 1))) {
                list.add(new BendpointMoveHandle(connEP, bendPointIndex, i + 1));
                if (++bendPointIndex < bendPoints.size()) {
                    currBendPoint = ((Bendpoint)bendPoints.get(bendPointIndex)).getLocation();
                }
            }
            ++i;
        }
        return list;
    }
}

