/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.fbtypeeditor.FBInterfacePaletteFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.FBTypeEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.InterfaceContextMenuProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.FBInterfaceEditPartFactory;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

public class FBInterfaceEditor
extends DiagramEditorWithFlyoutPalette
implements IFBTEditorPart {
    private CommandStack commandStack;
    private FBType fbType;
    private PaletteRoot paletteRoot;
    private Palette palette;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInput(input);
        if (input instanceof FBTypeEditorInput) {
            FBTypeEditorInput untypedInput = (FBTypeEditorInput)input;
            this.fbType = untypedInput.getContent();
            PaletteGroup group = untypedInput.getPaletteEntry().getGroup();
            while (group.eContainer() != null) {
                group = group.eContainer();
            }
            if (group instanceof Palette) {
                this.palette = (Palette)group;
            }
            if (this.palette == null) {
                this.palette = TypeLibrary.getInstance().getPalette();
            }
        }
        super.init(site, input);
        this.setPartName("Interface");
        this.setTitleImage(FordiacImage.ICON_INTERFACE_EDITOR.getImage());
    }

    protected void setModel(IEditorInput input) {
        super.setModel(input);
        this.setEditDomain(new FBTypeEditDomain(this, this.commandStack));
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        InterfaceContextMenuProvider.createInterfaceEditingActions((IWorkbenchPart)this, registry, this.getModel());
        super.createActions();
    }

    protected EditPartFactory getEditPartFactory() {
        return new FBInterfaceEditPartFactory((GraphicalEditor)this, this.palette, this.getZoomManger());
    }

    protected KeyHandler getCommonKeyHandler() {
        KeyHandler keyHandler = super.getCommonKeyHandler();
        keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        keyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        keyHandler.put(KeyStroke.getPressed((char)'+', (int)61, (int)262144), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        return keyHandler;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.updateActions(this.getSelectionActions());
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = FBInterfacePaletteFactory.createPalette(this.palette);
        }
        return this.paletteRoot;
    }

    protected Palette getPalette() {
        return this.palette;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public boolean outlineSelectionChanged(Object selectedElement) {
        Object editpart = this.getGraphicalViewer().getEditPartRegistry().get(selectedElement);
        this.getGraphicalViewer().flush();
        if (editpart instanceof EditPart && ((EditPart)editpart).isSelectable()) {
            this.getGraphicalViewer().select((EditPart)editpart);
            return true;
        }
        return selectedElement instanceof InterfaceList;
    }

    @Override
    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return FBInterfacePaletteFactory.PALETTE_PREFERENCES;
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    public FBType getModel() {
        return this.fbType;
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new InterfaceContextMenuProvider((EditPartViewer)viewer, zoomManager, this.getActionRegistry());
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return null;
    }

    public AutomationSystem getSystem() {
        return null;
    }

    public void doSaveAs() {
    }
}

