/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.ui.wizard;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExportStatusMessageDialog
extends ErrorDialog {
    private final List<String> warnings;
    private final List<String> errors;
    private StyledText text;
    private String newLine = "";

    public ExportStatusMessageDialog(Shell parentShell, List<String> warnings, List<String> errors) {
        super(parentShell, "4diac IDE Type Export Errors", "During Type export the following issues have been identified:", (IStatus)new Status(1, "pluginid", String.valueOf(errors.size()) + " errors and " + warnings.size() + " warnings!"), 7);
        this.warnings = warnings;
        this.errors = errors;
    }

    protected Control createMessageArea(Composite parent) {
        Control retval = super.createMessageArea(parent);
        new Label(parent, 0);
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        GridData fillBoth = new GridData();
        fillBoth.grabExcessHorizontalSpace = true;
        fillBoth.grabExcessVerticalSpace = true;
        fillBoth.horizontalAlignment = 4;
        fillBoth.verticalAlignment = 4;
        main.setLayoutData((Object)fillBoth);
        GridData fillText = new GridData();
        fillText.grabExcessHorizontalSpace = true;
        fillText.grabExcessVerticalSpace = true;
        fillText.horizontalAlignment = 4;
        fillText.verticalAlignment = 4;
        this.text = new StyledText(main, 2818);
        this.text.setLayoutData((Object)fillText);
        this.printMessages();
        return retval;
    }

    public void printMessages() {
        this.text.setText("");
        int count = 0;
        StyleRange style1 = new StyleRange();
        if (!this.warnings.isEmpty()) {
            String warning = "Warnings \n";
            this.text.append(warning);
            style1.start = count;
            style1.length = warning.length();
            style1.fontStyle = 1;
            this.text.setStyleRange(style1);
            count += warning.length();
            count += this.addLines(this.warnings);
            this.text.append(this.newLine);
            count += this.newLine.length();
        }
        if (!this.errors.isEmpty()) {
            String error = "Errors \n";
            this.text.append(error);
            style1 = new StyleRange();
            style1.start = count;
            style1.length = error.length();
            style1.fontStyle = 1;
            this.text.setStyleRange(style1);
            this.addLines(this.errors);
        }
    }

    private int addLines(List<String> messages) {
        int count = 0;
        for (String string : messages) {
            if (string == null) continue;
            count += string.length();
            this.text.append(string);
            this.newLine = "\n";
            this.text.append(this.newLine);
            count += this.newLine.length();
        }
        return count;
    }
}

