/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators;

import org.eclipse.fordiac.ide.comgeneration.implementation.ChannelEnd;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationMediaInfo;
import org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators.AbstractMediaSpecificGenerator;
import org.eclipse.fordiac.ide.comgeneration.plugin.Activator;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class CanPubSubGenerator
extends AbstractMediaSpecificGenerator {
    private static final String[] PALETTE_ENTRY_SOURCE_LOCAL = new String[]{"net/PUBL_0", "net/PUBL_1", "net/PUBL_2", "net/PUBL_3", "net/PUBL_4"};
    private static final String[] PALETTE_ENTRY_DESTINATION_LOCAL = new String[]{"net/SUBL_0", "net/SUBL_1", "net/SUBL_2", "net/SUBL_3", "net/SUBL_4"};
    private static final String[] PALETTE_ENTRY_SOURCE = new String[]{"net/PUBLISH_0", "net/PUBLISH_1", "net/PUBLISH_2", "net/PUBLISH_3", "net/PUBLISH_4"};
    private static final String[] PALETTE_ENTRY_DESTINATION = new String[]{"net/SUBSCRIBE_0", "net/SUBSCRIBE_1", "net/SUBSCRIBE_2", "net/SUBSCRIBE_3", "net/SUBSCRIBE_4"};
    public static final String PROTOCOL_ID = "CanPubSub";
    private static final int DEFAULT_START_MESSAGE_ID = 500;
    private int startMessageId = 500;
    private int currentMessageId;

    public CanPubSubGenerator(Palette palette) {
        super(palette);
        this.reset();
    }

    @Override
    public String getMediaType() {
        return "Ethernet";
    }

    @Override
    public String getProtocolId() {
        return PROTOCOL_ID;
    }

    @Override
    public FBTypePaletteEntry getPaletteType(ChannelEnd end, int numDataPorts, boolean local) {
        String[] palletEntries = local ? (end == ChannelEnd.SOURCE ? PALETTE_ENTRY_SOURCE_LOCAL : PALETTE_ENTRY_DESTINATION_LOCAL) : (end == ChannelEnd.SOURCE ? PALETTE_ENTRY_SOURCE : PALETTE_ENTRY_DESTINATION);
        String[] paletteEntryPath = palletEntries[numDataPorts].split("/");
        PaletteGroup group = this.getPalette().getRootGroup();
        int i = 0;
        while (i < paletteEntryPath.length) {
            String currentPath = paletteEntryPath[i];
            if (i == paletteEntryPath.length - 1) {
                for (PaletteEntry entry : group.getEntries()) {
                    FBTypePaletteEntry fbTypeEntry;
                    if (!(entry instanceof FBTypePaletteEntry) || !(fbTypeEntry = (FBTypePaletteEntry)entry).getLabel().equals(currentPath)) continue;
                    return fbTypeEntry;
                }
                Activator.getDefault().logError("FB type palette entry '" + currentPath + "' not found!");
            } else {
                boolean foundSubGroup = false;
                for (PaletteGroup subGroup : group.getSubGroups()) {
                    if (!subGroup.getLabel().equals(currentPath)) continue;
                    group = subGroup;
                    foundSubGroup = true;
                    break;
                }
                if (!foundSubGroup) {
                    Activator.getDefault().logError("No subgroup '" + currentPath + "'!");
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public void configureFBs(FB sourceFB, FB destinationFB, CommunicationMediaInfo mediaInfo) {
        VarDeclaration destinationId;
        VarDeclaration destinationQI;
        VarDeclaration sourceId;
        VarDeclaration sourceQI;
        if (mediaInfo.getSourceLink().getDevice().equals(mediaInfo.getDestinationLink().getDevice())) {
            sourceQI = null;
            sourceId = (VarDeclaration)sourceFB.getInterface().getInputVars().get(0);
            destinationQI = null;
            destinationId = (VarDeclaration)destinationFB.getInterface().getInputVars().get(0);
        } else {
            sourceQI = (VarDeclaration)sourceFB.getInterface().getInputVars().get(0);
            sourceId = (VarDeclaration)sourceFB.getInterface().getInputVars().get(1);
            destinationQI = (VarDeclaration)destinationFB.getInterface().getInputVars().get(0);
            destinationId = (VarDeclaration)destinationFB.getInterface().getInputVars().get(1);
        }
        String sourceValue = sourceId.getValue().getValue();
        if (sourceValue == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("CAN:");
            sb.append(mediaInfo.getSegment().getName());
            sb.append(":");
            sb.append(this.currentMessageId);
            ++this.currentMessageId;
            sourceValue = sb.toString();
            sourceId.getValue().setValue(sourceValue);
            if (sourceQI != null) {
                sourceQI.getValue().setValue("1");
            }
        }
        destinationId.getValue().setValue(sourceValue);
        if (destinationQI != null) {
            destinationQI.getValue().setValue("1");
        }
    }

    @Override
    public VarDeclaration getTargetInputData(int index, FB fb) {
        String dataName = "SD_" + (index + 1);
        for (VarDeclaration var : fb.getInterface().getInputVars()) {
            if (!var.getName().equals(dataName)) continue;
            return var;
        }
        return null;
    }

    @Override
    public VarDeclaration getTargetOutputData(int index, FB fb) {
        String dataName = "RD_" + (index + 1);
        for (VarDeclaration var : fb.getInterface().getInputVars()) {
            if (!var.getName().equals(dataName)) continue;
            return var;
        }
        return null;
    }

    @Override
    public void reset() {
        this.currentMessageId = this.startMessageId;
    }

    public void reset(int startMessageId) {
        this.startMessageId = startMessageId;
        this.reset();
    }

    @Override
    public boolean isSeparatedSource() {
        return false;
    }
}

