/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateInputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateOutputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteInputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.DeleteOutputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.contentprovider.TransactionContentProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.TransactionEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.properties.AbstractServiceSection;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TransactionSection
extends AbstractServiceSection {
    private CLabel label;
    private Text inputPrimitive;
    private Button leftInputPrimitiveNew;
    private Button rightInputPrimitiveNew;
    private Button inputPrimitiveDelete;
    private TreeViewer leftOutputPrimitivesViewer;
    private TreeViewer rightOutputPrimitivesViewer;
    private Button leftOutputPrimitivesNew;
    private Button leftOutputPrimitivesDelete;
    private Button rightOutputPrimitivesNew;
    private Button rightOutputPrimitivesDelete;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        this.createInputPrimitiveSection(parent);
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLeftOutputPrimitiveSection(composite);
        this.createRightOutputPrimitiveSection(composite);
    }

    private void createInputPrimitiveSection(Composite parent) {
        Group transactionGroup = this.getWidgetFactory().createGroup(parent, "Input Primitive");
        transactionGroup.setLayout((Layout)new GridLayout(1, false));
        transactionGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite inPrimitive = this.getWidgetFactory().createComposite((Composite)transactionGroup);
        inPrimitive.setLayout((Layout)new GridLayout(2, false));
        inPrimitive.setLayoutData((Object)new GridData(4, 128, true, false));
        this.label = this.getWidgetFactory().createCLabel(inPrimitive, null);
        this.inputPrimitive = this.createGroupText(inPrimitive, true);
        this.inputPrimitive.setEditable(false);
        this.inputPrimitive.setEnabled(false);
        Composite buttonComp = this.getWidgetFactory().createComposite((Composite)transactionGroup);
        buttonComp.setLayout((Layout)new GridLayout(3, false));
        buttonComp.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        this.leftInputPrimitiveNew = this.getWidgetFactory().createButton(buttonComp, "Create Left Primitive", 8);
        this.leftInputPrimitiveNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.leftInputPrimitiveNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransactionSection.this.executeCommand(new CreateInputPrimitiveCommand("LeftInputPrimitive", TransactionSection.this.getType()));
                TransactionSection.this.refreshInputPrimitive();
            }
        });
        this.inputPrimitiveDelete = this.getWidgetFactory().createButton(buttonComp, "Delete", 8);
        this.inputPrimitiveDelete.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.inputPrimitiveDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionSection.this.executeCommand(new DeleteInputPrimitiveCommand(TransactionSection.this.getType().getInputPrimitive()));
                TransactionSection.this.refreshInputPrimitive();
            }
        });
        this.rightInputPrimitiveNew = this.getWidgetFactory().createButton(buttonComp, "Create Right Primitive", 8);
        this.rightInputPrimitiveNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.rightInputPrimitiveNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransactionSection.this.executeCommand(new CreateInputPrimitiveCommand("RightInputPrimitive", TransactionSection.this.getType()));
                TransactionSection.this.refreshInputPrimitive();
            }
        });
    }

    private void createLeftOutputPrimitiveSection(Composite parent) {
        Group transactionGroup = this.getWidgetFactory().createGroup(parent, "Left Output Primitives");
        transactionGroup.setLayout((Layout)new GridLayout(2, false));
        transactionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.leftOutputPrimitivesViewer = new TreeViewer((Composite)transactionGroup, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 60;
        gridData.widthHint = 80;
        this.leftOutputPrimitivesViewer.getTree().setLayoutData((Object)gridData);
        this.leftOutputPrimitivesViewer.setContentProvider((IContentProvider)new TransactionContentProvider("LeftOutputPrimitive"));
        this.leftOutputPrimitivesViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory()));
        new AdapterFactoryTreeEditor(this.leftOutputPrimitivesViewer.getTree(), (AdapterFactory)this.getAdapterFactory());
        this.leftOutputPrimitivesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)TransactionSection.this.leftOutputPrimitivesViewer.getSelection()).getFirstElement();
                boolean cfr_ignored_0 = selection instanceof OutputPrimitive;
            }
        });
        Composite buttonComp = new Composite((Composite)transactionGroup, 0);
        buttonComp.setLayout((Layout)new FillLayout(512));
        this.leftOutputPrimitivesNew = this.getWidgetFactory().createButton(buttonComp, "New", 8);
        this.leftOutputPrimitivesNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.leftOutputPrimitivesNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransactionSection.this.executeCommand(new CreateOutputPrimitiveCommand("LeftOutputPrimitive", TransactionSection.this.getType(), null));
                TransactionSection.this.leftOutputPrimitivesViewer.refresh();
            }
        });
        this.leftOutputPrimitivesDelete = this.getWidgetFactory().createButton(buttonComp, "Delete", 8);
        this.leftOutputPrimitivesDelete.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.leftOutputPrimitivesDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selection = ((TreeSelection)TransactionSection.this.leftOutputPrimitivesViewer.getSelection()).getFirstElement();
                if (selection instanceof OutputPrimitive) {
                    TransactionSection.this.executeCommand(new DeleteOutputPrimitiveCommand((OutputPrimitive)selection));
                }
                TransactionSection.this.leftOutputPrimitivesViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createRightOutputPrimitiveSection(Composite parent) {
        Group transactionGroup = this.getWidgetFactory().createGroup(parent, "Right Output Primitives");
        transactionGroup.setLayout((Layout)new GridLayout(2, false));
        transactionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rightOutputPrimitivesViewer = new TreeViewer((Composite)transactionGroup, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 60;
        gridData.widthHint = 80;
        this.rightOutputPrimitivesViewer.getTree().setLayoutData((Object)gridData);
        this.rightOutputPrimitivesViewer.setContentProvider((IContentProvider)new TransactionContentProvider("RightOutputPrimitive"));
        this.rightOutputPrimitivesViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory()));
        new AdapterFactoryTreeEditor(this.rightOutputPrimitivesViewer.getTree(), (AdapterFactory)this.getAdapterFactory());
        this.rightOutputPrimitivesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)TransactionSection.this.rightOutputPrimitivesViewer.getSelection()).getFirstElement();
                boolean cfr_ignored_0 = selection instanceof OutputPrimitive;
            }
        });
        Composite buttonComp = new Composite((Composite)transactionGroup, 0);
        buttonComp.setLayout((Layout)new FillLayout(512));
        this.rightOutputPrimitivesNew = this.getWidgetFactory().createButton(buttonComp, "New", 8);
        this.rightOutputPrimitivesNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.rightOutputPrimitivesNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransactionSection.this.executeCommand(new CreateOutputPrimitiveCommand("RightOutputPrimitive", TransactionSection.this.getType(), null));
                TransactionSection.this.rightOutputPrimitivesViewer.refresh();
            }
        });
        this.rightOutputPrimitivesDelete = this.getWidgetFactory().createButton(buttonComp, "Delete", 8);
        this.rightOutputPrimitivesDelete.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.rightOutputPrimitivesDelete.addListener(13, event -> {
            Object selection = ((TreeSelection)this.rightOutputPrimitivesViewer.getSelection()).getFirstElement();
            if (selection instanceof OutputPrimitive) {
                this.executeCommand(new DeleteOutputPrimitiveCommand((OutputPrimitive)selection));
            }
            this.rightOutputPrimitivesViewer.refresh();
        });
    }

    protected ServiceTransaction getType() {
        return (ServiceTransaction)this.type;
    }

    public void refresh() {
        super.refresh();
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.leftOutputPrimitivesViewer.setInput((Object)this.getType());
            this.rightOutputPrimitivesViewer.setInput((Object)this.getType());
            this.refreshInputPrimitive();
        }
        this.commandStack = commandStackBuffer;
    }

    private void refreshInputPrimitive() {
        if (this.getType().getInputPrimitive() != null) {
            this.inputPrimitive.setText(this.getType().getInputPrimitive().getParameters() == null || this.getType().getInputPrimitive().getParameters().equals("") ? this.getType().getInputPrimitive().getEvent() : String.valueOf(this.getType().getInputPrimitive().getEvent()) + "(" + this.getType().getInputPrimitive().getParameters() + ")");
            this.label.setImage(this.isLeftInterface((Primitive)this.getType().getInputPrimitive()) ? FordiacImage.ICON_LEFT_INPUT_PRIMITIVE.getImage() : FordiacImage.ICON_RIGHT_INPUT_PRIMITIVE.getImage());
        } else {
            this.inputPrimitive.setText("");
        }
    }

    protected Object getInputType(Object input) {
        if (input instanceof TransactionEditPart) {
            return ((TransactionEditPart)((Object)input)).getCastedModel();
        }
        if (input instanceof ServiceTransaction) {
            return input;
        }
        return null;
    }

    protected CommandStack getCommandStack(IWorkbenchPart part, Object input) {
        return super.getCommandStack(part);
    }

    protected void setInputCode() {
        this.leftOutputPrimitivesNew.setEnabled(false);
        this.leftOutputPrimitivesDelete.setEnabled(false);
        this.rightOutputPrimitivesNew.setEnabled(false);
        this.rightOutputPrimitivesDelete.setEnabled(false);
    }

    protected void setInputInit() {
    }
}

