/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import org.eclipse.fordiac.ide.ui.providers.CommandProvider;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class AddDeleteWidget {
    private Button createButton;
    private Button deleteButton;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        Composite container = AddDeleteWidget.createContainer(parent);
        this.createAddButton(widgetFactory, container);
        this.createDeleteButton(widgetFactory, container);
        this.setButtonEnablement(false);
    }

    protected void createDeleteButton(TabbedPropertySheetWidgetFactory widgetFactory, Composite container) {
        this.deleteButton = widgetFactory.createButton(container, "", 8);
        this.deleteButton.setToolTipText("Delete selected interface element");
        this.deleteButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
    }

    protected void createAddButton(TabbedPropertySheetWidgetFactory widgetFactory, Composite container) {
        this.createButton = widgetFactory.createButton(container, "", 8);
        this.createButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.createButton.setToolTipText("Create element");
    }

    protected static Composite createContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData buttonCompLayoutData = new GridData(0x1000000, 128, false, false);
        container.setLayoutData((Object)buttonCompLayoutData);
        container.setLayout((Layout)new FillLayout(512));
        return container;
    }

    public void setButtonEnablement(boolean enable) {
        this.deleteButton.setEnabled(enable);
        this.deleteButton.setImage(enable ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE") : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE_DISABLED"));
    }

    public void setCreateButtonEnablement(boolean enable) {
        this.createButton.setEnabled(enable);
    }

    public void addCreateListener(Listener createListener) {
        this.createButton.addListener(13, createListener);
    }

    public void addDeleteListener(Listener deleteListener) {
        this.deleteButton.addListener(13, deleteListener);
    }

    public void bindToTableViewer(TableViewer viewer, CommandExecutor executor, CommandProvider addCommand, CommandProvider deleteCommand) {
        Listener createListener = e -> {
            executor.executeCommand(addCommand.getCommand(null));
            viewer.refresh();
        };
        Listener deleteListener = AddDeleteWidget.getSelectionListener(viewer, executor, deleteCommand);
        this.bindToTableViewer(viewer, createListener, deleteListener);
    }

    public void bindToTableViewer(TableViewer viewer, final Listener createListener, final Listener deleteListener) {
        this.addCreateListener(createListener);
        this.addDeleteListener(deleteListener);
        viewer.addSelectionChangedListener(ev -> this.setButtonEnablement(!viewer.getSelection().isEmpty()));
        viewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000009 && e.stateMask == 0) {
                    createListener.handleEvent(null);
                } else if (e.character == '\u007f' && e.stateMask == 0) {
                    deleteListener.handleEvent(null);
                }
            }
        });
    }

    public static Listener getSelectionListener(TableViewer viewer, CommandExecutor executor, CommandProvider command) {
        return ev -> {
            if (!viewer.getStructuredSelection().isEmpty()) {
                CompoundCommand cmd = new CompoundCommand();
                viewer.getStructuredSelection().toList().stream().forEach(elem -> cmd.add(command.getCommand(elem)));
                executor.executeCommand((Command)cmd);
                viewer.refresh();
            }
        };
    }
}

