/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editparts;

import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.AbstractInterfaceElementEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.TypeField;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ComboCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.ComboDirectEditManager;
import org.eclipse.fordiac.ide.gef.listeners.DiagramFontChangeListener;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.gef.policies.INamedElementRenameEditPolicy;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTypeCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ComboBoxCellEditor;

public class TypeEditPart
extends AbstractInterfaceElementEditPart {
    private Palette systemPalette;
    private Label comment;
    private DiagramFontChangeListener fontChangeListener;

    public TypeEditPart(Palette systemPalette) {
        this.systemPalette = systemPalette;
    }

    @Override
    public void activate() {
        super.activate();
        JFaceResources.getFontRegistry().addListener(this.getFontChangeListener());
    }

    @Override
    public void deactivate() {
        super.deactivate();
        JFaceResources.getFontRegistry().removeListener(this.getFontChangeListener());
    }

    private IPropertyChangeListener getFontChangeListener() {
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new DiagramFontChangeListener((IFontUpdateListener)this.getFigure());
        }
        return this.fontChangeListener;
    }

    @Override
    public IInterfaceElement getCastedModel() {
        return ((TypeField)this.getModel()).getReferencedElement();
    }

    protected IFigure createFigure() {
        this.comment = new TypeFigure();
        this.update();
        return this.comment;
    }

    public TypeFigure getFigure() {
        return (TypeFigure)super.getFigure();
    }

    @Override
    protected void update() {
        this.comment.setText(this.getTypeName());
    }

    private String getTypeName() {
        return ((TypeField)this.getModel()).getLabel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new INamedElementRenameEditPolicy(){

            protected void showCurrentEditValue(DirectEditRequest request) {
            }

            protected Command getDirectEditCommand(DirectEditRequest request) {
                int index;
                if (this.getHost() instanceof AbstractDirectEditableEditPart && (index = ((Integer)request.getCellEditor().getValue()).intValue()) > 0 && index < ((ComboDirectEditManager)TypeEditPart.this.getManager()).getComboBox().getItemCount()) {
                    String typeName = ((ComboDirectEditManager)TypeEditPart.this.getManager()).getComboBox().getItem(index);
                    ChangeTypeCommand cmd = TypeEditPart.this.getCastedModel() instanceof AdapterDeclaration ? new ChangeTypeCommand((VarDeclaration)TypeEditPart.this.getCastedModel(), (DataType)TypeEditPart.this.systemPalette.getAdapterTypeEntry(typeName).getType()) : new ChangeTypeCommand((VarDeclaration)TypeEditPart.this.getCastedModel(), DataTypeLibrary.getInstance().getType(typeName));
                    return cmd;
                }
                return null;
            }
        });
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            request.setType((Object)"direct edit");
        }
        if (request.getType() == "direct edit") {
            if (this.getCastedModel() instanceof VarDeclaration) {
                super.performRequest(request);
            }
        } else {
            super.performRequest(request);
        }
    }

    protected DirectEditManager createDirectEditManager() {
        return new ComboDirectEditManager((GraphicalEditPart)this, ComboBoxCellEditor.class, (CellEditorLocator)new ComboCellEditorLocator(this.comment), this.comment);
    }

    public void performDirectEdit() {
        ArrayList<String> dataTypeNames = new ArrayList<String>();
        if (this.getCastedModel() instanceof AdapterDeclaration) {
            this.systemPalette.getAdapterTypesSorted().forEach(adapterType -> {
                boolean bl = dataTypeNames.add(adapterType.getLabel());
            });
        } else {
            for (DataType dataType : DataTypeLibrary.getInstance().getDataTypesSorted()) {
                dataTypeNames.add(dataType.getName());
            }
        }
        ((ComboDirectEditManager)this.getManager()).updateComboData(dataTypeNames);
        ((ComboDirectEditManager)this.getManager()).setSelectedItem(dataTypeNames.indexOf(this.getTypeName()));
        this.getManager().show();
    }

    public Label getNameLabel() {
        return this.getFigure();
    }

    public INamedElement getINamedElement() {
        return this.getCastedModel();
    }

    public class TypeFigure
    extends Label
    implements IFontUpdateListener {
        public TypeFigure() {
            this.setTypeLabelFonts();
        }

        public void setText(String s) {
            VarDeclaration varDec;
            if (TypeEditPart.this.getCastedModel() instanceof VarDeclaration && (varDec = (VarDeclaration)TypeEditPart.this.getCastedModel()).isArray()) {
                s = String.valueOf(s) + "[" + varDec.getArraySize() + "]";
            }
            super.setText(s);
        }

        public void updateFonts() {
            this.setTypeLabelFonts();
            this.invalidateTree();
            this.revalidate();
        }

        private void setTypeLabelFonts() {
            this.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
        }
    }
}

