/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.network;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.application.editors.FBTypePaletteViewerProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.FBTypeEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.InterfaceContextMenuProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.network.CFBNetworkcontextMenuProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.network.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.network.editparts.CompositeNetworkEditPartFactory;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.typemanagement.FBTypeEditorInput;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class CompositeNetworkEditor
extends FBNetworkEditor
implements IFBTEditorPart {
    private CompositeFBType fbType;
    private CommandStack commandStack;
    private Palette palette;
    private EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getEventType() != 8 && (notification.getNewValue() == null && notification.getNewValue() != notification.getOldValue() || notification.getNewValue() != null && !notification.getNewValue().equals(notification.getOldValue()))) {
                super.notifyChanged(notification);
            }
        }
    };

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    protected CompositeNetworkEditPartFactory getEditPartFactory() {
        return new CompositeNetworkEditPartFactory((GraphicalEditor)this, this.getZoomManger());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.updateActions(this.getSelectionActions());
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void dispose() {
        this.getModel().eAdapters().remove((Object)this.adapter);
        super.dispose();
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        super.createActions();
        IAction action = registry.getAction((Object)"Unmap");
        registry.removeAction(action);
        action = registry.getAction((Object)"UnmapAll");
        registry.removeAction(action);
        InterfaceContextMenuProvider.createInterfaceEditingActions((IWorkbenchPart)this, (ActionRegistry)registry, (FBType)this.fbType);
        super.createActions();
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        EditPart editPart = this.getEditPartForSelection(selectedElement);
        if (editPart != null) {
            this.getGraphicalViewer().select(editPart);
            return true;
        }
        return selectedElement instanceof FBNetwork;
    }

    EditPart getEditPartForSelection(Object selectedElement) {
        Map map = this.getGraphicalViewer().getEditPartRegistry();
        for (Object key : map.keySet()) {
            if (key instanceof FB && (FB)key == selectedElement) {
                selectedElement = key;
                break;
            }
            if (!(key instanceof Connection) || (Connection)key != selectedElement) continue;
            selectedElement = key;
            break;
        }
        Object obj = this.getGraphicalViewer().getEditPartRegistry().get(selectedElement);
        if (obj instanceof EditPart) {
            return (EditPart)obj;
        }
        return null;
    }

    protected Palette getPalette() {
        return this.palette;
    }

    public AutomationSystem getSystem() {
        return this.palette.getAutomationSystem();
    }

    protected void setModel(IEditorInput input) {
        FBTypeEditorInput untypedInput;
        if (input instanceof FBTypeEditorInput && (untypedInput = (FBTypeEditorInput)input).getContent() instanceof CompositeFBType) {
            this.fbType = (CompositeFBType)untypedInput.getContent();
            this.setModel(this.fbType.getFBNetwork());
            this.getModel().eAdapters().add((Object)this.adapter);
            this.configurePalette(untypedInput);
        }
        this.setPartName(Messages.CompositeNetworkEditor_LABEL_CompositeEditor);
        this.setTitleImage(FordiacImage.ICON_FB_NETWORK.getImage());
        this.setEditDomain((DefaultEditDomain)new FBTypeEditDomain((IEditorPart)this, this.commandStack));
    }

    protected void configurePalette(FBTypeEditorInput fbTypeEditorInput) {
        Palette fbPallette = fbTypeEditorInput.getPaletteEntry().getGroup().getPallete();
        if (fbPallette != null) {
            this.palette = fbPallette;
        }
    }

    protected PaletteRoot getPaletteRoot() {
        return null;
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new FBTypePaletteViewerProvider(this.fbType.getPaletteEntry().getFile().getProject(), (EditDomain)this.getEditDomain(), this.getPalletNavigatorID());
    }

    protected String getPalletNavigatorID() {
        return "org.eclipse.fordiac.ide.compositefbpaletteviewer";
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new CFBNetworkcontextMenuProvider((DiagramEditorWithFlyoutPalette)this, this.getActionRegistry(), zoomManager, this.getPalette());
    }
}

