/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.ColorizableElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Identification;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class CommonElementExporter {
    private final Document dom;

    protected CommonElementExporter() {
        this.dom = CommonElementExporter.createDomElement();
    }

    protected CommonElementExporter(Document dom) {
        this.dom = dom;
    }

    protected Document getDom() {
        return this.dom;
    }

    protected Element createElement(String name) {
        return this.getDom().createElement(name);
    }

    private static Document createDomElement() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.newDocument();
        }
        catch (ParserConfigurationException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return null;
        }
    }

    protected void addColorAttributeElement(Element parent, ColorizableElement colElement) {
        String colorValue = String.valueOf(colElement.getColor().getRed()) + "," + colElement.getColor().getGreen() + "," + colElement.getColor().getBlue();
        Element colorAttribute = this.createAttributeElement("Color", "STRING", colorValue, "color");
        parent.appendChild(colorAttribute);
    }

    protected Element createAttributeElement(String name, String type, String value, String comment) {
        Element attributeElement = this.createElement("Attribute");
        attributeElement.setAttribute("Name", name);
        attributeElement.setAttribute("Type", type);
        attributeElement.setAttribute("Value", value);
        attributeElement.setAttribute("Comment", comment);
        return attributeElement;
    }

    protected static Transformer createXMLTransformer() throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setAttribute("indent-number", 2);
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("doctype-system", "http://www.holobloc.com/xml/LibraryElement.dtd");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("version", "1.0");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("standalone", "no");
        transformer.setOutputProperty("method", "xml");
        return transformer;
    }

    protected Element createRootElement(INamedElement namedElement, String rootElemName) {
        Element rootElement = this.createElement(rootElemName);
        CommonElementExporter.setNameAndCommentAttribute(rootElement, namedElement);
        this.dom.appendChild(rootElement);
        return rootElement;
    }

    protected void writeToFile(IFile iFile) {
        try {
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            Transformer transformer = CommonElementExporter.createXMLTransformer();
            DOMSource source = new DOMSource(this.getDom());
            transformer.transform(source, result);
            if (iFile.exists()) {
                iFile.setContents((InputStream)new ByteArrayInputStream(stringWriter.toString().getBytes("UTF-8")), 3, null);
            } else {
                CommonElementExporter.checkAndCreateFolderHierarchy(iFile);
                iFile.create((InputStream)new ByteArrayInputStream(stringWriter.toString().getBytes("UTF-8")), 3, null);
            }
            iFile.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (UnsupportedEncodingException | TransformerException | CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)e);
        }
    }

    private static void checkAndCreateFolderHierarchy(IFile file) throws CoreException {
        IFolder folder;
        IPath path = file.getProjectRelativePath().removeLastSegments(1);
        if (!path.isEmpty() && !(folder = file.getProject().getFolder(path)).exists()) {
            folder.create(true, true, null);
            folder.refreshLocal(0, null);
        }
    }

    public void addIdentification(Element parentElement, LibraryElement libraryelement) {
        if (libraryelement.getIdentification() != null) {
            Element identification = this.createElement("Identification");
            Identification ident = libraryelement.getIdentification();
            if (ident.getStandard() != null && !ident.getStandard().equals("")) {
                identification.setAttribute("Standard", ident.getStandard());
            }
            if (ident.getClassification() != null && !ident.getClassification().equals("")) {
                identification.setAttribute("Classification", ident.getClassification());
            }
            if (ident.getApplicationDomain() != null && !ident.getApplicationDomain().equals("")) {
                identification.setAttribute("ApplicationDomain", ident.getApplicationDomain());
            }
            if (ident.getFunction() != null && !ident.getFunction().equals("")) {
                identification.setAttribute("Function", ident.getFunction());
            }
            if (ident.getType() != null && !ident.getType().equals("")) {
                identification.setAttribute("Type", ident.getType());
            }
            if (ident.getDescription() != null && !ident.getDescription().equals("")) {
                identification.setAttribute("Description", ident.getDescription());
            }
            parentElement.appendChild(identification);
        }
    }

    public void addVersionInfo(Element rootEle, LibraryElement libraryelement) {
        if (!libraryelement.getVersionInfo().isEmpty()) {
            for (VersionInfo info : libraryelement.getVersionInfo()) {
                Element versionInfo = this.createElement("VersionInfo");
                if (info.getOrganization() != null && !info.getOrganization().equals("")) {
                    versionInfo.setAttribute("Organization", info.getOrganization());
                }
                if (info.getVersion() != null && !info.getVersion().equals("")) {
                    versionInfo.setAttribute("Version", info.getVersion());
                }
                if (info.getAuthor() != null && !info.getAuthor().equals("")) {
                    versionInfo.setAttribute("Author", info.getAuthor());
                }
                if (info.getDate() != null && !info.getDate().equals("")) {
                    versionInfo.setAttribute("Date", info.getDate());
                }
                if (info.getRemarks() != null && !info.getRemarks().equals("")) {
                    versionInfo.setAttribute("Remarks", info.getRemarks());
                }
                rootEle.appendChild(versionInfo);
            }
        }
    }

    protected static void setCommentAttribute(Element element, INamedElement namedElement) {
        if (namedElement.getComment() != null) {
            element.setAttribute("Comment", namedElement.getComment());
        }
    }

    static void setNameAndCommentAttribute(Element element, INamedElement namedElement) {
        CommonElementExporter.setNameAttribute(element, namedElement.getName());
        CommonElementExporter.setCommentAttribute(element, namedElement);
    }

    static void setNameTypeCommentAttribute(Element element, INamedElement namedElement, INamedElement type) {
        CommonElementExporter.setNameAttribute(element, namedElement.getName());
        CommonElementExporter.setTypeAttribute(element, type);
        CommonElementExporter.setCommentAttribute(element, namedElement);
    }

    static void setTypeAttribute(Element element, INamedElement type) {
        CommonElementExporter.setTypeAttribute(element, type != null && type.getName() != null ? type.getName() : "");
    }

    protected static void setTypeAttribute(Element element, String type) {
        element.setAttribute("Type", type != null ? type : "");
    }

    static void setNameAttribute(Element element, String name) {
        element.setAttribute("Name", name != null ? name : "");
    }

    void addParamsConfig(Element fbElement, EList<VarDeclaration> inputVars) {
        for (VarDeclaration var : inputVars) {
            if (var.getValue() == null || var.getValue().getValue() == null || var.getValue().getValue().equals("")) continue;
            Element parameterElement = this.createElement("Parameter");
            CommonElementExporter.setNameAttribute(parameterElement, var.getName());
            parameterElement.setAttribute("Value", var.getValue().getValue());
            fbElement.appendChild(parameterElement);
        }
    }

    static void exportXandY(PositionableElement fb, Element fbElement) {
        CommonElementExporter.setXYAttributes(fbElement, fb.getX(), fb.getY());
    }

    static void setXYAttributes(Element element, int x, int y) {
        element.setAttribute("x", CoordinateConverter.INSTANCE.convertTo1499XML(x));
        element.setAttribute("y", CoordinateConverter.INSTANCE.convertTo1499XML(y));
    }
}

