/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.ArrayDeque;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataexport.FBNetworkExporter;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Element;

public class SystemExporter
extends CommonElementExporter {
    private final AutomationSystem system;
    private final Element systemRootElement;

    public SystemExporter(AutomationSystem system) {
        this.system = system;
        this.systemRootElement = this.createRootElement(system, "System");
    }

    public void saveSystem(IFile targetFile) {
        if (this.getDom() != null) {
            this.addIdentification(this.systemRootElement, this.system);
            this.addVersionInfo(this.systemRootElement, this.system);
            this.addApplication();
            SystemConfiguration systemConfiguration = this.system.getSystemConfiguration();
            if (systemConfiguration != null) {
                systemConfiguration.getDevices().forEach(device -> this.addDevice((Device)device));
                this.addMapping();
                this.addSegment((List<Segment>)systemConfiguration.getSegments());
                this.addLink((List<Link>)systemConfiguration.getLinks());
            }
            this.writeToFile(targetFile);
        }
    }

    private void addApplication() {
        for (Application app : this.system.getApplication()) {
            Element appElement = this.createElement("Application");
            SystemExporter.setNameAndCommentAttribute(appElement, app);
            this.addAttributes(appElement, app.getAttributes(), app);
            appElement.appendChild(new FBNetworkExporter(this.getDom()).createFBNetworkElement(app.getFBNetwork()));
            this.systemRootElement.appendChild(appElement);
        }
    }

    private void addLink(List<Link> linksList) {
        for (Link link : linksList) {
            Element linkElement = this.createElement("Link");
            linkElement.setAttribute("SegmentName", link.getSegment().getName());
            linkElement.setAttribute("CommResource", link.getDevice().getName());
            linkElement.setAttribute("Comment", link.getComment());
            this.systemRootElement.appendChild(linkElement);
        }
    }

    private void addSegment(List<Segment> segmentsList) {
        for (Segment segment : segmentsList) {
            Element segmentElement = this.createElement("Segment");
            SystemExporter.setNameTypeCommentAttribute(segmentElement, segment, segment.getType());
            CommonElementExporter.setXYAttributes(segmentElement, segment.getX(), segment.getY());
            segmentElement.setAttribute("dx1", CoordinateConverter.INSTANCE.convertTo1499XML(segment.getWidth()));
            this.addColorAttributeElement(segmentElement, segment);
            this.addAttributes(segmentElement, segment.getAttributes(), segment);
            this.systemRootElement.appendChild(segmentElement);
        }
    }

    private void addMapping() {
        for (Mapping mappingEntry : this.system.getMapping()) {
            String fromString = SystemExporter.getFullHierarchicalName(mappingEntry.getFrom());
            String toString = SystemExporter.getFullHierarchicalName(mappingEntry.getTo());
            if (fromString == null || toString == null) continue;
            Element mappingElement = this.createElement("Mapping");
            mappingElement.setAttribute("From", fromString);
            mappingElement.setAttribute("To", toString);
            this.systemRootElement.appendChild(mappingElement);
        }
    }

    private static String getFullHierarchicalName(FBNetworkElement fbNetworkElement) {
        ArrayDeque<String> names = new ArrayDeque<String>();
        if (fbNetworkElement != null) {
            FBNetworkElement runner;
            names.addFirst(fbNetworkElement.getName());
            FBNetworkElement container = fbNetworkElement;
            while ((container = (runner = container).getFbNetwork().eContainer()) instanceof INamedElement) {
                names.addFirst(".");
                names.addFirst(((INamedElement)container).getName());
                if (container instanceof Resource) {
                    names.addFirst(".");
                    names.addFirst(((Resource)((Object)container)).getDevice().getName());
                    break;
                }
                if (container instanceof FBNetworkElement) continue;
            }
            StringBuilder fullName = new StringBuilder();
            for (String string : names) {
                fullName.append(string);
            }
            return fullName.toString();
        }
        return null;
    }

    private void addDevice(Device device) {
        Element deviceElement = this.createElement("Device");
        SystemExporter.setNameTypeCommentAttribute(deviceElement, device, device.getType());
        SystemExporter.exportXandY(device, deviceElement);
        this.addParamsConfig(deviceElement, (EList<VarDeclaration>)device.getVarDeclarations());
        this.addDeviceAttributes(deviceElement, device.getAttributes(), device);
        this.addResources(deviceElement, (List<Resource>)device.getResource());
        this.systemRootElement.appendChild(deviceElement);
    }

    private void addDeviceAttributes(Element deviceElement, EList<Attribute> attributes, Device device) {
        this.addDeviceProfile(deviceElement, device);
        this.addColorAttributeElement(deviceElement, device);
        this.addAttributes(deviceElement, attributes, device);
    }

    private void addAttributes(Element element, EList<Attribute> attributes, ConfigurableObject configurableObject) {
        for (Attribute attribute : attributes) {
            Element domAttribute = this.createAttributeElement(attribute.getName(), attribute.getType().getName(), attribute.getValue(), attribute.getComment());
            element.appendChild(domAttribute);
        }
    }

    private void addDeviceProfile(Element deviceElement, Device device) {
        String profileName = device.getProfile();
        if (profileName != null && !"".equals(profileName)) {
            Element profileAttribute = this.createAttributeElement("Profile", "STRING", profileName, "device profile");
            deviceElement.appendChild(profileAttribute);
        }
    }

    private void addResources(Element deviceElement, List<Resource> resourcesList) {
        for (Resource resource : resourcesList) {
            if (resource.isDeviceTypeResource()) continue;
            this.addResource(deviceElement, resource);
        }
    }

    private void addResource(Element parent, Resource resource) {
        Element resourceElement = this.getDom().createElement("Resource");
        SystemExporter.setNameTypeCommentAttribute(resourceElement, resource, resource.getType());
        SystemExporter.setXYAttributes(resourceElement, 0, 0);
        this.addParamsConfig(resourceElement, (EList<VarDeclaration>)resource.getVarDeclarations());
        resourceElement.appendChild(new FBNetworkExporter(this.getDom()).createFBNetworkElement(resource.getFBNetwork()));
        parent.appendChild(resourceElement);
    }
}

