/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.CompilableElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBTImporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ADPImporter {
    public static AdapterType importAdapterType(IFile iFile) {
        if (iFile.exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            try {
                dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(iFile.getContents());
                Element rootNode = document.getDocumentElement();
                return ADPImporter.parseAdapterType(rootNode);
            }
            catch (Exception e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        return null;
    }

    private static AdapterType parseAdapterType(Node rootNode) throws TypeImportException, ParseException {
        block22: {
            Node comment;
            AdapterType type = LibraryElementFactory.eINSTANCE.createAdapterType();
            AdapterFBType adapterFBType = LibraryElementFactory.eINSTANCE.createAdapterFBType();
            type.setAdapterFBType(adapterFBType);
            adapterFBType.setAdapterType(type);
            if (!rootNode.getNodeName().equals("AdapterType")) break block22;
            NamedNodeMap map = rootNode.getAttributes();
            Node name = map.getNamedItem("Name");
            if (name != null) {
                type.setName(name.getNodeValue());
            }
            if ((comment = map.getNamedItem("Comment")) != null) {
                type.setComment(comment.getNodeValue());
            }
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                switch (n.getNodeName()) {
                    case "Identification": {
                        adapterFBType.setIdentification(CommonElementImporter.parseIdentification(adapterFBType, n));
                        break;
                    }
                    case "VersionInfo": {
                        adapterFBType.getVersionInfo().add((Object)CommonElementImporter.parseVersionInfo(adapterFBType, n));
                        break;
                    }
                    case "CompilerInfo": {
                        adapterFBType.setCompilerInfo(CompilableElementImporter.parseCompilerInfo(adapterFBType, n));
                        break;
                    }
                    case "InterfaceList": {
                        adapterFBType.setInterfaceList(LibraryElementFactory.eINSTANCE.createInterfaceList());
                        ADPImporter.parseInterfaceList(adapterFBType.getInterfaceList(), n);
                        break;
                    }
                    case "Service": {
                        adapterFBType.setService(LibraryElementFactory.eINSTANCE.createService());
                        new FBTImporter().parseService(adapterFBType, n);
                        break;
                    }
                }
                ++i;
            }
            return type;
        }
        throw new ParseException("Parse Adaptertype Exception", 0);
    }

    private static void parseEventOutputs(List<Event> eventOutputs, Node node, Map<String, Event> events) throws TypeImportException {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("Event")) {
                Event e = ImportUtils.parseEvent(n);
                events.put(e.getName(), e);
                e.setIsInput(false);
                eventOutputs.add(e);
            }
            ++i;
        }
    }

    private static void parseEventInputs(List<Event> eventInputs, Node node, Map<String, Event> events) throws TypeImportException {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("Event")) {
                Event e = ImportUtils.parseEvent(n);
                e.setIsInput(true);
                events.put(e.getName(), e);
                eventInputs.add(e);
            }
            ++i;
        }
    }

    private static void parseInterfaceList(InterfaceList interfaceList, Node node) throws TypeImportException {
        HashMap<String, VarDeclaration> variables = new HashMap<String, VarDeclaration>();
        HashMap<String, Event> inputEvents = new HashMap<String, Event>();
        HashMap<String, Event> outputEvents = new HashMap<String, Event>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            switch (n.getNodeName()) {
                case "EventInputs": {
                    ADPImporter.parseEventInputs(interfaceList.getEventInputs(), n, inputEvents);
                    break;
                }
                case "EventOutputs": {
                    ADPImporter.parseEventOutputs(interfaceList.getEventOutputs(), n, outputEvents);
                    break;
                }
                case "InputVars": {
                    for (VarDeclaration v : ImportUtils.parseInputVariables(n)) {
                        interfaceList.getInputVars().add((Object)v);
                        variables.put(v.getName(), v);
                    }
                    break;
                }
                case "OutputVars": {
                    for (VarDeclaration v : ImportUtils.parseOutputVariables(n)) {
                        interfaceList.getOutputVars().add((Object)v);
                        variables.put(v.getName(), v);
                    }
                    break;
                }
            }
            ++i;
        }
        new FBTImporter().parseWithConstructs(childNodes, inputEvents, outputEvents, variables);
    }

    private ADPImporter() {
        throw new UnsupportedOperationException("ADPImporter utility class should not be instantiated!");
    }
}

