/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.text.ParseException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.CompilableElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBTImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.ReferencedTypeNotFoundException;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubAppTImporter
extends FBTImporter {
    @Override
    public void setPalette(Palette palette) {
        super.setPalette(palette);
    }

    public SubAppType importSubAppType(IFile subapptFile, Palette palette) throws ReferencedTypeNotFoundException {
        FBType newType = this.importType(subapptFile, palette);
        if (newType instanceof SubAppType) {
            return (SubAppType)newType;
        }
        return null;
    }

    @Override
    protected FBType createType() {
        return LibraryElementFactory.eINSTANCE.createSubAppType();
    }

    @Override
    protected SubAppType getType() {
        return (SubAppType)super.getType();
    }

    @Override
    protected FBType parseType(Node rootNode) throws TypeImportException, ReferencedTypeNotFoundException, ParseException {
        if (rootNode.getNodeName().equals("SubAppType")) {
            CommonElementImporter.readNameCommentAttributes(this.getType(), rootNode.getAttributes());
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("Identification")) {
                    this.getType().setIdentification(CommonElementImporter.parseIdentification(this.getType(), n));
                }
                if (n.getNodeName().equals("VersionInfo")) {
                    this.getType().getVersionInfo().add((Object)CommonElementImporter.parseVersionInfo(this.getType(), n));
                }
                if (n.getNodeName().equals("CompilerInfo")) {
                    this.getType().setCompilerInfo(CompilableElementImporter.parseCompilerInfo(this.getType(), n));
                }
                if (n.getNodeName().equals("SubAppInterfaceList")) {
                    this.getType().setInterfaceList(this.parseInterfaceList(n));
                }
                if (n.getNodeName().equals("Service")) {
                    this.parseService(this.getType(), n);
                }
                if (n.getNodeName().equals("SubAppNetwork")) {
                    this.getType().setFBNetwork(new SubAppNetworkImporter(this.getPalette(), this.getType().getInterfaceList()).parseFBNetwork(n));
                }
                ++i;
            }
            return this.getType();
        }
        throw new ParseException(Messages.SubAppTImporter_ERROR, 0);
    }

    @Override
    protected String getEventOutputElement() {
        return "SubAppEventOutputs";
    }

    @Override
    protected String getEventInputElement() {
        return "SubAppEventInputs";
    }

    @Override
    protected String getEventElement() {
        return "SubAppEvent";
    }

    @Override
    public void parseWithConstructs(NodeList childNodes, Map<String, Event> eventInputs, Map<String, Event> eventOutputs, Map<String, VarDeclaration> variables) {
    }
}

