/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editors;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.actions.FBInsertAction;
import org.eclipse.fordiac.ide.application.actions.FBNetworkElementInsertAction;
import org.eclipse.fordiac.ide.application.actions.MapAction;
import org.eclipse.fordiac.ide.application.actions.PasteEditPartsAction;
import org.eclipse.fordiac.ide.application.actions.SubAppInsertAction;
import org.eclipse.fordiac.ide.application.actions.UpdateFBTypeAction;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.application.editparts.FBEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.utilities.FBTypeTemplateCreationFactory;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.ZoomUndoRedoContextMenuProvider;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.commands.create.CreateSubAppInstanceCommand;
import org.eclipse.fordiac.ide.model.commands.create.FBCreateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.util.AdvancedPanningSelectionTool;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class UIFBNetworkContextMenuProvider
extends ZoomUndoRedoContextMenuProvider {
    private Palette palette;
    private DiagramEditorWithFlyoutPalette editor;
    private org.eclipse.swt.graphics.Point pt;
    private boolean useChangeFBType = false;

    public UIFBNetworkContextMenuProvider(DiagramEditorWithFlyoutPalette editor, ActionRegistry registry, ZoomManager zoomManager, Palette palette) {
        super((EditPartViewer)editor.getViewer(), zoomManager, registry);
        this.palette = palette;
        this.editor = editor;
        this.getViewer().getControl().addMenuDetectListener(e -> {
            this.pt = this.getViewer().getControl().toControl(e.x, e.y);
            this.pt.x = (int)((double)this.pt.x / zoomManager.getZoom());
            this.pt.y = (int)((double)this.pt.y / zoomManager.getZoom());
        });
    }

    public org.eclipse.swt.graphics.Point getPoint() {
        return this.pt;
    }

    public void buildContextMenu(IMenuManager menu) {
        AdvancedPanningSelectionTool st;
        if (this.getViewer().getEditDomain().getActiveTool() instanceof AdvancedPanningSelectionTool && !(st = (AdvancedPanningSelectionTool)this.getViewer().getEditDomain().getActiveTool()).isMoved()) {
            EditPart currentPart = this.getViewer().findObjectAt(st.getLocation());
            EditPart selected = st.getTargetEditPart();
            if (selected != null && selected.getSelected() == 0 && selected instanceof AbstractViewEditPart) {
                this.getViewer().select(currentPart);
            }
            if (selected == null) {
                this.getViewer().select(currentPart);
            }
        }
        super.buildContextMenu(menu);
        IAction action = this.getRegistry().getAction((Object)ActionFactory.SELECT_ALL.getId());
        menu.appendToGroup("org.eclipse.gef.group.edit", action);
        action = this.getRegistry().getAction((Object)ActionFactory.DELETE.getId());
        menu.appendToGroup("org.eclipse.gef.group.copy", action);
        action = this.getRegistry().getAction((Object)ActionFactory.COPY.getId());
        menu.appendToGroup("org.eclipse.gef.group.copy", action);
        action = this.getRegistry().getAction((Object)ActionFactory.PASTE.getId());
        if (action instanceof PasteEditPartsAction) {
            ((PasteEditPartsAction)action).setPastRefPosition(this.pt);
        }
        menu.appendToGroup("org.eclipse.gef.group.copy", action);
        action = this.getRegistry().getAction((Object)"org.eclipse.gef.direct_edit");
        if (action != null && action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.edit", action);
        }
        if ((action = this.getRegistry().getAction((Object)"SaveAsSubApplicationTypeAction")) != null && action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.rest", action);
        }
        this.createMappingMenuEntries(menu);
        menu.appendToGroup("org.eclipse.gef.group.rest", (IContributionItem)new Separator());
        action = this.getRegistry().getAction((Object)"UpdateFBTypeAction");
        if (action != null && action.isEnabled()) {
            menu.appendToGroup("group.add", action);
        }
        menu.add((IContributionItem)new Separator("additions"));
        this.createFBMenus(menu);
    }

    private void createFBMenus(IMenuManager menu) {
        this.useChangeFBType = false;
        String text = "Insert FB";
        List eps = this.editor.getViewer().getSelectedEditParts();
        for (Object ep : eps) {
            if (!(ep instanceof FBEditPart) && !(ep instanceof SubAppForFBNetworkEditPart)) continue;
            text = "Change Type";
            this.useChangeFBType = true;
            break;
        }
        MenuManager submenu = new MenuManager(text);
        menu.appendToGroup("group.add", (IContributionItem)submenu);
        this.fillMenuForPalletteGroup(submenu, (EList<PaletteGroup>)this.palette.getRootGroup().getSubGroups());
    }

    private void fillMenuForPalletteGroup(MenuManager insertTypeEntry, EList<PaletteGroup> subGroups) {
        for (PaletteGroup group : subGroups) {
            MenuManager submenu = new MenuManager(group.getLabel());
            this.fillMenuForPalletteGroup(submenu, (EList<PaletteGroup>)group.getSubGroups());
            for (PaletteEntry entry : group.getEntries()) {
                if (!(entry instanceof FBTypePaletteEntry) && !(entry instanceof SubApplicationTypePaletteEntry)) continue;
                Object action = this.useChangeFBType ? (Action)this.getRegistry().getAction((Object)entry.getFile().getFullPath().toString().concat("_").concat("UpdateFBTypeAction")) : (Action)this.getRegistry().getAction((Object)entry.getFile().getFullPath().toString());
                if (action == null) {
                    action = this.useChangeFBType ? this.createChangeFBTypeAction(entry) : this.createFBInsertAction(entry);
                }
                if (action == null) continue;
                submenu.add((IAction)action);
            }
            if (submenu.isEmpty()) continue;
            insertTypeEntry.add((IContributionItem)submenu);
        }
    }

    private UpdateFBTypeAction createChangeFBTypeAction(PaletteEntry entry) {
        UpdateFBTypeAction action = new UpdateFBTypeAction((IWorkbenchPart)this.editor, entry);
        this.getRegistry().registerAction((IAction)action);
        this.editor.getSelActions().add(action.getId());
        action.update();
        return action;
    }

    private FBNetworkElementInsertAction createFBInsertAction(PaletteEntry entry) {
        FBNetworkElementInsertAction action = null;
        CreateRequest request = new CreateRequest();
        request.setFactory((CreationFactory)new FBTypeTemplateCreationFactory(entry));
        org.eclipse.swt.graphics.Point location = Display.getCurrent().getCursorLocation();
        location = this.getViewer().getControl().toControl(location.x, location.y);
        request.setLocation(new Point(location));
        Command cmd = this.getViewer().getContents().getCommand((Request)request);
        if (cmd instanceof FBCreateCommand) {
            action = new FBInsertAction((IWorkbenchPart)this.editor, (FBCreateCommand)cmd);
        } else if (cmd instanceof CreateSubAppInstanceCommand) {
            action = new SubAppInsertAction((IWorkbenchPart)this.editor, (CreateSubAppInstanceCommand)cmd);
        }
        if (action != null) {
            this.getRegistry().registerAction((IAction)action);
            action.updateCreatePosition(this.pt);
        }
        return action;
    }

    protected void createMappingMenuEntries(IMenuManager menu) {
        IAction action;
        menu.appendToGroup("org.eclipse.gef.group.rest", (IContributionItem)new Separator());
        IMenuManager mappingMenuEntry = this.createHWMappingMenu();
        if (mappingMenuEntry != null) {
            menu.appendToGroup("org.eclipse.gef.group.rest", (IContributionItem)mappingMenuEntry);
        }
        if ((action = this.getRegistry().getAction((Object)"Unmap")) != null) {
            menu.appendToGroup("org.eclipse.gef.group.rest", action);
        }
        if ((action = this.getRegistry().getAction((Object)"UnmapAll")) != null) {
            menu.appendToGroup("org.eclipse.gef.group.rest", action);
        }
    }

    protected IMenuManager createHWMappingMenu() {
        MenuManager submenu = new MenuManager(Messages.UIFBNetworkContextMenuProvider_LABEL_HardwareMapping);
        GEFActionConstants.addStandardActionGroups((IMenuManager)submenu);
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (UIFBNetworkContextMenuProvider.isFBorSubAppSelected(selection) && activeEditor instanceof FBNetworkEditor) {
            FBNetworkEditor editor = (FBNetworkEditor)activeEditor;
            EList devices = editor.getSystem().getSystemConfiguration().getDevices();
            for (Device device : devices) {
                MenuManager devmenu = new MenuManager(device.getName() == null ? "Device" : device.getName());
                GEFActionConstants.addStandardActionGroups((IMenuManager)devmenu);
                EList resources = device.getResource();
                for (Resource res : resources) {
                    IAction action;
                    if (res.isDeviceTypeResource() || (action = this.getMapAction(activeEditor, res)) == null) continue;
                    editor.getSelActions().add(action.getId());
                    if (!action.isEnabled()) continue;
                    action.setChecked(this.checkIsCurrentlyMappedTo(res));
                    devmenu.appendToGroup("org.eclipse.gef.group.rest", action);
                }
                submenu.appendToGroup("org.eclipse.gef.group.rest", (IContributionItem)devmenu);
            }
        }
        return submenu;
    }

    private static boolean isFBorSubAppSelected(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof FBEditPart || element instanceof SubAppForFBNetworkEditPart) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected IAction getMapAction(IEditorPart activeEditor, Resource res) {
        if (res != null) {
            MapAction action = new MapAction((IWorkbenchPart)activeEditor, res);
            return action;
        }
        return null;
    }

    private boolean checkIsCurrentlyMappedTo(Resource res) {
        FBEditPart fbep;
        if (this.getViewer().getSelectedEditParts().size() != 1) {
            return false;
        }
        if (this.getViewer().getSelectedEditParts().get(0) instanceof FBEditPart && (fbep = (FBEditPart)((Object)this.getViewer().getSelectedEditParts().get(0))).getModel().isMapped()) {
            return res == fbep.getModel().getResource();
        }
        return false;
    }
}

