/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.figures;

import java.text.MessageFormat;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.gef.figures.VerticalLineCompartmentFigure;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;

public class FBNetworkElementTooltipFigure
extends Figure {
    public FBNetworkElementTooltipFigure(FBNetworkElement element) {
        FBNetwork fbNetwork;
        Application app;
        this.setLayoutManager((LayoutManager)new GridLayout());
        Label instanceNameLabel = new Label(element.getName());
        this.add((IFigure)instanceNameLabel);
        this.setConstraint((IFigure)instanceNameLabel, new GridData(2, 16, true, true));
        this.craeteTypeAndVersionLabel(element);
        VerticalLineCompartmentFigure line = new VerticalLineCompartmentFigure();
        this.add((IFigure)line);
        this.setConstraint((IFigure)line, new GridData(2, 16, true, true));
        if (element.getComment() != null && element.getComment().length() > 0) {
            FlowPage fp = new FlowPage();
            TextFlow content = new TextFlow(element.getComment());
            content.setLayoutManager((LayoutManager)new ParagraphTextLayout(content, 0));
            fp.add((IFigure)content);
            line.add((IFigure)fp);
            line.setConstraint((IFigure)fp, (Object)new GridData(2, 16, false, true));
        }
        Application application = app = (fbNetwork = (FBNetwork)element.eContainer()) != null ? fbNetwork.getApplication() : null;
        if (app != null && app.eContainer() instanceof AutomationSystem) {
            Label system = new Label(String.valueOf(Messages.FBTooltipFigure_LABEL_System) + ((AutomationSystem)app.eContainer()).getName());
            line.add((IFigure)system);
            line.setConstraint((IFigure)system, (Object)new GridData(2, 16, true, true));
        }
        if (app != null) {
            Label application2 = new Label(String.valueOf(Messages.FBTooltipFigure_LABEL_Application) + app.getName());
            line.add((IFigure)application2);
            line.setConstraint((IFigure)application2, (Object)new GridData(2, 16, true, true));
        }
        if (element.isMapped()) {
            FBNetworkElementTooltipFigure.createMappingInfo(element, (Figure)line);
        }
    }

    private static void createMappingInfo(FBNetworkElement element, Figure parent) {
        VerticalLineCompartmentFigure line = new VerticalLineCompartmentFigure();
        parent.add((IFigure)line);
        parent.setConstraint((IFigure)line, (Object)new GridData(2, 16, true, true));
        Resource res = element.getResource();
        Device dev = res.getDevice();
        Label mappingLabel = new Label(MessageFormat.format(Messages.FBTooltipFigure_LABEL_MappedTo, dev.getName(), res.getName()));
        line.add((IFigure)mappingLabel);
        line.setConstraint((IFigure)mappingLabel, (Object)new GridData(2, 16, true, true));
    }

    private void craeteTypeAndVersionLabel(FBNetworkElement element) {
        String labelText = Messages.FBFigure_TYPE_NOT_SET;
        FBType type = element.getType();
        if (type != null) {
            labelText = type.getName();
            if (!type.getVersionInfo().isEmpty() && type.getVersionInfo().get(0) != null) {
                VersionInfo versionInfo = (VersionInfo)type.getVersionInfo().get(0);
                labelText = String.valueOf(labelText) + " / Ver: " + versionInfo.getVersion();
            }
        }
        Label typeVersionLabel = new Label(labelText);
        this.add((IFigure)typeVersionLabel);
        this.setConstraint((IFigure)typeVersionLabel, new GridData(2, 16, true, true));
    }
}

