/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import org.eclipse.fordiac.ide.deployment.devResponse.Data;
import org.eclipse.fordiac.ide.deployment.devResponse.FB;
import org.eclipse.fordiac.ide.deployment.devResponse.Port;
import org.eclipse.fordiac.ide.deployment.devResponse.Resource;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.SystemMonitoringData;
import org.eclipse.fordiac.ide.monitoring.preferences.PreferenceConstants;
import org.eclipse.fordiac.ide.systemmanagement.Activator;

class DeviceMonitoringHandler
implements Runnable {
    private final Device device;
    private final IDeviceManagementInteractor devInteractor;
    private final SystemMonitoringData systemMonData;
    private final Thread thread;
    private boolean running = true;

    private synchronized void setRunning(boolean val) {
        this.running = val;
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    public DeviceMonitoringHandler(Device device, SystemMonitoringData systemMonData) {
        this.device = device;
        this.devInteractor = DeviceManagementInteractorFactory.INSTANCE.getDeviceManagementInteractor(device);
        this.systemMonData = systemMonData;
        this.thread = new Thread(this);
    }

    public Thread getThread() {
        return this.thread;
    }

    public IDeviceManagementInteractor getDevMgmInteractor() {
        return this.devInteractor;
    }

    public synchronized void enable() {
        this.setRunning(true);
        this.thread.start();
    }

    public synchronized void disable() {
        this.setRunning(this.running);
    }

    @Override
    public void run() {
        if (this.devInteractor != null) {
            int pollingIntervall = PreferenceConstants.getPollingInterval();
            while (this.isRunning()) {
                try {
                    Thread.sleep(pollingIntervall);
                }
                catch (InterruptedException e) {
                    Activator.getDefault().logError(e.getMessage(), (Exception)e);
                }
                if (this.devInteractor.isConnected()) {
                    try {
                        Response resp = this.devInteractor.readWatches();
                        if (resp == null) continue;
                        this.updateWatches(resp);
                    }
                    catch (DeploymentException deploymentException) {
                        this.handleDeviceIssue();
                    }
                    continue;
                }
                this.setRunning(false);
            }
        }
    }

    private void updateWatches(Response resp) {
        if (resp.getWatches() != null) {
            for (Resource res : resp.getWatches().getResources()) {
                String resName = String.valueOf(this.device.getName()) + "." + res.getName() + ".";
                for (FB fb : res.getFbs()) {
                    String fbName = String.valueOf(resName) + fb.getName() + ".";
                    for (Port p : fb.getPorts()) {
                        MonitoringBaseElement element = this.systemMonData.getMonitoringElementByPortString(String.valueOf(fbName) + p.getName());
                        if (!(element instanceof MonitoringElement)) continue;
                        DeviceMonitoringHandler.updateMonitoringElement((MonitoringElement)element, p);
                    }
                }
            }
        }
    }

    private static void updateMonitoringElement(MonitoringElement monitoringElement, Port p) {
        for (Data d : p.getDataValues()) {
            long timeAsLong = 0L;
            try {
                timeAsLong = Long.parseLong(d.getTime());
            }
            catch (NumberFormatException numberFormatException) {
                timeAsLong = 0L;
            }
            monitoringElement.setSec(timeAsLong / 1000L);
            monitoringElement.setUsec(timeAsLong % 1000L);
            monitoringElement.setCurrentValue(d.getValue());
            if (d.getForced() == null) continue;
            monitoringElement.setForce(d.getForced().equals("true"));
        }
    }

    private void handleDeviceIssue() {
        try {
            this.devInteractor.disconnect();
        }
        catch (DeploymentException deploymentException) {}
        this.systemMonData.getMonitoredElements().stream().filter(el -> el.getPort().getDevice().equals(this.device) && el instanceof MonitoringElement).forEach(el -> ((MonitoringElement)el).setCurrentValue(""));
    }
}

