/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.Iterator;
import java.util.List;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.AdapterExporter;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataexport.FbtExporter;
import org.eclipse.fordiac.ide.model.dataexport.SubApplicationTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.CompilableType;
import org.eclipse.fordiac.ide.model.libraryElement.Compiler;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractTypeExporter
extends CommonElementExporter {
    private final FBType type;

    AbstractTypeExporter(FBType type) {
        this.type = type;
    }

    AbstractTypeExporter(Document dom) {
        super(dom);
        this.type = null;
    }

    protected FBType getType() {
        return this.type;
    }

    public static void saveType(PaletteEntry entry) {
        AbstractTypeExporter exporter = null;
        if (entry instanceof FBTypePaletteEntry) {
            exporter = new FbtExporter((FBTypePaletteEntry)entry);
        } else if (entry instanceof AdapterTypePaletteEntry) {
            exporter = new AdapterExporter((AdapterTypePaletteEntry)entry);
        } else if (entry instanceof SubApplicationTypePaletteEntry) {
            exporter = new SubApplicationTypeExporter((SubApplicationTypePaletteEntry)entry);
        }
        if (exporter != null) {
            super.createXMLEntries();
            exporter.writeToFile(entry.getFile());
            entry.setLastModificationTimestamp(entry.getFile().getModificationStamp());
        }
    }

    private void createXMLEntries() {
        Element rootElement = this.createRootElement(this.getType(), this.getRootTag());
        this.addCompileAbleTypeData(rootElement, this.getType());
        this.addInterfaceList(rootElement, this.getType().getInterfaceList());
        this.createTypeSpecificXMLEntries(rootElement);
        this.addService(rootElement, this.getType());
    }

    protected abstract String getRootTag();

    protected abstract void createTypeSpecificXMLEntries(Element var1);

    private void addCompileAbleTypeData(Element rootElement, CompilableType type) {
        this.addIdentification(rootElement, type);
        this.addVersionInfo(rootElement, type);
        this.addCompilerInfo(rootElement, type.getCompilerInfo());
    }

    private void addCompilerInfo(Element rootEle, CompilerInfo compilerInfo) {
        if (compilerInfo != null) {
            Element compilerInfoElement = this.createElement("CompilerInfo");
            if (compilerInfo.getHeader() != null && !compilerInfo.getHeader().equals("")) {
                compilerInfoElement.setAttribute("header", compilerInfo.getHeader());
            }
            if (compilerInfo.getClassdef() != null && !compilerInfo.getClassdef().equals("")) {
                compilerInfoElement.setAttribute("classdef", compilerInfo.getClassdef());
            }
            compilerInfo.getCompiler().forEach(compiler -> this.addCompiler(compilerInfoElement, (Compiler)compiler));
            rootEle.appendChild(compilerInfoElement);
        }
    }

    private void addCompiler(Element compilerInfo, Compiler compiler) {
        Element compilerElement = this.createElement("Compiler");
        if (compiler.getLanguage() != null) {
            compilerElement.setAttribute("Language", compiler.getLanguage().getName());
        } else {
            compilerElement.setAttribute("Language", "");
        }
        if (compiler.getVendor() != null) {
            compilerElement.setAttribute("Vendor", compiler.getVendor());
        } else {
            compilerElement.setAttribute("Vendor", "");
        }
        if (compiler.getProduct() != null) {
            compilerElement.setAttribute("Product", compiler.getProduct());
        } else {
            compilerElement.setAttribute("Product", "");
        }
        if (compiler.getVersion() != null) {
            compilerElement.setAttribute("Version", compiler.getVersion());
        } else {
            compilerElement.setAttribute("Version", "");
        }
        compilerInfo.appendChild(compilerElement);
    }

    protected void addInterfaceList(Element rootEle, InterfaceList interfaceList) {
        Element interfaceListElement = this.createElement(this.getInterfaceListElementName());
        this.addEventList(interfaceListElement, (List<Event>)interfaceList.getEventInputs(), this.getEventInputsElementName());
        this.addEventList(interfaceListElement, (List<Event>)interfaceList.getEventOutputs(), this.getEventOutputsElementName());
        this.addVarList(interfaceListElement, (List<VarDeclaration>)interfaceList.getInputVars(), "InputVars");
        this.addVarList(interfaceListElement, (List<VarDeclaration>)interfaceList.getOutputVars(), "OutputVars");
        this.createAdapterList(interfaceListElement, (List<AdapterDeclaration>)interfaceList.getPlugs(), "Plugs");
        this.createAdapterList(interfaceListElement, (List<AdapterDeclaration>)interfaceList.getSockets(), "Sockets");
        rootEle.appendChild(interfaceListElement);
    }

    protected String getInterfaceListElementName() {
        return "InterfaceList";
    }

    private void createAdapterList(Element parentElement, List<AdapterDeclaration> adapterList, String elementName) {
        if (!adapterList.isEmpty()) {
            Element adpaterListElement = this.createElement(elementName);
            adapterList.forEach(adapter -> this.addAdapterDeclaration(adpaterListElement, (AdapterDeclaration)adapter));
            parentElement.appendChild(adpaterListElement);
        }
    }

    private void addAdapterDeclaration(Element parentElement, AdapterDeclaration adapterDecl) {
        Element adapterElement = this.createElement("AdapterDeclaration");
        AbstractTypeExporter.setNameTypeCommentAttribute(adapterElement, adapterDecl, adapterDecl.getType());
        if (adapterDecl.getAdapterFB() != null) {
            AbstractTypeExporter.exportXandY(adapterDecl.getAdapterFB(), adapterElement);
        }
        parentElement.appendChild(adapterElement);
    }

    protected void addVarList(Element parentElement, List<VarDeclaration> varList, String elementName) {
        if (!varList.isEmpty()) {
            Element varListElement = this.createElement(elementName);
            varList.forEach(varDecl -> {
                if (!(varDecl instanceof AdapterDeclaration)) {
                    this.addVariable(varListElement, (VarDeclaration)varDecl);
                }
            });
            parentElement.appendChild(varListElement);
        }
    }

    protected void addVariable(Element parentElement, VarDeclaration varDecl) {
        Element variableElement = this.createElement("VarDeclaration");
        AbstractTypeExporter.setNameTypeCommentAttribute(variableElement, varDecl, varDecl.getType());
        if (varDecl.isArray()) {
            variableElement.setAttribute("ArraySize", Integer.toString(varDecl.getArraySize()));
        }
        if (varDecl.getValue() != null && varDecl.getValue().getValue() != null) {
            variableElement.setAttribute("InitialValue", varDecl.getValue().getValue());
        }
        parentElement.appendChild(variableElement);
    }

    private void addEventList(Element parentElement, List<Event> eventList, String elementName) {
        if (!eventList.isEmpty()) {
            Element eventListElement = this.createElement(elementName);
            eventList.forEach(event -> this.addEvent(eventListElement, (Event)event));
            parentElement.appendChild(eventListElement);
        }
    }

    protected String getEventOutputsElementName() {
        return "EventOutputs";
    }

    protected String getEventInputsElementName() {
        return "EventInputs";
    }

    private void addEvent(Element parentElement, Event event) {
        Element eventElem = this.createElement(this.getEventElementName());
        AbstractTypeExporter.setNameAttribute(eventElem, event.getName());
        eventElem.setAttribute("Type", "Event");
        AbstractTypeExporter.setCommentAttribute(eventElem, event);
        this.addWith(eventElem, event);
        parentElement.appendChild(eventElem);
    }

    protected String getEventElementName() {
        return "Event";
    }

    private void addWith(Element parentElement, Event event) {
        for (With with : event.getWith()) {
            Element withElement = this.createElement("With");
            VarDeclaration varDecl = with.getVariables();
            if (varDecl.getName() != null) {
                withElement.setAttribute("Var", varDecl.getName());
            } else {
                withElement.setAttribute("Var", "");
            }
            parentElement.appendChild(withElement);
        }
    }

    private void addService(Element rootEle, FBType sfb) {
        if (sfb.getService() != null && sfb.getService().getRightInterface() != null && sfb.getService().getLeftInterface() != null) {
            Element serviceElement = this.createElement("Service");
            serviceElement.setAttribute("RightInterface", sfb.getService().getRightInterface().getName());
            serviceElement.setAttribute("LeftInterface", sfb.getService().getLeftInterface().getName());
            AbstractTypeExporter.setCommentAttribute(serviceElement, sfb);
            this.addServiceSequences(serviceElement, (List<ServiceSequence>)sfb.getService().getServiceSequence());
            rootEle.appendChild(serviceElement);
        }
    }

    private void addServiceSequences(Element serviceElement, List<ServiceSequence> sequences) {
        for (ServiceSequence seq : sequences) {
            Element seqElement = this.createElement("ServiceSequence");
            AbstractTypeExporter.setNameAttribute(seqElement, seq.getName());
            AbstractTypeExporter.setCommentAttribute(seqElement, seq);
            this.addServiceTransactions(seqElement, (List<ServiceTransaction>)seq.getServiceTransaction());
            serviceElement.appendChild(seqElement);
        }
    }

    private void addServiceTransactions(Element seqElement, List<ServiceTransaction> transactions) {
        Iterator<ServiceTransaction> iter = transactions.iterator();
        while (iter.hasNext()) {
            Element serviceTransaction = this.createElement("ServiceTransaction");
            ServiceTransaction transaction = iter.next();
            if (transaction.getInputPrimitive() != null) {
                this.addInputPrimitive(serviceTransaction, transaction);
            }
            if (!transaction.getOutputPrimitive().isEmpty()) {
                this.addOutputPrimitives(serviceTransaction, transaction);
            }
            seqElement.appendChild(serviceTransaction);
        }
    }

    private void addInputPrimitive(Element serviceTransaction, ServiceTransaction transaction) {
        Element inputPrimitive = this.createElement("InputPrimitive");
        if (transaction.getInputPrimitive().getInterface() != null && transaction.getInputPrimitive().getInterface().getName() != null) {
            inputPrimitive.setAttribute("Interface", transaction.getInputPrimitive().getInterface().getName());
        } else {
            inputPrimitive.setAttribute("Interface", "");
        }
        if (transaction.getInputPrimitive().getEvent() != null) {
            inputPrimitive.setAttribute("Event", transaction.getInputPrimitive().getEvent());
        } else {
            inputPrimitive.setAttribute("Event", "");
        }
        if (transaction.getInputPrimitive().getParameters() != null && !transaction.getInputPrimitive().getParameters().equals(" ")) {
            inputPrimitive.setAttribute("Parameters", transaction.getInputPrimitive().getParameters());
        }
        serviceTransaction.appendChild(inputPrimitive);
    }

    private void addOutputPrimitives(Element serviceTransaction, ServiceTransaction transaction) {
        Iterator iter = transaction.getOutputPrimitive().iterator();
        while (iter.hasNext()) {
            Element outputPrimitive = this.createElement("OutputPrimitive");
            OutputPrimitive primitive = (OutputPrimitive)iter.next();
            outputPrimitive.setAttribute("Interface", primitive.getInterface().getName());
            if (primitive.getEvent() != null) {
                outputPrimitive.setAttribute("Event", primitive.getEvent());
            } else {
                outputPrimitive.setAttribute("Event", "");
            }
            if (primitive.getParameters() != null && !primitive.getParameters().equals(" ")) {
                outputPrimitive.setAttribute("Parameters", primitive.getParameters());
            }
            serviceTransaction.appendChild(outputPrimitive);
        }
    }
}

