/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.figures.AbstractFBNetworkElementFigure;
import org.eclipse.fordiac.ide.application.policies.DeleteFBNElementEditPolicy;
import org.eclipse.fordiac.ide.application.policies.FBNElementSelectionPolicy;
import org.eclipse.fordiac.ide.gef.editparts.AbstractPositionableElementEditPart;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.gef.editparts.NameCellEditorLocator;
import org.eclipse.fordiac.ide.gef.listeners.DiagramFontChangeListener;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.gef.policies.AbstractViewRenameEditPolicy;
import org.eclipse.fordiac.ide.model.commands.change.ChangeFBNetworkElementName;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyListener;

public abstract class AbstractFBNElementEditPart
extends AbstractPositionableElementEditPart {
    private Device referencedDevice;
    private DiagramFontChangeListener fontChangeListener;
    private final ZoomManager zoomManager;
    private EContentAdapter colorChangeListener = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getColorizableElement_Color()) {
                AbstractFBNElementEditPart.this.backgroundColorChanged((IFigure)AbstractFBNElementEditPart.this.getFigure());
            }
        }
    };
    private final EContentAdapter annotationContentAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getI4DIACElement_Annotations()) {
                AbstractFBNElementEditPart.this.refreshName();
            }
        }
    };
    private IPropertyChangeListener listener;

    public ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    public AbstractFBNElementEditPart(ZoomManager zoomManager) {
        this.zoomManager = zoomManager;
    }

    public AbstractFBNetworkElementFigure getFigure() {
        return (AbstractFBNetworkElementFigure)super.getFigure();
    }

    protected EContentAdapter createContentAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                AbstractFBNElementEditPart.this.refreshToolTip();
                if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getFBNetworkElement_Mapping()) {
                    AbstractFBNElementEditPart.this.updateDeviceListener();
                }
            }
        };
    }

    protected void updateDeviceListener() {
        Device device = this.findDevice();
        if (device != this.referencedDevice) {
            if (this.referencedDevice != null) {
                this.referencedDevice.eAdapters().remove((Object)this.colorChangeListener);
            }
            this.referencedDevice = device;
            if (this.referencedDevice != null) {
                this.referencedDevice.eAdapters().add((Object)this.colorChangeListener);
            }
            this.backgroundColorChanged((IFigure)this.getFigure());
        }
    }

    public void activate() {
        super.activate();
        this.updateDeviceListener();
        if (this.getModel() != null) {
            this.getModel().eAdapters().add((Object)this.annotationContentAdapter);
        }
        JFaceResources.getFontRegistry().addListener(this.getFontChangeListener());
    }

    public void deactivate() {
        super.deactivate();
        if (this.referencedDevice != null) {
            this.referencedDevice.eAdapters().remove((Object)this.colorChangeListener);
        }
        if (this.getModel() != null) {
            this.getModel().eAdapters().remove((Object)this.annotationContentAdapter);
        }
        JFaceResources.getFontRegistry().removeListener(this.getFontChangeListener());
    }

    private IPropertyChangeListener getFontChangeListener() {
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new DiagramFontChangeListener((IFontUpdateListener)this.getFigure());
        }
        return this.fontChangeListener;
    }

    public boolean isOnlyThisOrNothingSelected() {
        List selection = this.getViewer().getSelectedEditParts();
        if (selection.size() > 1) {
            return false;
        }
        if (selection.size() == 1) {
            return selection.get(0) == this;
        }
        return true;
    }

    protected void refreshToolTip() {
        this.getFigure().refreshToolTips();
    }

    protected void refreshComment() {
        this.refreshToolTip();
    }

    protected void refreshName() {
        super.refreshName();
        this.getFigure().refreshIcon();
    }

    public FBNetworkElement getModel() {
        return (FBNetworkElement)super.getModel();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteFBNElementEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new FBNElementSelectionPolicy());
        this.removeEditPolicy("DirectEditPolicy");
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new AbstractViewRenameEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                if (this.getHost() instanceof AbstractFBNElementEditPart) {
                    return new ChangeFBNetworkElementName(((AbstractFBNElementEditPart)this.getHost()).getModel(), (String)request.getCellEditor().getValue());
                }
                return null;
            }
        });
    }

    public Label getInstanceNameLabel() {
        return this.getFigure().getInstanceNameLabel();
    }

    public IPropertyChangeListener getPreferenceChangeListener() {
        if (this.listener == null) {
            this.listener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("EventConnectionConnectorColor") || event.getProperty().equals("DataConnectionConnectorColor") || event.getProperty().equals("AdapterConnectionConnectorColor")) {
                        AbstractFBNElementEditPart.this.getFigure().repaint();
                    }
                }
            };
        }
        return this.listener;
    }

    protected void backgroundColorChanged(IFigure figure) {
        Device dev;
        Color color = null;
        if (this.getModel() != null && (dev = this.findDevice()) != null) {
            color = LibraryElementFactory.eINSTANCE.createColor();
            color.setRed(dev.getColor().getRed());
            color.setGreen(dev.getColor().getGreen());
            color.setBlue(dev.getColor().getBlue());
        }
        this.setColor(figure, color);
    }

    private Device findDevice() {
        Resource res = null;
        if (this.getModel() != null && this.getModel().isMapped()) {
            res = this.getModel().getResource();
        }
        return res != null ? res.getDevice() : null;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof InterfaceEditPart) {
            InterfaceEditPart interfaceEditPart = (InterfaceEditPart)childEditPart;
            if (interfaceEditPart.isInput()) {
                if (interfaceEditPart.isEvent()) {
                    this.getFigure().getEventInputs().add(child, this.getModel().getInterface().getEventInputs().indexOf((Object)interfaceEditPart.getModel()));
                } else if (interfaceEditPart.isAdapter()) {
                    this.getFigure().getSockets().add(child, this.getModel().getInterface().getSockets().indexOf((Object)interfaceEditPart.getModel()));
                } else if (interfaceEditPart.isVariable()) {
                    this.getFigure().getDataInputs().add(child, this.getModel().getInterface().getInputVars().indexOf((Object)interfaceEditPart.getModel()));
                }
            } else if (interfaceEditPart.isEvent()) {
                this.getFigure().getEventOutputs().add(child, this.getModel().getInterface().getEventOutputs().indexOf((Object)interfaceEditPart.getModel()));
            } else if (interfaceEditPart.isAdapter()) {
                this.getFigure().getPlugs().add(child, this.getModel().getInterface().getPlugs().indexOf((Object)interfaceEditPart.getModel()));
            } else if (interfaceEditPart.isVariable()) {
                this.getFigure().getDataOutputs().add(child, this.getModel().getInterface().getOutputVars().indexOf((Object)interfaceEditPart.getModel()));
            }
        } else {
            super.addChildVisual(childEditPart, index);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof InterfaceEditPart) {
            InterfaceEditPart interfaceEditPart = (InterfaceEditPart)childEditPart;
            if (interfaceEditPart.isInput()) {
                if (interfaceEditPart.isEvent()) {
                    this.getFigure().getEventInputs().remove(child);
                } else if (interfaceEditPart.isAdapter()) {
                    this.getFigure().getSockets().remove(child);
                } else if (interfaceEditPart.isVariable()) {
                    this.getFigure().getDataInputs().remove(child);
                }
            } else if (interfaceEditPart.isEvent()) {
                this.getFigure().getEventOutputs().remove(child);
            } else if (interfaceEditPart.isAdapter()) {
                this.getFigure().getPlugs().remove(child);
            } else if (interfaceEditPart.isVariable()) {
                this.getFigure().getDataOutputs().remove(child);
            }
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.addAll((Collection<Object>)this.getModel().getInterface().getAllInterfaceElements());
        return elements;
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    protected PositionableElement getPositionableElement() {
        return this.getModel();
    }

    public Label getNameLabel() {
        return this.getInstanceNameLabel();
    }

    protected DirectEditManager createDirectEditManager() {
        Label l = this.getNameLabel();
        return new LabelDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, (CellEditorLocator)new NameCellEditorLocator(l), l, (VerifyListener)new IdentifierVerifyListener());
    }

    public void setTransparency(int value) {
        for (Object ep : this.getChildren()) {
            if (!(ep instanceof AbstractViewEditPart)) continue;
            ((AbstractViewEditPart)ep).setTransparency(value);
        }
        super.setTransparency(value);
    }
}

