/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;

public abstract class AbstractCreateFBNetworkElementCommand
extends Command {
    private final FBNetworkElement element;
    private final FBNetwork fbNetwork;
    private int x;
    private int y;

    public AbstractCreateFBNetworkElementCommand(FBNetwork fbNetwork, FBNetworkElement element, int x, int y) {
        this.fbNetwork = fbNetwork;
        this.element = element;
        this.x = x;
        this.y = y;
    }

    public boolean canExecute() {
        return this.fbNetwork != null;
    }

    public void execute() {
        this.element.setInterface((InterfaceList)EcoreUtil.copy((EObject)this.getTypeInterfaceList()));
        this.element.setX(this.x);
        this.element.setY(this.y);
        this.createValues();
        this.fbNetwork.getNetworkElements().add((Object)this.element);
        this.element.setName(NameRepository.createUniqueName((INamedElement)this.element, (String)this.getInitalInstanceName()));
    }

    public void redo() {
        this.fbNetwork.getNetworkElements().add((Object)this.element);
    }

    public void undo() {
        this.fbNetwork.getNetworkElements().remove((Object)this.element);
    }

    public void updateCreatePosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public FBNetworkElement getElement() {
        return this.element;
    }

    protected String getInitalInstanceName() {
        return this.element.getTypeName();
    }

    protected void createValues() {
        for (VarDeclaration inputVar : this.element.getInterface().getInputVars()) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            inputVar.setValue(value);
        }
    }

    protected abstract InterfaceList getTypeInterfaceList();
}

