/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.create.AdapterCreateCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EventType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.gef.commands.Command;

public class CreateInterfaceElementCommand
extends Command {
    private boolean isInput;
    private DataType dataType;
    private IInterfaceElement interfaceElement;
    private EList<? extends IInterfaceElement> interfaces;
    private int index;
    private InterfaceList interfaceList;
    private AdapterCreateCommand cmd;

    public CreateInterfaceElementCommand(DataType dataType, InterfaceList interfaceList, boolean isInput, int index) {
        this.isInput = isInput;
        this.dataType = dataType;
        this.index = index;
        this.interfaceList = interfaceList;
    }

    protected boolean isInput() {
        return this.isInput;
    }

    protected DataType getDataType() {
        return this.dataType;
    }

    protected InterfaceList getInterfaceList() {
        return this.interfaceList;
    }

    protected int getIndex() {
        return this.index;
    }

    public IInterfaceElement getInterfaceElement() {
        return this.interfaceElement;
    }

    public boolean canExecute() {
        return this.dataType != null && this.interfaceList != null;
    }

    private void setInterfaces(InterfaceList interfaceList) {
        this.interfaces = this.isInput ? (this.dataType instanceof EventType ? interfaceList.getEventInputs() : (this.dataType instanceof AdapterType ? interfaceList.getSockets() : interfaceList.getInputVars())) : (this.dataType instanceof EventType ? interfaceList.getEventOutputs() : (this.dataType instanceof AdapterType ? interfaceList.getPlugs() : interfaceList.getOutputVars()));
    }

    public void execute() {
        this.interfaceElement = this.dataType instanceof EventType ? LibraryElementFactory.eINSTANCE.createEvent() : (this.dataType instanceof AdapterType ? LibraryElementFactory.eINSTANCE.createAdapterDeclaration() : LibraryElementFactory.eINSTANCE.createVarDeclaration());
        this.setInterfaces(this.interfaceList);
        this.interfaceElement.setIsInput(this.isInput);
        this.interfaceElement.setType(this.dataType);
        this.interfaceElement.setTypeName(this.dataType.getName());
        if (this.dataType instanceof AdapterType && this.interfaceList.eContainer() instanceof CompositeFBType && !(this.interfaceList.eContainer() instanceof SubAppType)) {
            this.cmd = new AdapterCreateCommand(10, 10, (AdapterDeclaration)this.interfaceElement, (CompositeFBType)this.interfaceList.eContainer());
        }
        this.redo();
        this.interfaceElement.setName(NameRepository.createUniqueName((INamedElement)this.interfaceElement, (String)this.dataType.getName()));
    }

    public void redo() {
        EList<? extends IInterfaceElement> temp = this.interfaces;
        temp.add(this.index == -1 ? temp.size() : this.index, (Object)this.interfaceElement);
        if (this.cmd != null) {
            this.cmd.execute();
        }
    }

    public void undo() {
        EList<? extends IInterfaceElement> temp = this.interfaces;
        temp.remove((Object)this.interfaceElement);
        if (this.cmd != null && this.cmd.canExecute()) {
            this.cmd.undo();
        }
    }
}

