/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef;

import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionFactory;

public class ZoomUndoRedoContextMenuProvider
extends ContextMenuProvider {
    private final ZoomManager zoomManager;
    private final ActionRegistry registry;

    public ZoomUndoRedoContextMenuProvider(EditPartViewer viewer, ZoomManager zoomManager, ActionRegistry registry) {
        super(viewer);
        this.zoomManager = zoomManager;
        this.registry = registry;
    }

    public ActionRegistry getRegistry() {
        return this.registry;
    }

    public void buildContextMenu(IMenuManager menu) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
        menu.appendToGroup("org.eclipse.gef.group.view", (IAction)new GraphZoomInAction(this.zoomManager));
        menu.appendToGroup("org.eclipse.gef.group.view", (IAction)new GraphZoomOutAction(this.zoomManager));
        IAction action = this.registry.getAction((Object)ActionFactory.UNDO.getId());
        menu.appendToGroup("org.eclipse.gef.group.undo", action);
        action = this.registry.getAction((Object)ActionFactory.REDO.getId());
        menu.appendToGroup("org.eclipse.gef.group.undo", action);
        MenuManager submenu = new MenuManager("&Align");
        action = this.registry.getAction((Object)"org.eclipse.gef.align_left");
        if (action != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_center")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_right")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        submenu.add((IContributionItem)new Separator());
        action = this.registry.getAction((Object)"org.eclipse.gef.align_top");
        if (action != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_middle")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_bottom")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if (!submenu.isEmpty()) {
            menu.appendToGroup("org.eclipse.gef.group.rest", (IContributionItem)submenu);
        }
        if ((action = this.registry.getAction((Object)ActionFactory.PRINT.getId())) != null && action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.rest", action);
        }
    }

    private static final class GraphZoomInAction
    extends ZoomInAction {
        public GraphZoomInAction(ZoomManager zoomManager) {
            super(zoomManager);
        }

        public boolean isEnabled() {
            return this.zoomManager.canZoomIn();
        }
    }

    private static final class GraphZoomOutAction
    extends ZoomOutAction {
        public GraphZoomOutAction(ZoomManager zoomManager) {
            super(zoomManager);
        }

        public boolean isEnabled() {
            return this.zoomManager.canZoomOut();
        }
    }
}

