/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.iec61499;

import java.io.EOFException;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.fordiac.ide.deployment.IDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.devResponse.DevResponseFactory;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.iec61499.EthernetDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.iec61499.Messages;
import org.eclipse.fordiac.ide.deployment.iec61499.ResponseMapping;
import org.eclipse.fordiac.ide.deployment.interactors.AbstractDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.monitoringbase.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.xml.sax.InputSource;

public class DeploymentExecutor
extends AbstractDeviceManagementInteractor {
    public static final String CREATE_RESOURCE_INSTANCE = "<Request ID=\"{0}\" Action=\"CREATE\"><FB Name=\"{1}\" Type=\"{2}\" /></Request>";
    public static final String CREATE_FB_INSTANCE = "<Request ID=\"{0}\" Action=\"CREATE\"><FB Name=\"{1}\" Type=\"{2}\" /></Request>";
    public static final String CREATE_CONNECTION = "<Request ID=\"{0}\" Action=\"CREATE\"><Connection Source=\"{1}\" Destination=\"{2}\" /></Request>";
    public static final String WRITE_PARAMETER = "<Request ID=\"{0}\" Action=\"WRITE\"><Connection Source=\"{1}\" Destination=\"{2}\" /></Request>";
    public static final String START = "<Request ID=\"{0}\" Action=\"START\"/>";
    public static final String START_FB = "<Request ID=\"{0}\" Action=\"START\"><FB Name=\"{1}\" Type=\"{2}\"/></Request>";
    public static final String KILL_FB = "<Request ID=\"{0}\" Action=\"KILL\"><FB Name=\"{1}\" Type=\"\"/></Request>";
    public static final String KILL_DEVICE = "<Request ID=\"{0}\" Action=\"KILL\"></Request>";
    public static final String STOP_FB = "<Request ID=\"{0}\" Action=\"STOP\"><FB Name=\"{1}\" Type=\"\"/></Request>";
    public static final String DELETE_FB = "<Request ID=\"{0}\" Action=\"DELETE\"><FB Name=\"{1}\" Type=\"\"/></Request>";
    public static final String DELETE_CONNECTION = "<Request ID=\"{0}\" Action=\"DELETE\"><Connection Source=\"{1}\" Destination=\"{2}\"/></Request>";
    public static final String QUERY_FB_INSTANCES = "<Request ID=\"{0}\" Action=\"QUERY\"><FB Name=\"*\" Type=\"*\"/></Request>";
    public static final String READ_WATCHES = "<Request ID=\"{0}\" Action=\"READ\"><Watches/></Request>";
    public static final String ADD_WATCH = "<Request ID=\"{0}\" Action=\"CREATE\"><Watch Source=\"{1}\" Destination=\"{2}\" /></Request>";
    public static final String DELETE_WATCH = "<Request ID=\"{0}\" Action=\"DELETE\"><Watch Source=\"{1}\" Destination=\"{2}\" /></Request>";
    public static final String FORCE_VALUE = "<Request ID=\"{0}\" Action=\"WRITE\"><Connection Source=\"{1}\" Destination=\"{2}\" force=\"{3}\" /></Request>";
    public static final Response EMPTY_RESPONSE = DevResponseFactory.eINSTANCE.createResponse();
    private final Set<String> genFBs = new HashSet<String>();
    private int id = 0;
    private ResponseMapping respMapping = new ResponseMapping();

    static {
        EMPTY_RESPONSE.setFblist(DevResponseFactory.eINSTANCE.createFBList());
        EMPTY_RESPONSE.setID("0");
        EMPTY_RESPONSE.setWatches(DevResponseFactory.eINSTANCE.createWatches());
    }

    int getNextId() {
        return this.id++;
    }

    public DeploymentExecutor(Device dev) {
        this(dev, null);
    }

    public DeploymentExecutor(Device dev, IDeviceManagementCommunicationHandler overrideHandler) {
        super(dev, overrideHandler);
        this.genFBs.add("PUBLISH");
        this.genFBs.add("SUBSCRIBE");
        this.genFBs.add("PUBL");
        this.genFBs.add("SUBL");
        this.genFBs.add("SERVER");
        this.genFBs.add("CLIENT");
    }

    protected IDeviceManagementCommunicationHandler createCommunicationHandler(Device dev) {
        return new EthernetDeviceManagementCommunicationHandler();
    }

    private static String getValidType(FB fb) {
        if (fb != null && fb.getPaletteEntry() != null) {
            return fb.getTypeName();
        }
        return null;
    }

    public void createResource(Resource resource) throws DeploymentException {
        String request = MessageFormat.format("<Request ID=\"{0}\" Action=\"CREATE\"><FB Name=\"{1}\" Type=\"{2}\" /></Request>", this.getNextId(), resource.getName(), resource.getTypeName());
        try {
            this.sendREQ("", request);
        }
        catch (EOFException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_DeviceConnectionClosed, resource.getName()), (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_CreateResourceFailed, resource.getName()), (Throwable)e);
        }
    }

    public void writeResourceParameter(Resource resource, String parameter, String value) throws DeploymentException {
        String encodedValue = DeploymentExecutor.encodeXMLChars(value);
        String request = this.generateWriteParamRequest(resource.getName(), parameter, encodedValue);
        try {
            this.sendREQ("", request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_WriteResourceParameterFailed, resource.getName(), parameter), (Throwable)e);
        }
    }

    protected String generateWriteParamRequest(String targetElementName, String parameter, String value) {
        return MessageFormat.format(this.getWriteParameterMessage(), this.getNextId(), value, String.valueOf(targetElementName) + "." + parameter);
    }

    protected String getWriteParameterMessage() {
        return WRITE_PARAMETER;
    }

    private static String encodeXMLChars(String value) {
        String retVal = value;
        retVal = retVal.replaceAll("\"", "&quot;");
        retVal = retVal.replaceAll("'", "&apos;");
        retVal = retVal.replaceAll("<", "&lt;");
        retVal = retVal.replaceAll(">", "&gt;");
        return retVal;
    }

    public void writeFBParameter(Resource resource, String value, FBDeploymentData fbData, VarDeclaration varDecl) throws DeploymentException {
        String encodedValue = DeploymentExecutor.encodeXMLChars(value);
        String request = this.generateWriteParamRequest(String.valueOf(fbData.getPrefix()) + fbData.getFb().getName(), varDecl.getName(), encodedValue);
        try {
            this.sendREQ(resource.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_WriteFBParameterFailed, resource.getName(), varDecl.getName()), (Throwable)e);
        }
    }

    public void createConnection(Resource resource, ConnectionDeploymentData connData) throws DeploymentException {
        IInterfaceElement source = connData.getSource();
        IInterfaceElement destination = connData.getDestination();
        if (source != null && destination != null && source.getFBNetworkElement() != null && destination.getFBNetworkElement() != null) {
            FBNetworkElement sourceFB = source.getFBNetworkElement();
            FBNetworkElement destFB = destination.getFBNetworkElement();
            String request = MessageFormat.format(CREATE_CONNECTION, this.getNextId(), String.valueOf(connData.getSourcePrefix()) + sourceFB.getName() + "." + source.getName(), String.valueOf(connData.getDestinationPrefix()) + destFB.getName() + "." + destination.getName());
            try {
                this.sendREQ(resource.getName(), request);
            }
            catch (IOException e) {
                throw new DeploymentException(Messages.DeploymentExecutor_CreateConnectionFailed, (Throwable)e);
            }
        } else {
            throw new DeploymentException(Messages.DeploymentExecutor_CreateConnectionFailed);
        }
    }

    public void startResource(Resource res) throws DeploymentException {
        String request = MessageFormat.format(START, this.id++);
        try {
            this.sendREQ(res.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_StartingResourceFailed, res.getName()), (Throwable)e);
        }
    }

    public void startDevice(Device dev) throws DeploymentException {
        String request = MessageFormat.format(START, this.id++);
        try {
            this.sendREQ("", request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_StartingDeviceFailed, dev.getName()), (Throwable)e);
        }
    }

    public void writeDeviceParameter(Device device, String parameter, String value) throws DeploymentException {
        String request = MessageFormat.format(this.getWriteParameterMessage(), this.id++, value, parameter);
        try {
            this.sendREQ("", request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_WriteDeviceParameterFailed, device.getName(), parameter), (Throwable)e);
        }
    }

    public void deleteResource(String resName) throws DeploymentException {
        String kill = MessageFormat.format(KILL_FB, this.getNextId(), resName);
        String delete = MessageFormat.format(DELETE_FB, this.getNextId(), resName);
        try {
            this.sendREQ("", kill);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_KillFBFailed, resName), (Throwable)e);
        }
        try {
            this.sendREQ("", delete);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_DeleteFBFailed, resName), (Throwable)e);
        }
    }

    public void deleteConnection(Resource res, ConnectionDeploymentData conData) throws DeploymentException {
    }

    public void deleteFB(Resource res, FBDeploymentData fbData) throws DeploymentException {
    }

    public void startFB(Resource res, FBDeploymentData fbData) throws DeploymentException {
        String fullFbInstanceName = String.valueOf(fbData.getPrefix()) + fbData.getFb().getName();
        String request = MessageFormat.format(START_FB, this.getNextId(), fullFbInstanceName, fbData.getFb().getTypeName());
        try {
            this.sendREQ(res.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_StartingFBFailed, fullFbInstanceName), (Throwable)e);
        }
    }

    public void createFBInstance(FBDeploymentData fbData, Resource res) throws DeploymentException {
        String fbType = DeploymentExecutor.getValidType(fbData.getFb());
        String fullFbInstanceName = String.valueOf(fbData.getPrefix()) + fbData.getFb().getName();
        if ("".equals(fbType)) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_CreateFBInstanceFailedNoTypeFound, fullFbInstanceName));
        }
        String request = MessageFormat.format("<Request ID=\"{0}\" Action=\"CREATE\"><FB Name=\"{1}\" Type=\"{2}\" /></Request>", this.getNextId(), fullFbInstanceName, fbType);
        try {
            this.sendREQ(res.getName(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_CreateFBInstanceFailed, fullFbInstanceName), (Throwable)e);
        }
    }

    public void killDevice(Device dev) throws DeploymentException {
        String kill = MessageFormat.format(KILL_DEVICE, this.getNextId());
        try {
            try {
                this.sendREQ("", kill);
            }
            catch (EOFException eOFException) {
                this.resetTypes();
            }
            catch (IOException e) {
                throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_KillDeviceFailed, dev.getName()), (Throwable)e);
            }
        }
        finally {
            this.resetTypes();
        }
    }

    public List<org.eclipse.fordiac.ide.deployment.devResponse.Resource> queryResources() throws DeploymentException {
        try {
            String result = this.sendREQ("", MessageFormat.format(QUERY_FB_INSTANCES, this.getNextId()));
            Response resp = this.parseResponse(result);
            if (resp.getFblist() != null && resp.getFblist().getFbs() != null) {
                return resp.getFblist().getFbs().stream().map(fb -> {
                    org.eclipse.fordiac.ide.deployment.devResponse.Resource res = DevResponseFactory.eINSTANCE.createResource();
                    res.setName(fb.getName());
                    res.setType(fb.getType());
                    return res;
                }).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_QueryResourcesFailed, this.getDevice().getName()), (Throwable)e);
        }
    }

    protected Response parseResponse(String result) throws IOException {
        if (result != null) {
            InputSource source = new InputSource(new StringReader(result));
            XMLResourceImpl xmlResource = new XMLResourceImpl();
            xmlResource.load(source, this.respMapping.getLoadOptions());
            for (EObject object : xmlResource.getContents()) {
                if (!(object instanceof Response)) continue;
                return (Response)object;
            }
        }
        return EMPTY_RESPONSE;
    }

    public Response readWatches() throws DeploymentException {
        String request = MessageFormat.format(READ_WATCHES, this.getNextId());
        try {
            return this.parseResponse(this.sendREQ("", request));
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_ReadWatchesFailed, this.getDevice().getName()), (Throwable)e);
        }
    }

    public void addWatch(MonitoringBaseElement element) throws DeploymentException {
        String request = MessageFormat.format(ADD_WATCH, this.getNextId(), element.getQualifiedString(), "*");
        try {
            String response = this.sendREQ(element.getResourceString(), request);
            element.setOffline("".equals(response));
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_AddWatchesFailed, element.getQualifiedString()), (Throwable)e);
        }
    }

    public void removeWatch(MonitoringBaseElement element) throws DeploymentException {
        String request = MessageFormat.format(DELETE_WATCH, this.getNextId(), element.getQualifiedString(), "*");
        try {
            String response = this.sendREQ(element.getResourceString(), request);
            element.setOffline("".equals(response));
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_DeleteWatchesFailed, element.getQualifiedString()), (Throwable)e);
        }
    }

    public void triggerEvent(MonitoringBaseElement element) throws DeploymentException {
        String request = MessageFormat.format(this.getWriteParameterMessage(), this.getNextId(), "$e", element.getQualifiedString());
        try {
            this.sendREQ(element.getResourceString(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_TriggerEventFailed, element.getQualifiedString()), (Throwable)e);
        }
    }

    public void forceValue(MonitoringBaseElement element, String value) throws DeploymentException {
        String request = MessageFormat.format(FORCE_VALUE, this.getNextId(), value, element.getQualifiedString(), "true");
        try {
            this.sendREQ(element.getResourceString(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_ForceValueFailed, element.getQualifiedString(), value), (Throwable)e);
        }
    }

    public void clearForce(MonitoringBaseElement element) throws DeploymentException {
        String request = MessageFormat.format(FORCE_VALUE, this.getNextId(), "*", element.getQualifiedString(), "false");
        try {
            this.sendREQ(element.getResourceString(), request);
        }
        catch (IOException e) {
            throw new DeploymentException(MessageFormat.format(Messages.DeploymentExecutor_ClearForceFailed, element.getQualifiedString()), (Throwable)e);
        }
    }
}

