/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class SegmentSetConstraintCommand
extends Command {
    private static final String MOVE_LABEL = "Move/Resize";
    private final Rectangle newBounds;
    private Rectangle oldBounds;
    private final ChangeBoundsRequest request;
    private final Segment segment;

    public SegmentSetConstraintCommand(Segment segment, Rectangle newBounds, ChangeBoundsRequest request) {
        this.setLabel(MOVE_LABEL);
        this.newBounds = newBounds;
        this.segment = segment;
        this.request = request;
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type) || "resize".equals(type) || "resize children".equals(type) || "align children".equals(type);
    }

    public void execute() {
        this.oldBounds = new Rectangle(this.segment.getX(), this.segment.getY(), this.segment.getWidth(), -1);
        this.redo();
    }

    public void redo() {
        this.segment.setX(this.newBounds.x);
        this.segment.setY(this.newBounds.y);
        this.segment.setWidth(this.newBounds.width);
    }

    public void undo() {
        this.segment.setWidth(this.oldBounds.width);
        this.segment.setX(this.oldBounds.x);
        this.segment.setY(this.oldBounds.y);
    }
}

