/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.gef.commands.Command;

public class CreateAlgorithmCommand
extends Command {
    private final BasicFBType fbType;
    private STAlgorithm newAlgorithm;
    private Algorithm oldAlgorithm;
    private ECAction action;

    public CreateAlgorithmCommand(BasicFBType fbType) {
        this.fbType = fbType;
    }

    public Algorithm getNewAlgorithm() {
        return this.newAlgorithm;
    }

    public CreateAlgorithmCommand(BasicFBType fbType, ECAction action) {
        this(fbType);
        this.action = action;
    }

    public void execute() {
        if (this.action != null) {
            this.oldAlgorithm = this.action.getAlgorithm();
        }
        this.newAlgorithm = LibraryElementFactory.eINSTANCE.createSTAlgorithm();
        this.newAlgorithm.setComment("new algorithm");
        this.newAlgorithm.setText("");
        this.redo();
        this.newAlgorithm.setName(NameRepository.createUniqueName((INamedElement)this.newAlgorithm, (String)"ALG"));
    }

    public void undo() {
        if (this.action != null) {
            this.action.setAlgorithm(this.oldAlgorithm);
        }
        this.fbType.getAlgorithm().remove((Object)this.newAlgorithm);
    }

    public void redo() {
        if (this.action != null) {
            this.action.setAlgorithm((Algorithm)this.newAlgorithm);
        }
        this.fbType.getAlgorithm().add((Object)this.newAlgorithm);
    }
}

