/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteECActionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteTransitionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DeleteECStateCommand
extends Command {
    private final ECState state;
    private final ECC parent;
    private CompoundCommand deleteActions;
    private CompoundCommand deleteInTransitions;
    private CompoundCommand deleteOutTransitions;

    public DeleteECStateCommand(ECState state) {
        this.state = state;
        this.parent = state.getECC();
    }

    public boolean canExecute() {
        return this.state != null && this.parent != null && this.parent.getStart() != this.state;
    }

    public void execute() {
        DeleteTransitionCommand cmd;
        this.deleteActions = new CompoundCommand();
        for (ECAction ecAction : this.state.getECAction()) {
            this.deleteActions.add((Command)new DeleteECActionCommand(ecAction));
        }
        if (this.deleteActions.canExecute()) {
            this.deleteActions.execute();
        }
        this.deleteInTransitions = new CompoundCommand();
        for (ECTransition transition : this.state.getInTransitions()) {
            cmd = new DeleteTransitionCommand(transition);
            this.deleteInTransitions.add((Command)cmd);
        }
        if (this.deleteInTransitions.canExecute()) {
            this.deleteInTransitions.execute();
        }
        this.deleteOutTransitions = new CompoundCommand();
        for (ECTransition transition : this.state.getOutTransitions()) {
            cmd = new DeleteTransitionCommand(transition);
            this.deleteOutTransitions.add((Command)cmd);
        }
        if (this.deleteOutTransitions.canExecute()) {
            this.deleteOutTransitions.execute();
        }
        if (this.parent != null) {
            if (this.state.isStartState()) {
                this.parent.setStart(null);
            }
            this.parent.getECState().remove((Object)this.state);
        }
    }

    public void undo() {
        if (this.parent != null) {
            if (this.parent.getStart() == null) {
                this.parent.setStart(this.state);
            }
            this.parent.getECState().add((Object)this.state);
        }
        this.deleteOutTransitions.undo();
        this.deleteInTransitions.undo();
        this.deleteActions.undo();
    }

    public void redo() {
        this.deleteOutTransitions.redo();
        this.deleteInTransitions.redo();
        this.deleteActions.redo();
        if (this.parent != null) {
            if (this.state.isStartState()) {
                this.parent.setStart(null);
            }
            this.parent.getECState().remove((Object)this.state);
        }
    }
}

