/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.navigator;

import java.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterfaceFBType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typemanagement.Activator;
import org.eclipse.fordiac.ide.typemanagement.navigator.FBTypeComposedAdapterFactory;
import org.eclipse.fordiac.ide.typemanagement.util.FBTypeUtils;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class FBTypeLabelProvider
extends AdapterFactoryLabelProvider
implements IDescriptionProvider {
    public FBTypeLabelProvider() {
        super((AdapterFactory)FBTypeComposedAdapterFactory.getAdapterFactory());
    }

    public Image getImage(Object element) {
        if (element instanceof IFile) {
            return FBTypeLabelProvider.getImageForFBFile((IFile)element);
        }
        return super.getImage(element);
    }

    private static Image getImageForFBFile(IFile element) {
        Palette palette;
        Image image = null;
        if ("ADP".equalsIgnoreCase(element.getFileExtension())) {
            image = FordiacImage.ICON_ADAPTER.getImage();
        } else if ("SUB".equalsIgnoreCase(element.getFileExtension())) {
            image = FordiacImage.ICON_SUB_APP.getImage();
        } else if ("FBT".equalsIgnoreCase(element.getFileExtension()) && (palette = FBTypeUtils.getPalletteForFBTypeFile(element)) != null) {
            PaletteEntry entry = TypeLibrary.getPaletteEntry((Palette)palette, (IFile)element);
            if (entry != null) {
                FBType type = ((FBTypePaletteEntry)entry).getFBType();
                if (type instanceof BasicFBType) {
                    image = FordiacImage.ICON_BASIC_FB.getImage();
                } else if (type instanceof CompositeFBType) {
                    image = FordiacImage.ICON_COMPOSITE_FB.getImage();
                } else if (type instanceof ServiceInterfaceFBType) {
                    image = FordiacImage.ICON_SIFB.getImage();
                }
            } else {
                image = FBTypeLabelProvider.checkUnloadedFBType(element);
            }
        }
        if (image != null && FBTypeLabelProvider.fileHasProblems(element)) {
            return FordiacImage.getErrorOverlayImage((Image)image);
        }
        return image;
    }

    private static boolean fileHasProblems(IFile element) {
        IMarker[] problems = null;
        try {
            problems = element.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        return problems != null && problems.length > 0;
    }

    private static Image checkUnloadedFBType(IFile element) {
        Image image;
        block9: {
            image = null;
            try (Scanner scanner = null;){
                try {
                    scanner = new Scanner(element.getContents());
                    if (scanner.findWithinHorizon("BasicFB", 0) != null) {
                        image = FordiacImage.ICON_BASIC_FB.getImage();
                        break block9;
                    }
                    scanner.reset();
                    if (scanner.findWithinHorizon("FBNetwork", 0) != null) {
                        image = FordiacImage.ICON_COMPOSITE_FB.getImage();
                        break block9;
                    }
                    image = FordiacImage.ICON_SIFB.getImage();
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                    if (scanner != null) {
                        scanner.close();
                    }
                }
            }
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof IFile) {
            return FBTypeLabelProvider.getTextForFBFile((IFile)element);
        }
        return super.getText(element);
    }

    private static String getTextForFBFile(IFile element) {
        String text = null;
        if ("ADP".equalsIgnoreCase(element.getFileExtension()) || "FBT".equalsIgnoreCase(element.getFileExtension()) || "SUB".equalsIgnoreCase(element.getFileExtension())) {
            text = TypeLibrary.getTypeNameFromFile((IFile)element);
        }
        return text;
    }

    public String getDescription(Object anElement) {
        if (anElement instanceof IFile) {
            return FBTypeLabelProvider.getDescriptionForFBFile((IFile)anElement);
        }
        return null;
    }

    private static String getDescriptionForFBFile(IFile fbtFile) {
        PaletteEntry entry;
        Palette palette;
        FBType type = null;
        if ("FBT".equalsIgnoreCase(fbtFile.getFileExtension())) {
            PaletteEntry entry2;
            Palette palette2 = FBTypeUtils.getPalletteForFBTypeFile(fbtFile);
            if (palette2 != null && (entry2 = TypeLibrary.getPaletteEntry((Palette)palette2, (IFile)fbtFile)) != null) {
                type = ((FBTypePaletteEntry)entry2).getFBType();
            }
        } else if ("ADP".equalsIgnoreCase(fbtFile.getFileExtension()) && (palette = FBTypeUtils.getPalletteForFBTypeFile(fbtFile)) != null && (entry = TypeLibrary.getPaletteEntry((Palette)palette, (IFile)fbtFile)) != null) {
            type = ((AdapterTypePaletteEntry)entry).getType().getAdapterFBType();
        }
        if (type != null) {
            return String.valueOf(type.getName()) + ": " + (type.getComment() == null ? "" : type.getComment());
        }
        return null;
    }
}

