/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.fbtypeeditor.DataTypeCreationFactory;
import org.eclipse.fordiac.ide.gef.preferences.PaletteFlyoutPreferences;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;

public final class FBInterfacePaletteFactory {
    public static final PaletteFlyoutPreferences PALETTE_PREFERENCES = new PaletteFlyoutPreferences("FBInterfacePaletteFactory.Location", "FBInterfacePaletteFactory.Size", "FBInterfacePaletteFactory.State");

    public static PaletteRoot createPalette(Palette systemPalette) {
        PaletteRoot palette = new PaletteRoot();
        FBInterfacePaletteFactory.fillPalette(systemPalette, palette);
        return palette;
    }

    private static void fillPalette(Palette systemPalette, PaletteRoot palette) {
        CombinedTemplateCreationEntry combined;
        ImageDescriptor desc;
        PaletteDrawer drawer = new PaletteDrawer("EventTypes");
        for (DataType type : EventTypeLibrary.getInstance().getEventTypes()) {
            desc = FordiacImage.ICON_DATA_TYPE.getImageDescriptor();
            combined = new CombinedTemplateCreationEntry(type.getName(), type.getComment(), (CreationFactory)new DataTypeCreationFactory(type), desc, desc);
            drawer.add((org.eclipse.gef.palette.PaletteEntry)combined);
        }
        palette.add((org.eclipse.gef.palette.PaletteEntry)drawer);
        drawer = new PaletteDrawer("DataTypes");
        for (DataType dataType : DataTypeLibrary.getInstance().getDataTypesSorted()) {
            desc = FordiacImage.ICON_DATA_TYPE.getImageDescriptor();
            combined = new CombinedTemplateCreationEntry(dataType.getName(), dataType.getComment(), (CreationFactory)new DataTypeCreationFactory(dataType), desc, desc);
            drawer.add((org.eclipse.gef.palette.PaletteEntry)combined);
        }
        palette.add((org.eclipse.gef.palette.PaletteEntry)drawer);
        FBInterfacePaletteFactory.fillPalette(palette, systemPalette);
    }

    private static void fillPalette(PaletteRoot palette, Palette systemPalette) {
        Palette pal = null;
        pal = systemPalette == null ? TypeLibrary.getInstance().getPalette() : systemPalette;
        PaletteDrawer drawer = FBInterfacePaletteFactory.createGroup(pal.getRootGroup(), "", palette);
        if (!drawer.getChildren().isEmpty()) {
            palette.add((org.eclipse.gef.palette.PaletteEntry)drawer);
        }
    }

    private static PaletteDrawer createGroup(PaletteGroup group, String parentGroup, PaletteRoot palette) {
        String newParent = "";
        if (!group.getLabel().equals("Root Group")) {
            newParent = String.valueOf(newParent) + (parentGroup.equals("") ? String.valueOf(parentGroup) + "." + group.getLabel() : group.getLabel());
        }
        for (PaletteGroup paletteGroup : group.getSubGroups()) {
            PaletteDrawer drawer = FBInterfacePaletteFactory.createGroup(paletteGroup, newParent, palette);
            if (drawer.getChildren().isEmpty()) continue;
            palette.add((org.eclipse.gef.palette.PaletteEntry)drawer);
        }
        PaletteDrawer paletteContainer = new PaletteDrawer(!parentGroup.equals("") ? String.valueOf(parentGroup) + "." + group.getLabel() : group.getLabel());
        paletteContainer.addAll(FBInterfacePaletteFactory.createAdapterEntries(group));
        return paletteContainer;
    }

    private static List<org.eclipse.gef.palette.PaletteEntry> createAdapterEntries(PaletteGroup group) {
        ArrayList<org.eclipse.gef.palette.PaletteEntry> entries = new ArrayList<org.eclipse.gef.palette.PaletteEntry>();
        for (PaletteEntry paletteEntry : group.getEntries()) {
            if (!(paletteEntry instanceof AdapterTypePaletteEntry)) continue;
            AdapterTypePaletteEntry entry = (AdapterTypePaletteEntry)paletteEntry;
            ImageDescriptor desc = FordiacImage.ICON_DATA_TYPE.getImageDescriptor();
            entries.add((org.eclipse.gef.palette.PaletteEntry)new CombinedTemplateCreationEntry(entry.getLabel(), entry.getType().getComment(), (CreationFactory)new DataTypeCreationFactory((DataType)entry.getType()), desc, desc));
        }
        return entries;
    }

    private FBInterfacePaletteFactory() {
        throw new UnsupportedOperationException("Class FBInterfacePaletteFactory should not be created!\n");
    }
}

