/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editparts;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.policies.DeleteInterfaceEditPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.policies.WithNodeEditPolicy;
import org.eclipse.fordiac.ide.gef.draw2d.ConnectorBorder;
import org.eclipse.fordiac.ide.gef.draw2d.UnderlineAlphaLabel;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.policies.INamedElementRenameEditPolicy;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class AdapterInterfaceEditPart
extends InterfaceEditPart {
    private Palette systemPalette;

    AdapterInterfaceEditPart(Palette systemPalette) {
        this.systemPalette = systemPalette;
    }

    @Override
    protected IFigure createFigure() {
        AdapterInterfaceFigure fig = new AdapterInterfaceFigure();
        fig.addAncestorListener(new AncestorListener(){

            public void ancestorRemoved(IFigure ancestor) {
            }

            public void ancestorMoved(IFigure ancestor) {
                AdapterInterfaceEditPart.this.update();
            }

            public void ancestorAdded(IFigure ancestor) {
                AdapterInterfaceEditPart.this.update();
            }
        });
        return fig;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new INamedElementRenameEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                if (this.getHost() instanceof AbstractDirectEditableEditPart) {
                    return new ChangeNameCommand((INamedElement)AdapterInterfaceEditPart.this.getCastedModel(), (String)request.getCellEditor().getValue());
                }
                return null;
            }
        });
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteInterfaceEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", new WithNodeEditPolicy());
    }

    public DragTracker getDragTracker(Request request) {
        PaletteEntry entry;
        SelectionRequest selRequest;
        if (request instanceof SelectionRequest && (selRequest = (SelectionRequest)request).getLastButtonPressed() == 1 && selRequest.isControlKeyPressed() && (entry = this.systemPalette.getTypeEntry(this.getAdapter().getType().getName())) != null) {
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(entry.getFile().getName());
            EditorUtils.openEditor((IEditorInput)new FileEditorInput(entry.getFile()), (String)desc.getId());
        }
        return super.getDragTracker(request);
    }

    public void refreshName() {
        ((AdapterInterfaceFigure)this.getFigure()).setText(this.getINamedElement().getName());
        super.refreshName();
    }

    private AdapterDeclaration getAdapter() {
        return (AdapterDeclaration)this.getCastedModel();
    }

    private class AdapterInterfaceFigure
    extends UnderlineAlphaLabel {
        public AdapterInterfaceFigure() {
            this.setOpaque(false);
            this.setBorder((Border)new ConnectorBorder(AdapterInterfaceEditPart.this.getCastedModel()));
            this.setText(AdapterInterfaceEditPart.this.getINamedElement().getName());
            if (AdapterInterfaceEditPart.this.isInput()) {
                this.setLabelAlignment(1);
                this.setTextAlignment(1);
            } else {
                this.setLabelAlignment(4);
                this.setTextAlignment(4);
            }
            this.setupMouseListener();
        }

        private void setupMouseListener() {
            this.addMouseMotionListener(new MouseMotionListener(){

                public void mouseDragged(MouseEvent me) {
                }

                public void mouseEntered(MouseEvent me) {
                    if ((me.getState() & 0x40000) != 0) {
                        AdapterInterfaceFigure.this.setDrawUnderline(true);
                    }
                }

                public void mouseExited(MouseEvent me) {
                    AdapterInterfaceFigure.this.setDrawUnderline(false);
                }

                public void mouseHover(MouseEvent me) {
                    this.mouseMoved(me);
                }

                public void mouseMoved(MouseEvent me) {
                    if ((me.getState() & 0x40000) != 0) {
                        if (!AdapterInterfaceFigure.this.isDrawUnderline()) {
                            AdapterInterfaceFigure.this.setDrawUnderline(true);
                        }
                    } else if (AdapterInterfaceFigure.this.isDrawUnderline()) {
                        AdapterInterfaceFigure.this.setDrawUnderline(false);
                    }
                }
            });
        }
    }
}

