/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.fbtester.configuration.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.MessageFormat;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.Activator;
import org.eclipse.fordiac.ide.fbtypeeditor.fbtester.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;

public final class Utils {
    private static final int ASN1_TAG_IECSTRING = 80;

    private Utils() {
    }

    public static String deployNetwork(FBType type, String ipAddress, int port) {
        int id = 0;
        try {
            Socket socket = new Socket(InetAddress.getByName(ipAddress), port);
            DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            DataInputStream inputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
            socket.setSoTimeout(10000);
            String request = MessageFormat.format(Messages.FBTester_CreateResourceInstance, id++, "_" + type.getName() + "_RES", "EMB_RES");
            Utils.sendREQ("", request, outputStream, inputStream);
            request = MessageFormat.format(Messages.FBTester_CreateFBInstance, id++, "_" + type.getName(), type.getName());
            Utils.sendREQ("_" + type.getName() + "_RES", request, outputStream, inputStream);
            request = MessageFormat.format(Messages.FBTester_Start, id++);
            Utils.sendREQ("_" + type.getName() + "_RES", request, outputStream, inputStream);
            socket.close();
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return e.getMessage();
        }
        return null;
    }

    public static String cleanNetwork(FBType type, String ipAddress, int port, Socket socket) {
        int id = 0;
        try {
            if (socket == null) {
                socket = new Socket(InetAddress.getByName(ipAddress), port);
            }
            if (!socket.isConnected()) {
                InetSocketAddress endpoint = new InetSocketAddress(InetAddress.getByName(ipAddress), port);
                socket.connect(endpoint);
            }
            DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            DataInputStream inputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
            socket.setSoTimeout(10000);
            String kill = MessageFormat.format(Messages.FBTester_KillFB, id++, "_" + type.getName() + "_RES");
            String delete = MessageFormat.format(Messages.FBTester_DeleteFB, id++, "_" + type.getName() + "_RES");
            Utils.sendREQ("", kill, outputStream, inputStream);
            Utils.sendREQ("", delete, outputStream, inputStream);
            socket.close();
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return e.getMessage();
        }
        return null;
    }

    public static synchronized String sendREQ(String destination, String request, DataOutputStream outputStream, DataInputStream inputStream) throws Exception {
        String output = "";
        if (outputStream != null && inputStream != null) {
            outputStream.writeByte(80);
            outputStream.writeShort(destination.length());
            outputStream.writeBytes(destination);
            outputStream.writeByte(80);
            outputStream.writeShort(request.length());
            outputStream.writeBytes(request);
            outputStream.flush();
            System.out.println(request);
            StringBuilder response = new StringBuilder();
            inputStream.readByte();
            int size = inputStream.readShort();
            int i = 0;
            while (i < size) {
                response.append((char)inputStream.readByte());
                ++i;
            }
            System.out.println(response);
            if (response.toString().contains("Reason")) {
                throw new Exception(response.toString());
            }
            output = response.toString();
        }
        return output;
    }
}

