/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class ResolverBundle
extends VersionSupplier
implements Comparable<ResolverBundle> {
    public static final int UNRESOLVED = 0;
    public static final int RESOLVING = 1;
    public static final int RESOLVED = 2;
    private final Long bundleID;
    private BundleConstraint host;
    private ResolverImport[] imports;
    private ResolverExport[] exports;
    private BundleConstraint[] requires;
    private GenericCapability[] genericCapabilities;
    private GenericConstraint[] genericReqiures;
    private ArrayList<ResolverBundle> fragments;
    private HashMap<Long, List<ResolverExport>> fragmentExports;
    private HashMap<Long, List<ResolverImport>> fragmentImports;
    private HashMap<Long, List<BundleConstraint>> fragmentRequires;
    private HashMap<Long, List<GenericCapability>> fragmentGenericCapabilities;
    private HashMap<Long, List<GenericConstraint>> fragmentGenericRequires;
    private boolean resolvable = true;
    private int state = 0;
    private boolean uninstalled = false;
    private final ResolverImpl resolver;
    private boolean newFragmentExports;
    private boolean newFragmentCapabilities;

    ResolverBundle(BundleDescription bundle, ResolverImpl resolver) {
        super((BaseDescription)bundle);
        this.bundleID = new Long(bundle.getBundleId());
        this.resolver = resolver;
        this.initialize(bundle.isResolved());
    }

    void initialize(boolean useSelectedExports) {
        if (this.getBundleDescription().getHost() != null) {
            GenericCapability[] genericCapabilityArray;
            this.host = new BundleConstraint(this, (VersionConstraint)this.getBundleDescription().getHost());
            this.exports = new ResolverExport[0];
            this.imports = new ResolverImport[0];
            this.requires = new BundleConstraint[0];
            GenericSpecification[] requirements = this.getBundleDescription().getGenericRequires();
            ArrayList<GenericConstraint> constraints = new ArrayList<GenericConstraint>();
            GenericSpecification[] genericSpecificationArray = requirements;
            int n = requirements.length;
            int n2 = 0;
            while (n2 < n) {
                GenericSpecification requirement = genericSpecificationArray[n2];
                if ("osgi.ee".equals(requirement.getType())) {
                    constraints.add(new GenericConstraint(this, requirement, this.resolver.isDevelopmentMode()));
                }
                ++n2;
            }
            this.genericReqiures = constraints.toArray(new GenericConstraint[constraints.size()]);
            GenericDescription[] capabilities = this.getBundleDescription().getGenericCapabilities();
            GenericCapability identity = null;
            GenericDescription[] genericDescriptionArray = capabilities;
            int n3 = capabilities.length;
            int n4 = 0;
            while (n4 < n3) {
                GenericDescription capability = genericDescriptionArray[n4];
                if ("osgi.identity".equals(capability.getType())) {
                    identity = new GenericCapability(this, capability, this.resolver.isDevelopmentMode());
                    break;
                }
                ++n4;
            }
            if (identity == null) {
                genericCapabilityArray = new GenericCapability[]{};
            } else {
                GenericCapability[] genericCapabilityArray2 = new GenericCapability[1];
                genericCapabilityArray = genericCapabilityArray2;
                genericCapabilityArray2[0] = identity;
            }
            this.genericCapabilities = genericCapabilityArray;
            return;
        }
        ImportPackageSpecification[] actualImports = this.getBundleDescription().getImportPackages();
        ArrayList<ResolverImport> importList = new ArrayList<ResolverImport>(actualImports.length);
        int i = actualImports.length - 1;
        while (i >= 0) {
            if ("optional".equals(actualImports[i].getDirective("resolution"))) {
                importList.add(new ResolverImport(this, actualImports[i]));
            } else {
                importList.add(0, new ResolverImport(this, actualImports[i]));
            }
            --i;
        }
        this.imports = importList.toArray(new ResolverImport[importList.size()]);
        ExportPackageDescription[] actualExports = useSelectedExports ? this.getBundleDescription().getSelectedExports() : this.getBundleDescription().getExportPackages();
        this.exports = new ResolverExport[actualExports.length];
        int i2 = 0;
        while (i2 < actualExports.length) {
            this.exports[i2] = new ResolverExport(this, actualExports[i2]);
            ++i2;
        }
        BundleSpecification[] actualRequires = this.getBundleDescription().getRequiredBundles();
        this.requires = new BundleConstraint[actualRequires.length];
        int i3 = 0;
        while (i3 < this.requires.length) {
            this.requires[i3] = new BundleConstraint(this, (VersionConstraint)actualRequires[i3]);
            ++i3;
        }
        GenericSpecification[] actualGenericRequires = this.getBundleDescription().getGenericRequires();
        this.genericReqiures = new GenericConstraint[actualGenericRequires.length];
        int i4 = 0;
        while (i4 < this.genericReqiures.length) {
            this.genericReqiures[i4] = new GenericConstraint(this, actualGenericRequires[i4], this.resolver.isDevelopmentMode());
            ++i4;
        }
        GenericDescription[] actualCapabilities = useSelectedExports ? this.getBundleDescription().getSelectedGenericCapabilities() : this.getBundleDescription().getGenericCapabilities();
        this.genericCapabilities = new GenericCapability[actualCapabilities.length];
        int i5 = 0;
        while (i5 < this.genericCapabilities.length) {
            this.genericCapabilities[i5] = new GenericCapability(this, actualCapabilities[i5], this.resolver.isDevelopmentMode());
            ++i5;
        }
        this.fragments = null;
        this.fragmentExports = null;
        this.fragmentImports = null;
        this.fragmentRequires = null;
        this.fragmentGenericCapabilities = null;
        this.fragmentGenericRequires = null;
    }

    ResolverExport getExport(String name) {
        ResolverExport[] allExports = this.getExports(name);
        return allExports.length == 0 ? null : allExports[0];
    }

    ResolverExport[] getExports(String name) {
        ArrayList<ResolverExport> results = new ArrayList<ResolverExport>(1);
        List resolverExports = this.resolver.getResolverExports().get(name);
        for (ResolverExport export : resolverExports) {
            if (export.getExporter() != this) continue;
            results.add(export);
        }
        return results.toArray(new ResolverExport[results.size()]);
    }

    void clearWires() {
        ResolverExport[] allExports;
        GenericConstraint[] allGenericRequires;
        BundleConstraint[] allRequires;
        ResolverImport[] allImports;
        ResolverImport[] resolverImportArray = allImports = this.getImportPackages();
        int n = allImports.length;
        int n2 = 0;
        while (n2 < n) {
            ResolverImport allImport = resolverImportArray[n2];
            allImport.clearPossibleSuppliers();
            ++n2;
        }
        if (this.host != null) {
            this.host.clearPossibleSuppliers();
        }
        BundleConstraint[] bundleConstraintArray = allRequires = this.getRequires();
        int n3 = allRequires.length;
        n = 0;
        while (n < n3) {
            BundleConstraint allRequire = bundleConstraintArray[n];
            allRequire.clearPossibleSuppliers();
            ++n;
        }
        GenericConstraint[] genericConstraintArray = allGenericRequires = this.getGenericRequires();
        int n4 = allGenericRequires.length;
        n3 = 0;
        while (n3 < n4) {
            GenericConstraint allGenericRequire = genericConstraintArray[n3];
            allGenericRequire.clearPossibleSuppliers();
            ++n3;
        }
        ResolverExport[] resolverExportArray = allExports = this.getExportPackages();
        int n5 = allExports.length;
        n4 = 0;
        while (n4 < n5) {
            ResolverExport allExport = resolverExportArray[n4];
            allExport.setSubstitute(null);
            ++n4;
        }
    }

    boolean isResolved() {
        return this.getState() == 2;
    }

    boolean isFragment() {
        return this.host != null;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    private <T> List<T> getAll(T[] hostEntries, Map<Long, List<T>> fragmentMap) {
        ArrayList<T> result = new ArrayList<T>(hostEntries.length);
        Collections.addAll(result, hostEntries);
        for (ResolverBundle fragment : this.fragments) {
            List<T> fragEntries = fragmentMap.get(fragment.bundleID);
            if (fragEntries == null) continue;
            result.addAll(fragEntries);
        }
        return result;
    }

    ResolverImport[] getImportPackages() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.imports;
        }
        List<ResolverImport> result = this.getAll(this.imports, this.fragmentImports);
        return result.toArray(new ResolverImport[result.size()]);
    }

    ResolverExport[] getExportPackages() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.exports;
        }
        List<ResolverExport> result = this.getAll(this.exports, this.fragmentExports);
        return result.toArray(new ResolverExport[result.size()]);
    }

    ResolverExport[] getSelectedExports() {
        return this.getExports(true);
    }

    ResolverExport[] getSubstitutedExports() {
        return this.getExports(false);
    }

    private ResolverExport[] getExports(boolean selected) {
        ResolverExport[] results = this.getExportPackages();
        int removedExports = 0;
        ResolverExport[] resolverExportArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            ResolverExport result = resolverExportArray[n2];
            if (selected ? result.getSubstitute() != null : result.getSubstitute() == null) {
                ++removedExports;
            }
            ++n2;
        }
        if (removedExports == 0) {
            return results;
        }
        ResolverExport[] selectedExports = new ResolverExport[results.length - removedExports];
        int index = 0;
        ResolverExport[] resolverExportArray2 = results;
        int n3 = results.length;
        int n4 = 0;
        while (n4 < n3) {
            ResolverExport result = resolverExportArray2[n4];
            if (!(selected ? result.getSubstitute() != null : result.getSubstitute() == null)) {
                selectedExports[index] = result;
                ++index;
            }
            ++n4;
        }
        return selectedExports;
    }

    BundleConstraint getHost() {
        return this.host;
    }

    GenericCapability[] getGenericCapabilities() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.genericCapabilities;
        }
        List<GenericCapability> result = this.getAll(this.genericCapabilities, this.fragmentGenericCapabilities);
        return result.toArray(new GenericCapability[result.size()]);
    }

    BundleConstraint[] getRequires() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.requires;
        }
        List<BundleConstraint> result = this.getAll(this.requires, this.fragmentRequires);
        return result.toArray(new BundleConstraint[result.size()]);
    }

    GenericConstraint[] getGenericRequires() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.genericReqiures;
        }
        List<GenericConstraint> result = this.getAll(this.genericReqiures, this.fragmentGenericRequires);
        return result.toArray(new GenericConstraint[result.size()]);
    }

    BundleConstraint getRequire(String name) {
        BundleConstraint[] allRequires;
        BundleConstraint[] bundleConstraintArray = allRequires = this.getRequires();
        int n = allRequires.length;
        int n2 = 0;
        while (n2 < n) {
            BundleConstraint allRequire = bundleConstraintArray[n2];
            if (allRequire.getVersionConstraint().getName().equals(name)) {
                return allRequire;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public BundleDescription getBundleDescription() {
        return (BundleDescription)this.getBaseDescription();
    }

    @Override
    public ResolverBundle getResolverBundle() {
        return this;
    }

    ResolverImport getImport(String name) {
        ResolverImport[] allImports;
        ResolverImport[] resolverImportArray = allImports = this.getImportPackages();
        int n = allImports.length;
        int n2 = 0;
        while (n2 < n) {
            ResolverImport allImport = resolverImportArray[n2];
            if (allImport.getName().equals(name)) {
                return allImport;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String toString() {
        return "[" + this.getBundleDescription() + "]";
    }

    private void initFragments() {
        if (this.fragments == null) {
            this.fragments = new ArrayList(1);
        }
        if (this.fragmentExports == null) {
            this.fragmentExports = new HashMap(1);
        }
        if (this.fragmentImports == null) {
            this.fragmentImports = new HashMap(1);
        }
        if (this.fragmentRequires == null) {
            this.fragmentRequires = new HashMap(1);
        }
        if (this.fragmentGenericCapabilities == null) {
            this.fragmentGenericCapabilities = new HashMap(1);
        }
        if (this.fragmentGenericRequires == null) {
            this.fragmentGenericRequires = new HashMap(1);
        }
    }

    private boolean isImported(String packageName) {
        ResolverImport[] allImports;
        ResolverImport[] resolverImportArray = allImports = this.getImportPackages();
        int n = allImports.length;
        int n2 = 0;
        while (n2 < n) {
            ResolverImport allImport = resolverImportArray[n2];
            if (packageName.equals(allImport.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isRequired(String bundleName) {
        return this.getRequire(bundleName) != null;
    }

    void attachFragment(ResolverBundle fragment, boolean dynamicAttach) {
        int n;
        ImportPackageSpecification[] importPackageSpecificationArray;
        if (this.isFragment()) {
            return;
        }
        if (!this.getBundleDescription().attachFragments() || this.isResolved() && !this.getBundleDescription().dynamicFragments()) {
            return;
        }
        if (fragment.getHost().getNumPossibleSuppliers() > 0 && !((HostSpecification)fragment.getHost().getVersionConstraint()).isMultiHost()) {
            return;
        }
        ImportPackageSpecification[] newImports = fragment.getBundleDescription().getImportPackages();
        BundleSpecification[] newRequires = fragment.getBundleDescription().getRequiredBundles();
        ExportPackageDescription[] newExports = fragment.getBundleDescription().getExportPackages();
        GenericDescription[] newGenericCapabilities = fragment.getBundleDescription().getGenericCapabilities();
        GenericSpecification[] newGenericRequires = fragment.getBundleDescription().getGenericRequires();
        if (dynamicAttach && this.constraintsConflict(fragment.getBundleDescription(), newImports, newRequires, newGenericRequires)) {
            return;
        }
        if (this.isResolved() && newExports.length > 0) {
            fragment.setNewFragmentExports(true);
        }
        this.initFragments();
        for (ResolverBundle existingFragment : this.fragments) {
            String bsn = existingFragment.getName();
            if (bsn == null || !bsn.equals(fragment.getName())) continue;
            return;
        }
        if (this.fragments.contains(fragment)) {
            return;
        }
        this.fragments.add(fragment);
        fragment.getHost().addPossibleSupplier(this);
        if (newImports.length > 0) {
            ArrayList<ResolverImport> hostImports = new ArrayList<ResolverImport>(newImports.length);
            importPackageSpecificationArray = newImports;
            n = newImports.length;
            int bsn = 0;
            while (bsn < n) {
                ImportPackageSpecification newImport = importPackageSpecificationArray[bsn];
                if (!this.isImported(newImport.getName())) {
                    hostImports.add(new ResolverImport(this, newImport));
                }
                ++bsn;
            }
            this.fragmentImports.put(fragment.bundleID, hostImports);
        }
        if (newRequires.length > 0) {
            ArrayList<BundleConstraint> hostRequires = new ArrayList<BundleConstraint>(newRequires.length);
            importPackageSpecificationArray = newRequires;
            n = newRequires.length;
            int bsn = 0;
            while (bsn < n) {
                ImportPackageSpecification newRequire = importPackageSpecificationArray[bsn];
                if (!this.isRequired(newRequire.getName())) {
                    hostRequires.add(new BundleConstraint(this, (VersionConstraint)newRequire));
                }
                ++bsn;
            }
            this.fragmentRequires.put(fragment.bundleID, hostRequires);
        }
        if (newGenericRequires.length > 0) {
            ArrayList<GenericConstraint> hostGenericRequires = new ArrayList<GenericConstraint>(newGenericRequires.length);
            importPackageSpecificationArray = newGenericRequires;
            n = newGenericRequires.length;
            int bsn = 0;
            while (bsn < n) {
                ImportPackageSpecification newGenericRequire = importPackageSpecificationArray[bsn];
                if (!"osgi.ee".equals(newGenericRequire.getType())) {
                    hostGenericRequires.add(new GenericConstraint(this, (GenericSpecification)newGenericRequire, this.resolver.isDevelopmentMode()));
                }
                ++bsn;
            }
            if (!hostGenericRequires.isEmpty()) {
                this.fragmentGenericRequires.put(fragment.bundleID, hostGenericRequires);
            }
        }
        ArrayList<ResolverExport> hostExports = new ArrayList<ResolverExport>(newExports.length);
        if (newExports.length > 0 && dynamicAttach) {
            importPackageSpecificationArray = newExports;
            n = newExports.length;
            int bsn = 0;
            while (bsn < n) {
                ImportPackageSpecification newExport = importPackageSpecificationArray[bsn];
                ResolverExport[] currentExports = this.getExports(newExport.getName());
                boolean foundEquivalent = false;
                int j = 0;
                while (j < currentExports.length && !foundEquivalent) {
                    if (this.equivalentExports(currentExports[j], (ExportPackageDescription)newExport)) {
                        foundEquivalent = true;
                    }
                    ++j;
                }
                if (!foundEquivalent) {
                    ExportPackageDescriptionImpl hostExport = new ExportPackageDescriptionImpl(this.getBundleDescription(), (ExportPackageDescription)newExport);
                    hostExports.add(new ResolverExport(this, hostExport));
                }
                ++bsn;
            }
            this.fragmentExports.put(fragment.bundleID, hostExports);
        }
        ArrayList<GenericCapability> hostCapabilities = new ArrayList<GenericCapability>(newGenericCapabilities.length);
        if (newGenericCapabilities.length > 0 && dynamicAttach) {
            GenericDescription[] genericDescriptionArray = newGenericCapabilities;
            int n2 = newGenericCapabilities.length;
            n = 0;
            while (n < n2) {
                GenericDescription capability = genericDescriptionArray[n];
                if (!"osgi.identity".equals(capability.getType())) {
                    GenericDescriptionImpl hostCapabililty = new GenericDescriptionImpl(this.getBundleDescription(), capability);
                    hostCapabilities.add(new GenericCapability(this, hostCapabililty, this.resolver.isDevelopmentMode()));
                }
                ++n;
            }
            if (hostCapabilities.size() > 0) {
                this.fragmentGenericCapabilities.put(fragment.bundleID, hostCapabilities);
                if (this.isResolved()) {
                    fragment.setNewFragmentCapabilities(true);
                }
            }
        }
        if (dynamicAttach) {
            this.resolver.getResolverExports().put(hostExports.toArray(new ResolverExport[hostExports.size()]));
            this.resolver.addGenerics(hostCapabilities.toArray(new GenericCapability[hostCapabilities.size()]));
        }
    }

    private boolean equivalentExports(ResolverExport existingExport, ExportPackageDescription newDescription) {
        ExportPackageDescription existingDescription = existingExport.getExportPackageDescription();
        if (!existingDescription.getName().equals(newDescription.getName())) {
            return false;
        }
        if (!existingDescription.getVersion().equals((Object)newDescription.getVersion())) {
            return false;
        }
        if (!ResolverBundle.equivalentMaps(existingDescription.getAttributes(), newDescription.getAttributes(), true)) {
            return false;
        }
        return ResolverBundle.equivalentMaps(existingDescription.getDirectives(), newDescription.getDirectives(), true);
    }

    public static boolean equivalentMaps(Map<String, Object> existingDirectives, Map<String, Object> newDirectives, boolean exactMatch) {
        if (existingDirectives == null && newDirectives == null) {
            return true;
        }
        if (existingDirectives == null ? newDirectives != null : newDirectives == null) {
            return false;
        }
        if (exactMatch && existingDirectives.size() != newDirectives.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : existingDirectives.entrySet()) {
            Object newValue = newDirectives.get(entry.getKey());
            if (newValue == null || entry.getValue().getClass() != newValue.getClass()) {
                return false;
            }
            if (!(newValue instanceof String[] ? !Arrays.equals((Object[])entry.getValue(), (Object[])newValue) : !entry.getValue().equals(newValue))) continue;
            return false;
        }
        return true;
    }

    boolean constraintsConflict(BundleDescription fragment, ImportPackageSpecification[] newImports, BundleSpecification[] newRequires, GenericSpecification[] newGenericRequires) {
        boolean result = false;
        ImportPackageSpecification[] importPackageSpecificationArray = newImports;
        int n = newImports.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification newImport = importPackageSpecificationArray[n2];
            ResolverImport hostImport = this.getImport(newImport.getName());
            ResolverExport resolvedExport = (ResolverExport)(hostImport == null ? null : hostImport.getSelectedSupplier());
            if (this.importPackageConflict(resolvedExport, newImport)) {
                result = true;
                this.resolver.getState().addResolverError(fragment, 16, newImport.toString(), (VersionConstraint)newImport);
            }
            ++n2;
        }
        importPackageSpecificationArray = newRequires;
        n = newRequires.length;
        n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification newRequire = importPackageSpecificationArray[n2];
            BundleConstraint hostRequire = this.getRequire(newRequire.getName());
            ResolverBundle resolvedRequire = (ResolverBundle)(hostRequire == null ? null : hostRequire.getSelectedSupplier());
            if (resolvedRequire == null && this.isResolved() || resolvedRequire != null && !newRequire.isSatisfiedBy((BaseDescription)resolvedRequire.getBundleDescription())) {
                result = true;
                this.resolver.getState().addResolverError(fragment, 16, newRequire.toString(), (VersionConstraint)newRequire);
            }
            ++n2;
        }
        if (this.isResolved() && newGenericRequires != null) {
            importPackageSpecificationArray = newGenericRequires;
            n = newGenericRequires.length;
            n2 = 0;
            while (n2 < n) {
                ImportPackageSpecification genericSpecification = importPackageSpecificationArray[n2];
                if (!"osgi.ee".equals(genericSpecification.getType())) {
                    result = true;
                    this.resolver.getState().addResolverError(fragment, 16, genericSpecification.toString(), (VersionConstraint)genericSpecification);
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean importPackageConflict(ResolverExport resolvedExport, ImportPackageSpecification newImport) {
        if (resolvedExport == null) {
            return this.isResolved();
        }
        return !((ImportPackageSpecificationImpl)newImport).isSatisfiedBy((BaseDescription)resolvedExport.getExportPackageDescription(), false);
    }

    private void setNewFragmentExports(boolean newFragmentExports) {
        this.newFragmentExports = newFragmentExports;
    }

    boolean isNewFragmentExports() {
        return this.newFragmentExports;
    }

    private void setNewFragmentCapabilities(boolean newFragmentCapabilities) {
        this.newFragmentCapabilities = newFragmentCapabilities;
    }

    boolean isNewFragmentCapabilities() {
        return this.newFragmentCapabilities;
    }

    public void detachFromHosts() {
        if (!this.isFragment()) {
            return;
        }
        VersionSupplier[] hosts = this.getHost().getPossibleSuppliers();
        if (hosts == null) {
            return;
        }
        VersionSupplier[] versionSupplierArray = hosts;
        int n = hosts.length;
        int n2 = 0;
        while (n2 < n) {
            VersionSupplier possibleHost = versionSupplierArray[n2];
            ((ResolverBundle)possibleHost).detachFragment(this, null);
            ++n2;
        }
    }

    void detachFragment(ResolverBundle fragment, ResolverConstraint reason) {
        int n;
        int n2;
        VersionSupplier[] versionSupplierArray;
        if (this.isFragment()) {
            return;
        }
        this.initFragments();
        ResolverImport[] oldImports = this.getImportPackages();
        BundleConstraint[] oldRequires = this.getRequires();
        if (!this.fragments.remove(fragment)) {
            return;
        }
        fragment.setNewFragmentExports(false);
        fragment.setNewFragmentCapabilities(false);
        fragment.getHost().removePossibleSupplier(this);
        this.fragmentImports.remove(fragment.bundleID);
        this.fragmentRequires.remove(fragment.bundleID);
        List<ResolverExport> removedExports = this.fragmentExports.remove(fragment.bundleID);
        this.fragmentGenericRequires.remove(fragment.bundleID);
        List<GenericCapability> removedCapabilities = this.fragmentGenericCapabilities.remove(fragment.bundleID);
        if (reason != null) {
            ResolverBundle[] remainingFrags = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
            versionSupplierArray = remainingFrags;
            n2 = remainingFrags.length;
            n = 0;
            while (n < n2) {
                VersionSupplier remainingFrag = versionSupplierArray[n];
                ArrayList<ResolverImport> additionalImports = new ArrayList<ResolverImport>(0);
                ArrayList<BundleConstraint> additionalRequires = new ArrayList<BundleConstraint>(0);
                if (!this.hasUnresolvedConstraint(reason, fragment, (ResolverBundle)remainingFrag, oldImports, oldRequires, additionalImports, additionalRequires)) {
                    if (additionalImports.size() > 0) {
                        List<ResolverImport> remainingImports = this.fragmentImports.get(((ResolverBundle)remainingFrag).bundleID);
                        if (remainingImports == null) {
                            this.fragmentImports.put(((ResolverBundle)remainingFrag).bundleID, additionalImports);
                        } else {
                            remainingImports.addAll(additionalImports);
                        }
                    }
                    if (additionalRequires.size() > 0) {
                        List<BundleConstraint> remainingRequires = this.fragmentRequires.get(((ResolverBundle)remainingFrag).bundleID);
                        if (remainingRequires == null) {
                            this.fragmentRequires.put(((ResolverBundle)remainingFrag).bundleID, additionalRequires);
                        } else {
                            remainingRequires.addAll(additionalRequires);
                        }
                    }
                }
                ++n;
            }
        }
        ResolverExport[] results = removedExports == null ? new ResolverExport[]{} : removedExports.toArray(new ResolverExport[removedExports.size()]);
        versionSupplierArray = results;
        n2 = results.length;
        n = 0;
        while (n < n2) {
            VersionSupplier result = versionSupplierArray[n];
            result.setSubstitute(result);
            ++n;
        }
        this.resolver.getResolverExports().remove((ResolverExport)results);
        if (removedCapabilities != null) {
            this.resolver.removeGenerics(removedCapabilities.toArray(new GenericCapability[removedCapabilities.size()]));
        }
    }

    private boolean hasUnresolvedConstraint(ResolverConstraint reason, ResolverBundle detachedFragment, ResolverBundle remainingFragment, ResolverImport[] oldImports, BundleConstraint[] oldRequires, List<ResolverImport> additionalImports, List<BundleConstraint> additionalRequires) {
        int n;
        int n2;
        ImportPackageSpecification[] importPackageSpecificationArray;
        ImportPackageSpecification[] remainingFragImports = remainingFragment.getBundleDescription().getImportPackages();
        BundleSpecification[] remainingFragRequires = remainingFragment.getBundleDescription().getRequiredBundles();
        Object[] constraints = reason instanceof ResolverImport ? remainingFragImports : remainingFragRequires;
        Object[] objectArray = constraints;
        int n3 = constraints.length;
        int n4 = 0;
        while (n4 < n3) {
            ImportPackageSpecification constraint = objectArray[n4];
            if (reason.getName().equals(constraint.getName())) {
                this.detachFragment(remainingFragment, reason);
                return true;
            }
            ++n4;
        }
        objectArray = oldImports;
        n3 = oldImports.length;
        n4 = 0;
        while (n4 < n3) {
            ImportPackageSpecification oldImport = objectArray[n4];
            if (oldImport.getVersionConstraint().getBundle() == detachedFragment.getBundleDescription()) {
                importPackageSpecificationArray = remainingFragImports;
                n2 = remainingFragImports.length;
                n = 0;
                while (n < n2) {
                    ImportPackageSpecification remainingFragImport = importPackageSpecificationArray[n];
                    if (oldImport.getName().equals(remainingFragImport.getName())) {
                        additionalImports.add((ResolverImport)oldImport);
                        oldImport.setVersionConstraint((VersionConstraint)remainingFragImport);
                        break;
                    }
                    ++n;
                }
            }
            ++n4;
        }
        objectArray = oldRequires;
        n3 = oldRequires.length;
        n4 = 0;
        while (n4 < n3) {
            ImportPackageSpecification oldRequire = objectArray[n4];
            if (oldRequire.getVersionConstraint().getBundle() == detachedFragment.getBundleDescription()) {
                importPackageSpecificationArray = remainingFragRequires;
                n2 = remainingFragRequires.length;
                n = 0;
                while (n < n2) {
                    ImportPackageSpecification remainingFragRequire = importPackageSpecificationArray[n];
                    if (oldRequire.getName().equals(remainingFragRequire.getName())) {
                        additionalRequires.add((BundleConstraint)oldRequire);
                        oldRequire.setVersionConstraint((VersionConstraint)remainingFragRequire);
                        break;
                    }
                    ++n;
                }
            }
            ++n4;
        }
        return false;
    }

    void detachAllFragments() {
        ResolverBundle[] allFragments;
        if (this.fragments == null) {
            return;
        }
        ResolverBundle[] resolverBundleArray = allFragments = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
        int n = allFragments.length;
        int n2 = 0;
        while (n2 < n) {
            ResolverBundle allFragment = resolverBundleArray[n2];
            this.detachFragment(allFragment, null);
            ++n2;
        }
        this.fragments = null;
    }

    boolean isResolvable() {
        return this.resolvable;
    }

    void setResolvable(boolean resolvable) {
        this.resolvable = resolvable;
    }

    void addExport(ResolverExport re) {
        ResolverExport[] newExports = new ResolverExport[this.exports.length + 1];
        int i = 0;
        while (i < this.exports.length) {
            newExports[i] = this.exports[i];
            ++i;
        }
        newExports[this.exports.length] = re;
        this.exports = newExports;
    }

    ResolverImpl getResolver() {
        return this.resolver;
    }

    ResolverBundle[] getFragments() {
        return this.fragments == null ? new ResolverBundle[]{} : this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
    }

    @Override
    public int compareTo(ResolverBundle o) {
        String bsn = this.getName();
        String otherBsn = o.getName();
        if (bsn == null) {
            return otherBsn == null ? 0 : 1;
        }
        return otherBsn == null ? -1 : bsn.compareTo(otherBsn);
    }

    void setUninstalled() {
        this.uninstalled = true;
    }

    boolean isUninstalled() {
        return this.uninstalled;
    }
}

