/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class UpdateFBTypeCommand
extends Command {
    private FBNetworkElement fbnElement;
    private FBNetworkElement updatedElement;
    private PaletteEntry entry;
    private FBNetwork network;
    private CompoundCommand deleteConnCmds = new CompoundCommand();
    private CompoundCommand connCreateCmds = new CompoundCommand();
    private CompoundCommand resourceConnCreateCmds = new CompoundCommand();
    private MapToCommand mapCmd = null;
    private UnmapCommand unmapCmd = null;

    public UpdateFBTypeCommand(FBNetworkElement fbnElement, PaletteEntry entry) {
        this.fbnElement = fbnElement;
        this.network = (FBNetwork)fbnElement.eContainer();
        if (entry instanceof FBTypePaletteEntry || entry instanceof SubApplicationTypePaletteEntry) {
            this.entry = entry;
        }
    }

    public boolean canExecute() {
        return this.fbnElement.getType() != null;
    }

    public void execute() {
        Resource resource = null;
        List<ConnData> resourceConns = null;
        if (this.fbnElement.isMapped()) {
            if (this.network.equals(this.fbnElement.getResource().getFBNetwork())) {
                this.fbnElement = this.fbnElement.getOpposite();
                this.network = this.fbnElement.getFbNetwork();
            }
            resource = this.fbnElement.getResource();
            resourceConns = this.getResourceCons();
            this.unmapCmd = new UnmapCommand(this.fbnElement);
            this.unmapCmd.execute();
        }
        this.copyFB();
        this.handleApplicationConnections();
        this.updatedElement.setName(this.fbnElement.getName());
        if (resource != null) {
            this.mapCmd = new MapToCommand(this.updatedElement, resource);
            if (this.mapCmd.canExecute()) {
                this.mapCmd.execute();
                this.recreateResourceConns(resourceConns);
            }
        }
    }

    public void redo() {
        if (this.unmapCmd != null) {
            this.unmapCmd.redo();
        }
        this.deleteConnCmds.redo();
        this.replaceFBs(this.fbnElement, this.updatedElement);
        this.connCreateCmds.redo();
        if (this.mapCmd != null) {
            this.mapCmd.redo();
            this.resourceConnCreateCmds.redo();
        }
    }

    public void undo() {
        if (this.mapCmd != null) {
            this.resourceConnCreateCmds.undo();
            this.mapCmd.undo();
        }
        this.connCreateCmds.undo();
        this.replaceFBs(this.updatedElement, this.fbnElement);
        this.deleteConnCmds.undo();
        if (this.unmapCmd != null) {
            this.unmapCmd.undo();
        }
    }

    protected void setEntry(PaletteEntry entry) {
        this.entry = entry;
    }

    protected PaletteEntry getEntry() {
        return this.entry;
    }

    private void handleApplicationConnections() {
        for (Connection conn : UpdateFBTypeCommand.getAllConnections(this.fbnElement)) {
            this.doReconnect(conn, UpdateFBTypeCommand.findUpdatedInterfaceElement(this.updatedElement, this.fbnElement, conn.getSource()), UpdateFBTypeCommand.findUpdatedInterfaceElement(this.updatedElement, this.fbnElement, conn.getDestination()));
        }
    }

    private static List<Connection> getAllConnections(FBNetworkElement element) {
        ArrayList<Connection> retVal = new ArrayList<Connection>();
        for (IInterfaceElement ifEle : element.getInterface().getAllInterfaceElements()) {
            if (ifEle.isIsInput()) {
                retVal.addAll((Collection<Connection>)ifEle.getInputConnections());
                continue;
            }
            retVal.addAll((Collection<Connection>)ifEle.getOutputConnections());
        }
        return retVal;
    }

    private static IInterfaceElement findUpdatedInterfaceElement(FBNetworkElement copiedElement, FBNetworkElement orgElement, IInterfaceElement orig) {
        if (orig == null) {
            return null;
        }
        IInterfaceElement retval = orig;
        if (orig.getFBNetworkElement() == orgElement) {
            retval = copiedElement.getInterfaceElement(orig.getName());
        }
        return retval;
    }

    private void doReconnect(Connection oldConn, IInterfaceElement source, IInterfaceElement dest) {
        if (!this.isInDeleteConnList(oldConn)) {
            AbstractConnectionCreateCommand dccc;
            FBNetwork fbn = oldConn.getFBNetwork();
            DeleteConnectionCommand cmd = new DeleteConnectionCommand(oldConn);
            cmd.execute();
            this.deleteConnCmds.add((Command)cmd);
            if (source != null && dest != null && (dccc = UpdateFBTypeCommand.createConnCreateCMD(source, fbn)) != null) {
                dccc.setSource(source);
                dccc.setDestination(dest);
                if (dccc.canExecute()) {
                    dccc.setArrangementConstraints(oldConn.getDx1(), oldConn.getDx2(), oldConn.getDy());
                    dccc.execute();
                    this.connCreateCmds.add((Command)dccc);
                }
            }
        }
    }

    private static AbstractConnectionCreateCommand createConnCreateCMD(IInterfaceElement refIE, FBNetwork fbn) {
        AbstractConnectionCreateCommand retVal = null;
        if (refIE instanceof Event) {
            retVal = new EventConnectionCreateCommand(fbn);
        } else if (refIE instanceof AdapterDeclaration) {
            retVal = new AdapterConnectionCreateCommand(fbn);
        } else if (refIE instanceof VarDeclaration) {
            retVal = new DataConnectionCreateCommand(fbn);
        }
        return retVal;
    }

    private boolean isInDeleteConnList(Connection conn) {
        for (Object cmd : this.deleteConnCmds.getCommands()) {
            if (!((DeleteConnectionCommand)((Object)cmd)).getConnectionView().equals(conn)) continue;
            return true;
        }
        return false;
    }

    private void replaceFBs(FBNetworkElement oldElement, FBNetworkElement newElement) {
        this.network.getNetworkElements().remove((Object)oldElement);
        this.network.getNetworkElements().add((Object)newElement);
    }

    private void copyFB() {
        this.updatedElement = this.createCopiedFBEntry(this.fbnElement);
        this.updatedElement.setInterface((InterfaceList)EcoreUtil.copy((EObject)this.updatedElement.getType().getInterfaceList()));
        this.updatedElement.setName(this.fbnElement.getName());
        this.updatedElement.setX(this.fbnElement.getX());
        this.updatedElement.setY(this.fbnElement.getY());
        this.createValues();
        this.replaceFBs(this.fbnElement, this.updatedElement);
    }

    protected FBNetworkElement createCopiedFBEntry(FBNetworkElement srcElement) {
        Object copy = null;
        if (this.entry == null) {
            copy = srcElement instanceof SubApp ? LibraryElementFactory.eINSTANCE.createSubApp() : LibraryElementFactory.eINSTANCE.createFB();
            copy.setPaletteEntry(srcElement.getPaletteEntry());
        } else {
            copy = this.entry instanceof SubApplicationTypePaletteEntry ? LibraryElementFactory.eINSTANCE.createSubApp() : LibraryElementFactory.eINSTANCE.createFB();
            copy.setPaletteEntry(this.entry);
        }
        return copy;
    }

    private void createValues() {
        for (VarDeclaration var : this.updatedElement.getInterface().getInputVars()) {
            var.setValue(LibraryElementFactory.eINSTANCE.createValue());
            this.checkSourceParam(var);
        }
    }

    private void checkSourceParam(VarDeclaration var) {
        VarDeclaration srcVar = this.fbnElement.getInterface().getVariable(var.getName());
        if (srcVar != null && srcVar.getValue() != null && srcVar.getValue().getValue() != null) {
            var.getValue().setValue(srcVar.getValue().getValue());
        }
    }

    private List<ConnData> getResourceCons() {
        ArrayList<ConnData> retVal = new ArrayList<ConnData>();
        FBNetworkElement resElement = this.fbnElement.getOpposite();
        for (Connection conn : UpdateFBTypeCommand.getAllConnections(resElement)) {
            IInterfaceElement source = conn.getSource();
            IInterfaceElement dest = conn.getDestination();
            if (!source.getFBNetworkElement().isMapped() || !dest.getFBNetworkElement().isMapped()) {
                retVal.add(new ConnData(conn.getSource(), conn.getDestination()));
                continue;
            }
            if ((source.getFBNetworkElement() != resElement || dest.getFBNetworkElement().getOpposite().getFbNetwork() == this.fbnElement.getFbNetwork()) && (dest.getFBNetworkElement() != resElement || source.getFBNetworkElement().getOpposite().getFbNetwork() == this.fbnElement.getFbNetwork())) continue;
            retVal.add(new ConnData(conn.getSource(), conn.getDestination()));
        }
        return retVal;
    }

    private void recreateResourceConns(List<ConnData> resourceConns) {
        FBNetworkElement orgMappedElement = this.unmapCmd.getMappedFBNetworkElement();
        FBNetworkElement copiedMappedElement = this.updatedElement.getOpposite();
        for (ConnData connData : resourceConns) {
            AbstractConnectionCreateCommand dccc;
            IInterfaceElement source = UpdateFBTypeCommand.findUpdatedInterfaceElement(copiedMappedElement, orgMappedElement, connData.source);
            IInterfaceElement dest = UpdateFBTypeCommand.findUpdatedInterfaceElement(copiedMappedElement, orgMappedElement, connData.dest);
            if (source == null || dest == null || (dccc = UpdateFBTypeCommand.createConnCreateCMD(source, copiedMappedElement.getFbNetwork())) == null) continue;
            dccc.setSource(source);
            dccc.setDestination(dest);
            if (!dccc.canExecute()) continue;
            dccc.execute();
            this.resourceConnCreateCmds.add((Command)dccc);
        }
    }

    private static class ConnData {
        private IInterfaceElement source;
        private IInterfaceElement dest;

        public ConnData(IInterfaceElement source, IInterfaceElement dest) {
            this.source = source;
            this.dest = dest;
        }
    }
}

