/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.print;

import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.print.PrintPreview;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PrintPreviewAction
extends Action {
    private GraphicalEditor editor;
    private GraphicalViewer viewer;

    public PrintPreviewAction(GraphicalViewer viewer) {
        this.viewer = viewer;
        this.setId(ActionFactory.PRINT.getId());
        this.setText(Messages.PrintPreviewAction_LABEL_Print);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_ETOOL_PRINT_EDIT"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_ETOOL_PRINT_EDIT_DISABLED"));
    }

    public boolean isEnabled() {
        if (this.viewer != null) {
            return true;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return this.editor != null || window.getActivePage().getActiveEditor() instanceof GraphicalEditor;
    }

    public void run() {
        if (this.viewer == null) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window.getActivePage().getActiveEditor() instanceof GraphicalEditor) {
                this.editor = (GraphicalEditor)window.getActivePage().getActiveEditor();
            }
            if (this.editor != null) {
                this.viewer = (GraphicalViewer)this.editor.getAdapter(GraphicalViewer.class);
            }
        }
        if (this.viewer != null) {
            Shell shell = this.viewer.getControl().getShell();
            PrintPreview preview = new PrintPreview(shell, this.viewer, Messages.PrintPreviewAction_LABEL_PrintPreview);
            preview.setBlockOnOpen(true);
            preview.open();
        }
    }
}

