/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.deployment.Activator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class XMLFormatter {
    private int depth = -1;
    private StringBuilder formattedXml;
    private boolean lastNodeWasText;
    private String fDefaultLineDelimiter;

    private void copyNode(Reader reader, StringBuilder out) throws IOException {
        TagReader tag = TagReaderFactory.createTagReaderFor(reader);
        this.depth += tag.getPreTagDepthModifier();
        if (!this.lastNodeWasText) {
            if (tag.startsOnNewline() && !this.hasNewlineAlready(out)) {
                out.append(this.fDefaultLineDelimiter);
            }
            if (tag.requiresInitialIndent()) {
                out.append(this.indent("\t"));
            }
        }
        out.append(tag.getTagText());
        this.depth += tag.getPostTagDepthModifier();
        this.lastNodeWasText = tag.isTextNode();
    }

    public static int computeIndent(String line, int tabWidth) {
        int result = 0;
        int blanks = 0;
        int size = line.length();
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c == '\t') {
                ++result;
                blanks = 0;
            } else if (XMLFormatter.isIndentChar(c)) {
                if (++blanks == tabWidth) {
                    ++result;
                    blanks = 0;
                }
            } else {
                return result;
            }
            ++i;
        }
        return result;
    }

    public static boolean isIndentChar(char ch) {
        return Character.isWhitespace(ch) && !XMLFormatter.isLineDelimiterChar(ch);
    }

    public static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public String format(String documentText) {
        Assert.isNotNull((Object)documentText);
        StringReader reader = new StringReader(documentText);
        this.formattedXml = new StringBuilder();
        if (this.depth == -1) {
            this.depth = 0;
        }
        this.lastNodeWasText = false;
        try {
            while (true) {
                ((Reader)reader).mark(1);
                int intChar = ((Reader)reader).read();
                ((Reader)reader).reset();
                if (intChar == -1) break;
                this.copyNode(reader, this.formattedXml);
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            Activator.getDefault().logWarning("Eception during xml formating", (Exception)e);
        }
        return this.formattedXml.toString();
    }

    private boolean hasNewlineAlready(StringBuilder out) {
        return out.lastIndexOf("\n") == this.formattedXml.length() - 1 || out.lastIndexOf("\r") == this.formattedXml.length() - 1;
    }

    private String indent(String canonicalIndent) {
        StringBuilder indent = new StringBuilder(30);
        int i = 0;
        while (i < this.depth) {
            indent.append(canonicalIndent);
            ++i;
        }
        return indent.toString();
    }

    public void setInitialIndent(int indent) {
        this.depth = indent;
    }

    public static StringBuilder getLeadingWhitespace(int offset, IDocument document) {
        StringBuilder indent = new StringBuilder();
        try {
            IRegion line = document.getLineInformationOfOffset(offset);
            int lineOffset = line.getOffset();
            int nonWS = XMLFormatter.findEndOfWhiteSpace(document, lineOffset, lineOffset + line.getLength());
            indent.append(document.get(lineOffset, nonWS - lineOffset));
            return indent;
        }
        catch (BadLocationException badLocationException) {
            return indent;
        }
    }

    public static int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    public static StringBuilder createIndent() {
        StringBuilder oneIndent = new StringBuilder();
        oneIndent.append('\t');
        return oneIndent;
    }

    public void setDefaultLineDelimiter(String defaultLineDelimiter) {
        this.fDefaultLineDelimiter = defaultLineDelimiter;
    }

    private static class CommentReader
    extends TagReader {
        private boolean complete = false;

        private CommentReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public String getStartOfTag() {
            return "<!--";
        }

        @Override
        protected String readTag() throws IOException {
            int intChar;
            StringBuilder node = new StringBuilder();
            while (!this.complete && (intChar = this.getReader().read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c != '>' || !node.toString().endsWith("-->")) continue;
                this.complete = true;
            }
            return node.toString();
        }
    }

    private static class DoctypeDeclarationReader
    extends TagReader {
        private boolean complete = false;

        private DoctypeDeclarationReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public String getStartOfTag() {
            return "<!";
        }

        @Override
        protected String readTag() throws IOException {
            int intChar;
            StringBuilder node = new StringBuilder();
            while (!this.complete && (intChar = this.getReader().read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c != '>') continue;
                this.complete = true;
            }
            return node.toString();
        }
    }

    private static class ProcessingInstructionReader
    extends TagReader {
        private boolean complete = false;

        private ProcessingInstructionReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public String getStartOfTag() {
            return "<?";
        }

        @Override
        protected String readTag() throws IOException {
            int intChar;
            StringBuilder node = new StringBuilder();
            while (!this.complete && (intChar = this.getReader().read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c != '>' || !node.toString().endsWith("?>")) continue;
                this.complete = true;
            }
            return node.toString();
        }
    }

    private static abstract class TagReader {
        private Reader reader;
        private String tagText;

        private TagReader() {
        }

        protected abstract void clear();

        public Reader getReader() {
            return this.reader;
        }

        public int getPostTagDepthModifier() {
            return 0;
        }

        public int getPreTagDepthModifier() {
            return 0;
        }

        public abstract String getStartOfTag();

        public String getTagText() {
            return this.tagText;
        }

        public boolean isTextNode() {
            return false;
        }

        protected abstract String readTag() throws IOException;

        public boolean requiresInitialIndent() {
            return true;
        }

        public void setReader(Reader reader) throws IOException {
            this.reader = reader;
            this.clear();
            this.tagText = this.readTag();
        }

        public boolean startsOnNewline() {
            return true;
        }
    }

    private static class TagReaderFactory {
        private static TagReader[] tagReaders = new TagReader[]{new CommentReader(), new DoctypeDeclarationReader(), new ProcessingInstructionReader(), new XmlElementReader()};
        private static TagReader textNodeReader = new TextReader();

        private TagReaderFactory() {
        }

        public static TagReader createTagReaderFor(Reader reader) throws IOException {
            char[] buf = new char[10];
            reader.mark(10);
            reader.read(buf, 0, 10);
            reader.reset();
            String startOfTag = String.valueOf(buf);
            int i = 0;
            while (i < tagReaders.length) {
                if (startOfTag.startsWith(tagReaders[i].getStartOfTag())) {
                    tagReaders[i].setReader(reader);
                    return tagReaders[i];
                }
                ++i;
            }
            textNodeReader.setReader(reader);
            return textNodeReader;
        }
    }

    private static class TextReader
    extends TagReader {
        private boolean complete;
        private boolean isTextNode;

        private TextReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public String getStartOfTag() {
            return "";
        }

        @Override
        public boolean isTextNode() {
            return this.isTextNode;
        }

        @Override
        protected String readTag() throws IOException {
            StringBuilder node = new StringBuilder();
            while (!this.complete) {
                this.getReader().mark(1);
                int intChar = this.getReader().read();
                if (intChar == -1) break;
                char c = (char)intChar;
                if (c == '<') {
                    this.getReader().reset();
                    this.complete = true;
                    continue;
                }
                node.append(c);
            }
            if (node.length() < 1) {
                this.isTextNode = false;
            } else if (node.toString().trim().length() == 0) {
                String whitespace = node.toString();
                node = new StringBuilder();
                int i = 0;
                while (i < whitespace.length()) {
                    char whitespaceCharacter = whitespace.charAt(i);
                    if (whitespaceCharacter == '\n' || whitespaceCharacter == '\r') {
                        node.append(whitespaceCharacter);
                    }
                    ++i;
                }
                this.isTextNode = false;
            } else {
                this.isTextNode = true;
            }
            return node.toString();
        }

        @Override
        public boolean requiresInitialIndent() {
            return true;
        }

        @Override
        public boolean startsOnNewline() {
            return false;
        }
    }

    private static class XmlElementReader
    extends TagReader {
        private boolean complete = false;

        private XmlElementReader() {
        }

        @Override
        protected void clear() {
            this.complete = false;
        }

        @Override
        public int getPostTagDepthModifier() {
            if (this.getTagText().endsWith("/>") || this.getTagText().endsWith("/ >")) {
                return 0;
            }
            if (this.getTagText().startsWith("</")) {
                return 0;
            }
            return 1;
        }

        @Override
        public int getPreTagDepthModifier() {
            if (this.getTagText().startsWith("</")) {
                return -1;
            }
            return 0;
        }

        @Override
        public String getStartOfTag() {
            return "<";
        }

        @Override
        protected String readTag() throws IOException {
            int intChar;
            StringBuilder node = new StringBuilder();
            boolean insideQuote = false;
            while (!this.complete && (intChar = this.getReader().read()) != -1) {
                char c = (char)intChar;
                node.append(c);
                if (c == '\"') {
                    boolean bl = insideQuote = !insideQuote;
                }
                if (c != '>' || insideQuote) continue;
                this.complete = true;
            }
            return node.toString();
        }
    }
}

