package org.eclipse.fordiac.ide.export.forte_ng.basic

import java.nio.file.Path
import org.eclipse.fordiac.ide.export.forte_ng.ForteFBTemplate
import org.eclipse.fordiac.ide.export.forte_ng.st.STAlgorithmFilter
import org.eclipse.fordiac.ide.model.libraryElement.AdapterEvent
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType
import org.eclipse.fordiac.ide.model.libraryElement.ECState
import org.eclipse.fordiac.ide.model.libraryElement.Event
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm
import org.eclipse.xtend.lib.annotations.Accessors

class BasicFBImplTemplate extends ForteFBTemplate {

	@Accessors(PROTECTED_GETTER) BasicFBType type
	extension STAlgorithmFilter stAlgorithmFilter = new STAlgorithmFilter

	new(BasicFBType type, String name, Path prefix) {
		super(name, prefix)
		this.type = type
	}

	override generate() '''
		«generateHeader»
		
		«generateImplIncludes»
		
		«generateFBDefinition»
		
		«generateFBInterfaceDefinition»
		
		«generateFBInterfaceSpecDefinition»
		
		«generateAlgorithms»
		
		«generateStates»
		
		«generateECC»
		
	'''

	def protected CharSequence generateAlgorithms() '''
		«FOR alg : type.algorithm»
			«alg.generateAlgorithm»
			
		«ENDFOR»
	'''

	def protected dispatch CharSequence generateAlgorithm(Algorithm alg) {
		errors.add('''Cannot export algorithm «alg.class»''')
		return ""
	}

	def protected dispatch CharSequence generateAlgorithm(STAlgorithm alg) '''
		void «FBClassName»::alg_«alg.name»(void) {
		  «alg.generate(errors)»
		}
	'''

	def protected CharSequence generateStates() '''
		«FOR state : type.ECC.ECState»
			«state.generateState»
			
		«ENDFOR»
	'''

	def protected CharSequence generateState(ECState state) '''
		void «FBClassName»::enterState«state.name»(void) {
		  m_nECCState = scm_nState«state.name»;
		  «FOR action : state.ECAction»
		  	«IF action.algorithm !== null»
		  		alg_«action.algorithm.name»();
		  	«ENDIF»
		  	«IF action.output !== null»
		  		«action.output.generateSendEvent»
		  	«ENDIF»
		  «ENDFOR»
		}
	'''

	def protected dispatch CharSequence generateSendEvent(Event event) '''
		sendOutputEvent(scm_nEvent«event.name»ID);
	'''

	def protected dispatch CharSequence generateSendEvent(AdapterEvent event) '''
		sendAdapterEvent(scm_n«event.adapterDeclaration.name»AdpNum, FORTE_«event.adapterDeclaration.adapterFB.name»::scm_nEvent«event.name»ID);
	'''
	
	def protected CharSequence generateECC() '''
		void «FBClassName»::executeEvent(int pa_nEIID){
		  bool bTransitionCleared;
		  do {
		    bTransitionCleared = true;
		    switch(m_nECCState) {
		      «FOR state : type.ECC.ECState»
		      	case scm_nState«state.name»:
		      	  «FOR transition : state.outTransitions SEPARATOR "\nelse"»
		      	  	«IF transition.conditionEvent !== null && !transition.conditionExpression.nullOrEmpty»
		      	  		if((scm_nEvent«transition.conditionEvent.name»ID == pa_nEIID) && («transition.conditionExpression.generate(type, errors)»))
		      	  	«ELSEIF transition.conditionEvent !== null»
		      	  		if(scm_nEvent«transition.conditionEvent.name»ID == pa_nEIID)
		      	  	«ELSEIF !transition.conditionExpression.nullOrEmpty»
		      	  		if(«transition.conditionExpression.generate(type, errors)»)
		      	  	«ELSE»
		      	  		if(1) {
		      	  	«ENDIF»
		      	  	  enterState«transition.destination.name»();
		      	  «ENDFOR»
		      	  else
		      	    bTransitionCleared  = false; //no transition cleared
		      	  break;
		      «ENDFOR»
		      default:
		        DEVLOG_ERROR("The state is not in the valid range! The state value is: %d. The max value can be: «type.ECC.ECState.size».", m_nECCState.operator TForteUInt16 ());
		        m_nECCState = 0; // 0 is always the initial state
		        break;
		    }
		    pa_nEIID = cg_nInvalidEventID; // we have to clear the event after the first check in order to ensure correct behavior
		  } while(bTransitionCleared);
		}
	'''
}
